/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.FacetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Facet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Facet> {
    private static final SdkField<String> DOCUMENT_ATTRIBUTE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentAttributeKey").getter(Facet.getter(Facet::documentAttributeKey)).setter(Facet.setter(Builder::documentAttributeKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentAttributeKey").build()}).build();
    private static final SdkField<List<Facet>> FACETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Facets").getter(Facet.getter(Facet::facets)).setter(Facet.setter(Builder::facets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Facets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Facet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(Facet.getter(Facet::maxResults)).setter(Facet.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_ATTRIBUTE_KEY_FIELD, FACETS_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DocumentAttributeKey", DOCUMENT_ATTRIBUTE_KEY_FIELD);
            this.put("Facets", FACETS_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String documentAttributeKey;
    private final List<Facet> facets;
    private final Integer maxResults;

    private Facet(BuilderImpl builder) {
        this.documentAttributeKey = builder.documentAttributeKey;
        this.facets = builder.facets;
        this.maxResults = builder.maxResults;
    }

    public final String documentAttributeKey() {
        return this.documentAttributeKey;
    }

    public final boolean hasFacets() {
        return this.facets != null && !(this.facets instanceof SdkAutoConstructList);
    }

    public final List<Facet> facets() {
        return this.facets;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.documentAttributeKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFacets() ? this.facets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Facet)) {
            return false;
        }
        Facet other = (Facet)obj;
        return Objects.equals(this.documentAttributeKey(), other.documentAttributeKey()) && this.hasFacets() == other.hasFacets() && Objects.equals(this.facets(), other.facets()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"Facet").add("DocumentAttributeKey", (Object)this.documentAttributeKey()).add("Facets", this.hasFacets() ? this.facets() : null).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentAttributeKey": {
                return Optional.ofNullable(clazz.cast(this.documentAttributeKey()));
            }
            case "Facets": {
                return Optional.ofNullable(clazz.cast(this.facets()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Facet, T> g) {
        return obj -> g.apply((Facet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String documentAttributeKey;
        private List<Facet> facets = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(Facet model) {
            this.documentAttributeKey(model.documentAttributeKey);
            this.facets(model.facets);
            this.maxResults(model.maxResults);
        }

        public final String getDocumentAttributeKey() {
            return this.documentAttributeKey;
        }

        public final void setDocumentAttributeKey(String documentAttributeKey) {
            this.documentAttributeKey = documentAttributeKey;
        }

        @Override
        public final Builder documentAttributeKey(String documentAttributeKey) {
            this.documentAttributeKey = documentAttributeKey;
            return this;
        }

        public final List<Builder> getFacets() {
            List<Builder> result = FacetListCopier.copyToBuilder(this.facets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFacets(Collection<BuilderImpl> facets) {
            this.facets = FacetListCopier.copyFromBuilder(facets);
        }

        @Override
        public final Builder facets(Collection<Facet> facets) {
            this.facets = FacetListCopier.copy(facets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder facets(Facet ... facets) {
            this.facets(Arrays.asList(facets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder facets(Consumer<Builder> ... facets) {
            this.facets(Stream.of(facets).map(c -> (Facet)((Builder)Facet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public Facet build() {
            return new Facet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Facet> {
        public Builder documentAttributeKey(String var1);

        public Builder facets(Collection<Facet> var1);

        public Builder facets(Facet ... var1);

        public Builder facets(Consumer<Builder> ... var1);

        public Builder maxResults(Integer var1);
    }
}

