/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableCell
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableCell> {
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Value").getter(TableCell.getter(TableCell::value)).setter(TableCell.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<Boolean> TOP_ANSWER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TopAnswer").getter(TableCell.getter(TableCell::topAnswer)).setter(TableCell.setter(Builder::topAnswer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopAnswer").build()}).build();
    private static final SdkField<Boolean> HIGHLIGHTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Highlighted").getter(TableCell.getter(TableCell::highlighted)).setter(TableCell.setter(Builder::highlighted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Highlighted").build()}).build();
    private static final SdkField<Boolean> HEADER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Header").getter(TableCell.getter(TableCell::header)).setter(TableCell.setter(Builder::header)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Header").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, TOP_ANSWER_FIELD, HIGHLIGHTED_FIELD, HEADER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Value", VALUE_FIELD);
            this.put("TopAnswer", TOP_ANSWER_FIELD);
            this.put("Highlighted", HIGHLIGHTED_FIELD);
            this.put("Header", HEADER_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String value;
    private final Boolean topAnswer;
    private final Boolean highlighted;
    private final Boolean header;

    private TableCell(BuilderImpl builder) {
        this.value = builder.value;
        this.topAnswer = builder.topAnswer;
        this.highlighted = builder.highlighted;
        this.header = builder.header;
    }

    public final String value() {
        return this.value;
    }

    public final Boolean topAnswer() {
        return this.topAnswer;
    }

    public final Boolean highlighted() {
        return this.highlighted;
    }

    public final Boolean header() {
        return this.header;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.topAnswer());
        hashCode = 31 * hashCode + Objects.hashCode(this.highlighted());
        hashCode = 31 * hashCode + Objects.hashCode(this.header());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableCell)) {
            return false;
        }
        TableCell other = (TableCell)obj;
        return Objects.equals(this.value(), other.value()) && Objects.equals(this.topAnswer(), other.topAnswer()) && Objects.equals(this.highlighted(), other.highlighted()) && Objects.equals(this.header(), other.header());
    }

    public final String toString() {
        return ToString.builder((String)"TableCell").add("Value", (Object)this.value()).add("TopAnswer", (Object)this.topAnswer()).add("Highlighted", (Object)this.highlighted()).add("Header", (Object)this.header()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "TopAnswer": {
                return Optional.ofNullable(clazz.cast(this.topAnswer()));
            }
            case "Highlighted": {
                return Optional.ofNullable(clazz.cast(this.highlighted()));
            }
            case "Header": {
                return Optional.ofNullable(clazz.cast(this.header()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TableCell, T> g) {
        return obj -> g.apply((TableCell)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String value;
        private Boolean topAnswer;
        private Boolean highlighted;
        private Boolean header;

        private BuilderImpl() {
        }

        private BuilderImpl(TableCell model) {
            this.value(model.value);
            this.topAnswer(model.topAnswer);
            this.highlighted(model.highlighted);
            this.header(model.header);
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final Boolean getTopAnswer() {
            return this.topAnswer;
        }

        public final void setTopAnswer(Boolean topAnswer) {
            this.topAnswer = topAnswer;
        }

        @Override
        public final Builder topAnswer(Boolean topAnswer) {
            this.topAnswer = topAnswer;
            return this;
        }

        public final Boolean getHighlighted() {
            return this.highlighted;
        }

        public final void setHighlighted(Boolean highlighted) {
            this.highlighted = highlighted;
        }

        @Override
        public final Builder highlighted(Boolean highlighted) {
            this.highlighted = highlighted;
            return this;
        }

        public final Boolean getHeader() {
            return this.header;
        }

        public final void setHeader(Boolean header) {
            this.header = header;
        }

        @Override
        public final Builder header(Boolean header) {
            this.header = header;
            return this;
        }

        public TableCell build() {
            return new TableCell(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableCell> {
        public Builder value(String var1);

        public Builder topAnswer(Boolean var1);

        public Builder highlighted(Boolean var1);

        public Builder header(Boolean var1);
    }
}

