/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.TableRow;
import software.amazon.awssdk.services.kendra.model.TableRowListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableExcerpt
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableExcerpt> {
    private static final SdkField<List<TableRow>> ROWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rows").getter(TableExcerpt.getter(TableExcerpt::rows)).setter(TableExcerpt.setter(Builder::rows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TableRow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> TOTAL_NUMBER_OF_ROWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalNumberOfRows").getter(TableExcerpt.getter(TableExcerpt::totalNumberOfRows)).setter(TableExcerpt.setter(Builder::totalNumberOfRows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalNumberOfRows").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROWS_FIELD, TOTAL_NUMBER_OF_ROWS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Rows", ROWS_FIELD);
            this.put("TotalNumberOfRows", TOTAL_NUMBER_OF_ROWS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<TableRow> rows;
    private final Integer totalNumberOfRows;

    private TableExcerpt(BuilderImpl builder) {
        this.rows = builder.rows;
        this.totalNumberOfRows = builder.totalNumberOfRows;
    }

    public final boolean hasRows() {
        return this.rows != null && !(this.rows instanceof SdkAutoConstructList);
    }

    public final List<TableRow> rows() {
        return this.rows;
    }

    public final Integer totalNumberOfRows() {
        return this.totalNumberOfRows;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRows() ? this.rows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.totalNumberOfRows());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableExcerpt)) {
            return false;
        }
        TableExcerpt other = (TableExcerpt)obj;
        return this.hasRows() == other.hasRows() && Objects.equals(this.rows(), other.rows()) && Objects.equals(this.totalNumberOfRows(), other.totalNumberOfRows());
    }

    public final String toString() {
        return ToString.builder((String)"TableExcerpt").add("Rows", this.hasRows() ? this.rows() : null).add("TotalNumberOfRows", (Object)this.totalNumberOfRows()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Rows": {
                return Optional.ofNullable(clazz.cast(this.rows()));
            }
            case "TotalNumberOfRows": {
                return Optional.ofNullable(clazz.cast(this.totalNumberOfRows()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TableExcerpt, T> g) {
        return obj -> g.apply((TableExcerpt)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<TableRow> rows = DefaultSdkAutoConstructList.getInstance();
        private Integer totalNumberOfRows;

        private BuilderImpl() {
        }

        private BuilderImpl(TableExcerpt model) {
            this.rows(model.rows);
            this.totalNumberOfRows(model.totalNumberOfRows);
        }

        public final List<TableRow.Builder> getRows() {
            List<TableRow.Builder> result = TableRowListCopier.copyToBuilder(this.rows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRows(Collection<TableRow.BuilderImpl> rows) {
            this.rows = TableRowListCopier.copyFromBuilder(rows);
        }

        @Override
        public final Builder rows(Collection<TableRow> rows) {
            this.rows = TableRowListCopier.copy(rows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rows(TableRow ... rows) {
            this.rows(Arrays.asList(rows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rows(Consumer<TableRow.Builder> ... rows) {
            this.rows(Stream.of(rows).map(c -> (TableRow)((TableRow.Builder)TableRow.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getTotalNumberOfRows() {
            return this.totalNumberOfRows;
        }

        public final void setTotalNumberOfRows(Integer totalNumberOfRows) {
            this.totalNumberOfRows = totalNumberOfRows;
        }

        @Override
        public final Builder totalNumberOfRows(Integer totalNumberOfRows) {
            this.totalNumberOfRows = totalNumberOfRows;
            return this;
        }

        public TableExcerpt build() {
            return new TableExcerpt(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableExcerpt> {
        public Builder rows(Collection<TableRow> var1);

        public Builder rows(TableRow ... var1);

        public Builder rows(Consumer<TableRow.Builder> ... var1);

        public Builder totalNumberOfRows(Integer var1);
    }
}

