/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.DocumentAttribute;
import software.amazon.awssdk.services.kendra.model.ExpandedResultItem;
import software.amazon.awssdk.services.kendra.model.ExpandedResultListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CollapsedResultDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CollapsedResultDetail> {
    private static final SdkField<DocumentAttribute> DOCUMENT_ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DocumentAttribute").getter(CollapsedResultDetail.getter(CollapsedResultDetail::documentAttribute)).setter(CollapsedResultDetail.setter(Builder::documentAttribute)).constructor(DocumentAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentAttribute").build()}).build();
    private static final SdkField<List<ExpandedResultItem>> EXPANDED_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExpandedResults").getter(CollapsedResultDetail.getter(CollapsedResultDetail::expandedResults)).setter(CollapsedResultDetail.setter(Builder::expandedResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpandedResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExpandedResultItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_ATTRIBUTE_FIELD, EXPANDED_RESULTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final DocumentAttribute documentAttribute;
    private final List<ExpandedResultItem> expandedResults;

    private CollapsedResultDetail(BuilderImpl builder) {
        this.documentAttribute = builder.documentAttribute;
        this.expandedResults = builder.expandedResults;
    }

    public final DocumentAttribute documentAttribute() {
        return this.documentAttribute;
    }

    public final boolean hasExpandedResults() {
        return this.expandedResults != null && !(this.expandedResults instanceof SdkAutoConstructList);
    }

    public final List<ExpandedResultItem> expandedResults() {
        return this.expandedResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.documentAttribute());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExpandedResults() ? this.expandedResults() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CollapsedResultDetail)) {
            return false;
        }
        CollapsedResultDetail other = (CollapsedResultDetail)obj;
        return Objects.equals(this.documentAttribute(), other.documentAttribute()) && this.hasExpandedResults() == other.hasExpandedResults() && Objects.equals(this.expandedResults(), other.expandedResults());
    }

    public final String toString() {
        return ToString.builder((String)"CollapsedResultDetail").add("DocumentAttribute", (Object)this.documentAttribute()).add("ExpandedResults", this.hasExpandedResults() ? this.expandedResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentAttribute": {
                return Optional.ofNullable(clazz.cast(this.documentAttribute()));
            }
            case "ExpandedResults": {
                return Optional.ofNullable(clazz.cast(this.expandedResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CollapsedResultDetail, T> g) {
        return obj -> g.apply((CollapsedResultDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DocumentAttribute documentAttribute;
        private List<ExpandedResultItem> expandedResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CollapsedResultDetail model) {
            this.documentAttribute(model.documentAttribute);
            this.expandedResults(model.expandedResults);
        }

        public final DocumentAttribute.Builder getDocumentAttribute() {
            return this.documentAttribute != null ? this.documentAttribute.toBuilder() : null;
        }

        public final void setDocumentAttribute(DocumentAttribute.BuilderImpl documentAttribute) {
            this.documentAttribute = documentAttribute != null ? documentAttribute.build() : null;
        }

        @Override
        public final Builder documentAttribute(DocumentAttribute documentAttribute) {
            this.documentAttribute = documentAttribute;
            return this;
        }

        public final List<ExpandedResultItem.Builder> getExpandedResults() {
            List<ExpandedResultItem.Builder> result = ExpandedResultListCopier.copyToBuilder(this.expandedResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExpandedResults(Collection<ExpandedResultItem.BuilderImpl> expandedResults) {
            this.expandedResults = ExpandedResultListCopier.copyFromBuilder(expandedResults);
        }

        @Override
        public final Builder expandedResults(Collection<ExpandedResultItem> expandedResults) {
            this.expandedResults = ExpandedResultListCopier.copy(expandedResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expandedResults(ExpandedResultItem ... expandedResults) {
            this.expandedResults(Arrays.asList(expandedResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expandedResults(Consumer<ExpandedResultItem.Builder> ... expandedResults) {
            this.expandedResults(Stream.of(expandedResults).map(c -> (ExpandedResultItem)((ExpandedResultItem.Builder)ExpandedResultItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CollapsedResultDetail build() {
            return new CollapsedResultDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CollapsedResultDetail> {
        public Builder documentAttribute(DocumentAttribute var1);

        default public Builder documentAttribute(Consumer<DocumentAttribute.Builder> documentAttribute) {
            return this.documentAttribute((DocumentAttribute)((DocumentAttribute.Builder)DocumentAttribute.builder().applyMutation(documentAttribute)).build());
        }

        public Builder expandedResults(Collection<ExpandedResultItem> var1);

        public Builder expandedResults(ExpandedResultItem ... var1);

        public Builder expandedResults(Consumer<ExpandedResultItem.Builder> ... var1);
    }
}

