/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kendra.model.EndpointType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExperienceEndpoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExperienceEndpoint> {
    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointType").getter(ExperienceEndpoint.getter(ExperienceEndpoint::endpointTypeAsString)).setter(ExperienceEndpoint.setter(Builder::endpointType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Endpoint").getter(ExperienceEndpoint.getter(ExperienceEndpoint::endpoint)).setter(ExperienceEndpoint.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_TYPE_FIELD, ENDPOINT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String endpointType;
    private final String endpoint;

    private ExperienceEndpoint(BuilderImpl builder) {
        this.endpointType = builder.endpointType;
        this.endpoint = builder.endpoint;
    }

    public final EndpointType endpointType() {
        return EndpointType.fromValue(this.endpointType);
    }

    public final String endpointTypeAsString() {
        return this.endpointType;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperienceEndpoint)) {
            return false;
        }
        ExperienceEndpoint other = (ExperienceEndpoint)obj;
        return Objects.equals(this.endpointTypeAsString(), other.endpointTypeAsString()) && Objects.equals(this.endpoint(), other.endpoint());
    }

    public final String toString() {
        return ToString.builder((String)"ExperienceEndpoint").add("EndpointType", (Object)this.endpointTypeAsString()).add("Endpoint", (Object)this.endpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointType": {
                return Optional.ofNullable(clazz.cast(this.endpointTypeAsString()));
            }
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExperienceEndpoint, T> g) {
        return obj -> g.apply((ExperienceEndpoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String endpointType;
        private String endpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(ExperienceEndpoint model) {
            this.endpointType(model.endpointType);
            this.endpoint(model.endpoint);
        }

        public final String getEndpointType() {
            return this.endpointType;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        @Override
        public final Builder endpointType(EndpointType endpointType) {
            this.endpointType(endpointType == null ? null : endpointType.toString());
            return this;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public ExperienceEndpoint build() {
            return new ExperienceEndpoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExperienceEndpoint> {
        public Builder endpointType(String var1);

        public Builder endpointType(EndpointType var1);

        public Builder endpoint(String var1);
    }
}

