/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.TableCell;
import software.amazon.awssdk.services.kendra.model.TableCellListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableRow
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableRow> {
    private static final SdkField<List<TableCell>> CELLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Cells").getter(TableRow.getter(TableRow::cells)).setter(TableRow.setter(Builder::cells)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cells").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TableCell::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CELLS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<TableCell> cells;

    private TableRow(BuilderImpl builder) {
        this.cells = builder.cells;
    }

    public final boolean hasCells() {
        return this.cells != null && !(this.cells instanceof SdkAutoConstructList);
    }

    public final List<TableCell> cells() {
        return this.cells;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCells() ? this.cells() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableRow)) {
            return false;
        }
        TableRow other = (TableRow)obj;
        return this.hasCells() == other.hasCells() && Objects.equals(this.cells(), other.cells());
    }

    public final String toString() {
        return ToString.builder((String)"TableRow").add("Cells", this.hasCells() ? this.cells() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Cells": {
                return Optional.ofNullable(clazz.cast(this.cells()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableRow, T> g) {
        return obj -> g.apply((TableRow)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<TableCell> cells = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TableRow model) {
            this.cells(model.cells);
        }

        public final List<TableCell.Builder> getCells() {
            List<TableCell.Builder> result = TableCellListCopier.copyToBuilder(this.cells);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCells(Collection<TableCell.BuilderImpl> cells) {
            this.cells = TableCellListCopier.copyFromBuilder(cells);
        }

        @Override
        public final Builder cells(Collection<TableCell> cells) {
            this.cells = TableCellListCopier.copy(cells);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cells(TableCell ... cells) {
            this.cells(Arrays.asList(cells));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cells(Consumer<TableCell.Builder> ... cells) {
            this.cells(Stream.of(cells).map(c -> (TableCell)((TableCell.Builder)TableCell.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TableRow build() {
            return new TableRow(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableRow> {
        public Builder cells(Collection<TableCell> var1);

        public Builder cells(TableCell ... var1);

        public Builder cells(Consumer<TableCell.Builder> ... var1);
    }
}

