/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kendra.model.Persona;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EntityPersonaConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EntityPersonaConfiguration> {
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntityId").getter(EntityPersonaConfiguration.getter(EntityPersonaConfiguration::entityId)).setter(EntityPersonaConfiguration.setter(Builder::entityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityId").build()}).build();
    private static final SdkField<String> PERSONA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Persona").getter(EntityPersonaConfiguration.getter(EntityPersonaConfiguration::personaAsString)).setter(EntityPersonaConfiguration.setter(Builder::persona)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Persona").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_ID_FIELD, PERSONA_FIELD));
    private static final long serialVersionUID = 1L;
    private final String entityId;
    private final String persona;

    private EntityPersonaConfiguration(BuilderImpl builder) {
        this.entityId = builder.entityId;
        this.persona = builder.persona;
    }

    public final String entityId() {
        return this.entityId;
    }

    public final Persona persona() {
        return Persona.fromValue(this.persona);
    }

    public final String personaAsString() {
        return this.persona;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.personaAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityPersonaConfiguration)) {
            return false;
        }
        EntityPersonaConfiguration other = (EntityPersonaConfiguration)obj;
        return Objects.equals(this.entityId(), other.entityId()) && Objects.equals(this.personaAsString(), other.personaAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EntityPersonaConfiguration").add("EntityId", (Object)this.entityId()).add("Persona", (Object)this.personaAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EntityId": {
                return Optional.ofNullable(clazz.cast(this.entityId()));
            }
            case "Persona": {
                return Optional.ofNullable(clazz.cast(this.personaAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntityPersonaConfiguration, T> g) {
        return obj -> g.apply((EntityPersonaConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String entityId;
        private String persona;

        private BuilderImpl() {
        }

        private BuilderImpl(EntityPersonaConfiguration model) {
            this.entityId(model.entityId);
            this.persona(model.persona);
        }

        public final String getEntityId() {
            return this.entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getPersona() {
            return this.persona;
        }

        public final void setPersona(String persona) {
            this.persona = persona;
        }

        @Override
        public final Builder persona(String persona) {
            this.persona = persona;
            return this;
        }

        @Override
        public final Builder persona(Persona persona) {
            this.persona(persona == null ? null : persona.toString());
            return this;
        }

        public EntityPersonaConfiguration build() {
            return new EntityPersonaConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EntityPersonaConfiguration> {
        public Builder entityId(String var1);

        public Builder persona(String var1);

        public Builder persona(Persona var1);
    }
}

