/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the configuration information to connect to GitHub as your data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GitHubConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<GitHubConfiguration.Builder, GitHubConfiguration> {
    private static final SdkField<SaaSConfiguration> SAA_S_CONFIGURATION_FIELD = SdkField
            .<SaaSConfiguration> builder(MarshallingType.SDK_POJO).memberName("SaaSConfiguration")
            .getter(getter(GitHubConfiguration::saaSConfiguration)).setter(setter(Builder::saaSConfiguration))
            .constructor(SaaSConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SaaSConfiguration").build()).build();

    private static final SdkField<OnPremiseConfiguration> ON_PREMISE_CONFIGURATION_FIELD = SdkField
            .<OnPremiseConfiguration> builder(MarshallingType.SDK_POJO).memberName("OnPremiseConfiguration")
            .getter(getter(GitHubConfiguration::onPremiseConfiguration)).setter(setter(Builder::onPremiseConfiguration))
            .constructor(OnPremiseConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnPremiseConfiguration").build())
            .build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(GitHubConfiguration::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretArn").getter(getter(GitHubConfiguration::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()).build();

    private static final SdkField<Boolean> USE_CHANGE_LOG_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseChangeLog").getter(getter(GitHubConfiguration::useChangeLog)).setter(setter(Builder::useChangeLog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseChangeLog").build()).build();

    private static final SdkField<GitHubDocumentCrawlProperties> GIT_HUB_DOCUMENT_CRAWL_PROPERTIES_FIELD = SdkField
            .<GitHubDocumentCrawlProperties> builder(MarshallingType.SDK_POJO)
            .memberName("GitHubDocumentCrawlProperties")
            .getter(getter(GitHubConfiguration::gitHubDocumentCrawlProperties))
            .setter(setter(Builder::gitHubDocumentCrawlProperties))
            .constructor(GitHubDocumentCrawlProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GitHubDocumentCrawlProperties")
                    .build()).build();

    private static final SdkField<List<String>> REPOSITORY_FILTER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RepositoryFilter")
            .getter(getter(GitHubConfiguration::repositoryFilter))
            .setter(setter(Builder::repositoryFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryFilter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> INCLUSION_FOLDER_NAME_PATTERNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InclusionFolderNamePatterns")
            .getter(getter(GitHubConfiguration::inclusionFolderNamePatterns))
            .setter(setter(Builder::inclusionFolderNamePatterns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionFolderNamePatterns")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> INCLUSION_FILE_TYPE_PATTERNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InclusionFileTypePatterns")
            .getter(getter(GitHubConfiguration::inclusionFileTypePatterns))
            .setter(setter(Builder::inclusionFileTypePatterns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionFileTypePatterns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> INCLUSION_FILE_NAME_PATTERNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InclusionFileNamePatterns")
            .getter(getter(GitHubConfiguration::inclusionFileNamePatterns))
            .setter(setter(Builder::inclusionFileNamePatterns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionFileNamePatterns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EXCLUSION_FOLDER_NAME_PATTERNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExclusionFolderNamePatterns")
            .getter(getter(GitHubConfiguration::exclusionFolderNamePatterns))
            .setter(setter(Builder::exclusionFolderNamePatterns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusionFolderNamePatterns")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EXCLUSION_FILE_TYPE_PATTERNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExclusionFileTypePatterns")
            .getter(getter(GitHubConfiguration::exclusionFileTypePatterns))
            .setter(setter(Builder::exclusionFileTypePatterns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusionFileTypePatterns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EXCLUSION_FILE_NAME_PATTERNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExclusionFileNamePatterns")
            .getter(getter(GitHubConfiguration::exclusionFileNamePatterns))
            .setter(setter(Builder::exclusionFileNamePatterns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusionFileNamePatterns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DataSourceVpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField
            .<DataSourceVpcConfiguration> builder(MarshallingType.SDK_POJO).memberName("VpcConfiguration")
            .getter(getter(GitHubConfiguration::vpcConfiguration)).setter(setter(Builder::vpcConfiguration))
            .constructor(DataSourceVpcConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration").build()).build();

    private static final SdkField<List<DataSourceToIndexFieldMapping>> GIT_HUB_REPOSITORY_CONFIGURATION_FIELD_MAPPINGS_FIELD = SdkField
            .<List<DataSourceToIndexFieldMapping>> builder(MarshallingType.LIST)
            .memberName("GitHubRepositoryConfigurationFieldMappings")
            .getter(getter(GitHubConfiguration::gitHubRepositoryConfigurationFieldMappings))
            .setter(setter(Builder::gitHubRepositoryConfigurationFieldMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("GitHubRepositoryConfigurationFieldMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSourceToIndexFieldMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSourceToIndexFieldMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DataSourceToIndexFieldMapping>> GIT_HUB_COMMIT_CONFIGURATION_FIELD_MAPPINGS_FIELD = SdkField
            .<List<DataSourceToIndexFieldMapping>> builder(MarshallingType.LIST)
            .memberName("GitHubCommitConfigurationFieldMappings")
            .getter(getter(GitHubConfiguration::gitHubCommitConfigurationFieldMappings))
            .setter(setter(Builder::gitHubCommitConfigurationFieldMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("GitHubCommitConfigurationFieldMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSourceToIndexFieldMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSourceToIndexFieldMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DataSourceToIndexFieldMapping>> GIT_HUB_ISSUE_DOCUMENT_CONFIGURATION_FIELD_MAPPINGS_FIELD = SdkField
            .<List<DataSourceToIndexFieldMapping>> builder(MarshallingType.LIST)
            .memberName("GitHubIssueDocumentConfigurationFieldMappings")
            .getter(getter(GitHubConfiguration::gitHubIssueDocumentConfigurationFieldMappings))
            .setter(setter(Builder::gitHubIssueDocumentConfigurationFieldMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("GitHubIssueDocumentConfigurationFieldMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSourceToIndexFieldMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSourceToIndexFieldMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DataSourceToIndexFieldMapping>> GIT_HUB_ISSUE_COMMENT_CONFIGURATION_FIELD_MAPPINGS_FIELD = SdkField
            .<List<DataSourceToIndexFieldMapping>> builder(MarshallingType.LIST)
            .memberName("GitHubIssueCommentConfigurationFieldMappings")
            .getter(getter(GitHubConfiguration::gitHubIssueCommentConfigurationFieldMappings))
            .setter(setter(Builder::gitHubIssueCommentConfigurationFieldMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("GitHubIssueCommentConfigurationFieldMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSourceToIndexFieldMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSourceToIndexFieldMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DataSourceToIndexFieldMapping>> GIT_HUB_ISSUE_ATTACHMENT_CONFIGURATION_FIELD_MAPPINGS_FIELD = SdkField
            .<List<DataSourceToIndexFieldMapping>> builder(MarshallingType.LIST)
            .memberName("GitHubIssueAttachmentConfigurationFieldMappings")
            .getter(getter(GitHubConfiguration::gitHubIssueAttachmentConfigurationFieldMappings))
            .setter(setter(Builder::gitHubIssueAttachmentConfigurationFieldMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("GitHubIssueAttachmentConfigurationFieldMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSourceToIndexFieldMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSourceToIndexFieldMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DataSourceToIndexFieldMapping>> GIT_HUB_PULL_REQUEST_COMMENT_CONFIGURATION_FIELD_MAPPINGS_FIELD = SdkField
            .<List<DataSourceToIndexFieldMapping>> builder(MarshallingType.LIST)
            .memberName("GitHubPullRequestCommentConfigurationFieldMappings")
            .getter(getter(GitHubConfiguration::gitHubPullRequestCommentConfigurationFieldMappings))
            .setter(setter(Builder::gitHubPullRequestCommentConfigurationFieldMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("GitHubPullRequestCommentConfigurationFieldMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSourceToIndexFieldMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSourceToIndexFieldMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DataSourceToIndexFieldMapping>> GIT_HUB_PULL_REQUEST_DOCUMENT_CONFIGURATION_FIELD_MAPPINGS_FIELD = SdkField
            .<List<DataSourceToIndexFieldMapping>> builder(MarshallingType.LIST)
            .memberName("GitHubPullRequestDocumentConfigurationFieldMappings")
            .getter(getter(GitHubConfiguration::gitHubPullRequestDocumentConfigurationFieldMappings))
            .setter(setter(Builder::gitHubPullRequestDocumentConfigurationFieldMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("GitHubPullRequestDocumentConfigurationFieldMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSourceToIndexFieldMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSourceToIndexFieldMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DataSourceToIndexFieldMapping>> GIT_HUB_PULL_REQUEST_DOCUMENT_ATTACHMENT_CONFIGURATION_FIELD_MAPPINGS_FIELD = SdkField
            .<List<DataSourceToIndexFieldMapping>> builder(MarshallingType.LIST)
            .memberName("GitHubPullRequestDocumentAttachmentConfigurationFieldMappings")
            .getter(getter(GitHubConfiguration::gitHubPullRequestDocumentAttachmentConfigurationFieldMappings))
            .setter(setter(Builder::gitHubPullRequestDocumentAttachmentConfigurationFieldMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("GitHubPullRequestDocumentAttachmentConfigurationFieldMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSourceToIndexFieldMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSourceToIndexFieldMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAA_S_CONFIGURATION_FIELD,
            ON_PREMISE_CONFIGURATION_FIELD, TYPE_FIELD, SECRET_ARN_FIELD, USE_CHANGE_LOG_FIELD,
            GIT_HUB_DOCUMENT_CRAWL_PROPERTIES_FIELD, REPOSITORY_FILTER_FIELD, INCLUSION_FOLDER_NAME_PATTERNS_FIELD,
            INCLUSION_FILE_TYPE_PATTERNS_FIELD, INCLUSION_FILE_NAME_PATTERNS_FIELD, EXCLUSION_FOLDER_NAME_PATTERNS_FIELD,
            EXCLUSION_FILE_TYPE_PATTERNS_FIELD, EXCLUSION_FILE_NAME_PATTERNS_FIELD, VPC_CONFIGURATION_FIELD,
            GIT_HUB_REPOSITORY_CONFIGURATION_FIELD_MAPPINGS_FIELD, GIT_HUB_COMMIT_CONFIGURATION_FIELD_MAPPINGS_FIELD,
            GIT_HUB_ISSUE_DOCUMENT_CONFIGURATION_FIELD_MAPPINGS_FIELD, GIT_HUB_ISSUE_COMMENT_CONFIGURATION_FIELD_MAPPINGS_FIELD,
            GIT_HUB_ISSUE_ATTACHMENT_CONFIGURATION_FIELD_MAPPINGS_FIELD,
            GIT_HUB_PULL_REQUEST_COMMENT_CONFIGURATION_FIELD_MAPPINGS_FIELD,
            GIT_HUB_PULL_REQUEST_DOCUMENT_CONFIGURATION_FIELD_MAPPINGS_FIELD,
            GIT_HUB_PULL_REQUEST_DOCUMENT_ATTACHMENT_CONFIGURATION_FIELD_MAPPINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final SaaSConfiguration saaSConfiguration;

    private final OnPremiseConfiguration onPremiseConfiguration;

    private final String type;

    private final String secretArn;

    private final Boolean useChangeLog;

    private final GitHubDocumentCrawlProperties gitHubDocumentCrawlProperties;

    private final List<String> repositoryFilter;

    private final List<String> inclusionFolderNamePatterns;

    private final List<String> inclusionFileTypePatterns;

    private final List<String> inclusionFileNamePatterns;

    private final List<String> exclusionFolderNamePatterns;

    private final List<String> exclusionFileTypePatterns;

    private final List<String> exclusionFileNamePatterns;

    private final DataSourceVpcConfiguration vpcConfiguration;

    private final List<DataSourceToIndexFieldMapping> gitHubRepositoryConfigurationFieldMappings;

    private final List<DataSourceToIndexFieldMapping> gitHubCommitConfigurationFieldMappings;

    private final List<DataSourceToIndexFieldMapping> gitHubIssueDocumentConfigurationFieldMappings;

    private final List<DataSourceToIndexFieldMapping> gitHubIssueCommentConfigurationFieldMappings;

    private final List<DataSourceToIndexFieldMapping> gitHubIssueAttachmentConfigurationFieldMappings;

    private final List<DataSourceToIndexFieldMapping> gitHubPullRequestCommentConfigurationFieldMappings;

    private final List<DataSourceToIndexFieldMapping> gitHubPullRequestDocumentConfigurationFieldMappings;

    private final List<DataSourceToIndexFieldMapping> gitHubPullRequestDocumentAttachmentConfigurationFieldMappings;

    private GitHubConfiguration(BuilderImpl builder) {
        this.saaSConfiguration = builder.saaSConfiguration;
        this.onPremiseConfiguration = builder.onPremiseConfiguration;
        this.type = builder.type;
        this.secretArn = builder.secretArn;
        this.useChangeLog = builder.useChangeLog;
        this.gitHubDocumentCrawlProperties = builder.gitHubDocumentCrawlProperties;
        this.repositoryFilter = builder.repositoryFilter;
        this.inclusionFolderNamePatterns = builder.inclusionFolderNamePatterns;
        this.inclusionFileTypePatterns = builder.inclusionFileTypePatterns;
        this.inclusionFileNamePatterns = builder.inclusionFileNamePatterns;
        this.exclusionFolderNamePatterns = builder.exclusionFolderNamePatterns;
        this.exclusionFileTypePatterns = builder.exclusionFileTypePatterns;
        this.exclusionFileNamePatterns = builder.exclusionFileNamePatterns;
        this.vpcConfiguration = builder.vpcConfiguration;
        this.gitHubRepositoryConfigurationFieldMappings = builder.gitHubRepositoryConfigurationFieldMappings;
        this.gitHubCommitConfigurationFieldMappings = builder.gitHubCommitConfigurationFieldMappings;
        this.gitHubIssueDocumentConfigurationFieldMappings = builder.gitHubIssueDocumentConfigurationFieldMappings;
        this.gitHubIssueCommentConfigurationFieldMappings = builder.gitHubIssueCommentConfigurationFieldMappings;
        this.gitHubIssueAttachmentConfigurationFieldMappings = builder.gitHubIssueAttachmentConfigurationFieldMappings;
        this.gitHubPullRequestCommentConfigurationFieldMappings = builder.gitHubPullRequestCommentConfigurationFieldMappings;
        this.gitHubPullRequestDocumentConfigurationFieldMappings = builder.gitHubPullRequestDocumentConfigurationFieldMappings;
        this.gitHubPullRequestDocumentAttachmentConfigurationFieldMappings = builder.gitHubPullRequestDocumentAttachmentConfigurationFieldMappings;
    }

    /**
     * <p>
     * Configuration information to connect to GitHub Enterprise Cloud (SaaS).
     * </p>
     * 
     * @return Configuration information to connect to GitHub Enterprise Cloud (SaaS).
     */
    public final SaaSConfiguration saaSConfiguration() {
        return saaSConfiguration;
    }

    /**
     * <p>
     * Configuration information to connect to GitHub Enterprise Server (on premises).
     * </p>
     * 
     * @return Configuration information to connect to GitHub Enterprise Server (on premises).
     */
    public final OnPremiseConfiguration onPremiseConfiguration() {
        return onPremiseConfiguration;
    }

    /**
     * <p>
     * The type of GitHub service you want to connect to—GitHub Enterprise Cloud (SaaS) or GitHub Enterprise Server (on
     * premises).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of GitHub service you want to connect to—GitHub Enterprise Cloud (SaaS) or GitHub Enterprise
     *         Server (on premises).
     * @see Type
     */
    public final Type type() {
        return Type.fromValue(type);
    }

    /**
     * <p>
     * The type of GitHub service you want to connect to—GitHub Enterprise Cloud (SaaS) or GitHub Enterprise Server (on
     * premises).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of GitHub service you want to connect to—GitHub Enterprise Cloud (SaaS) or GitHub Enterprise
     *         Server (on premises).
     * @see Type
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the key-value pairs required to connect
     * to your GitHub. The secret must contain a JSON structure with the following keys:
     * </p>
     * <ul>
     * <li>
     * <p>
     * personalToken—The access token created in GitHub. For more information on creating a token in GitHub, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-github.html">Using a GitHub data source</a>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the key-value pairs required to
     *         connect to your GitHub. The secret must contain a JSON structure with the following keys:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         personalToken—The access token created in GitHub. For more information on creating a token in GitHub, see
     *         <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-github.html">Using a GitHub data
     *         source</a>.
     *         </p>
     *         </li>
     */
    public final String secretArn() {
        return secretArn;
    }

    /**
     * <p>
     * <code>TRUE</code> to use the GitHub change log to determine which documents require updating in the index.
     * Depending on the GitHub change log's size, it may take longer for Amazon Kendra to use the change log than to
     * scan all of your documents in GitHub.
     * </p>
     * 
     * @return <code>TRUE</code> to use the GitHub change log to determine which documents require updating in the
     *         index. Depending on the GitHub change log's size, it may take longer for Amazon Kendra to use the change
     *         log than to scan all of your documents in GitHub.
     */
    public final Boolean useChangeLog() {
        return useChangeLog;
    }

    /**
     * <p>
     * Configuration information to include certain types of GitHub content. You can configure to index repository files
     * only, or also include issues and pull requests, comments, and comment attachments.
     * </p>
     * 
     * @return Configuration information to include certain types of GitHub content. You can configure to index
     *         repository files only, or also include issues and pull requests, comments, and comment attachments.
     */
    public final GitHubDocumentCrawlProperties gitHubDocumentCrawlProperties() {
        return gitHubDocumentCrawlProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the RepositoryFilter property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRepositoryFilter() {
        return repositoryFilter != null && !(repositoryFilter instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of names of the specific repositories you want to index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRepositoryFilter} method.
     * </p>
     * 
     * @return A list of names of the specific repositories you want to index.
     */
    public final List<String> repositoryFilter() {
        return repositoryFilter;
    }

    /**
     * For responses, this returns true if the service returned a value for the InclusionFolderNamePatterns property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasInclusionFolderNamePatterns() {
        return inclusionFolderNamePatterns != null && !(inclusionFolderNamePatterns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of regular expression patterns to include certain folder names in your GitHub repository or repositories.
     * Folder names that match the patterns are included in the index. Folder names that don't match the patterns are
     * excluded from the index. If a folder matches both an inclusion and exclusion pattern, the exclusion pattern takes
     * precedence and the folder isn't included in the index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInclusionFolderNamePatterns} method.
     * </p>
     * 
     * @return A list of regular expression patterns to include certain folder names in your GitHub repository or
     *         repositories. Folder names that match the patterns are included in the index. Folder names that don't
     *         match the patterns are excluded from the index. If a folder matches both an inclusion and exclusion
     *         pattern, the exclusion pattern takes precedence and the folder isn't included in the index.
     */
    public final List<String> inclusionFolderNamePatterns() {
        return inclusionFolderNamePatterns;
    }

    /**
     * For responses, this returns true if the service returned a value for the InclusionFileTypePatterns property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasInclusionFileTypePatterns() {
        return inclusionFileTypePatterns != null && !(inclusionFileTypePatterns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of regular expression patterns to include certain file types in your GitHub repository or repositories.
     * File types that match the patterns are included in the index. File types that don't match the patterns are
     * excluded from the index. If a file matches both an inclusion and exclusion pattern, the exclusion pattern takes
     * precedence and the file isn't included in the index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInclusionFileTypePatterns} method.
     * </p>
     * 
     * @return A list of regular expression patterns to include certain file types in your GitHub repository or
     *         repositories. File types that match the patterns are included in the index. File types that don't match
     *         the patterns are excluded from the index. If a file matches both an inclusion and exclusion pattern, the
     *         exclusion pattern takes precedence and the file isn't included in the index.
     */
    public final List<String> inclusionFileTypePatterns() {
        return inclusionFileTypePatterns;
    }

    /**
     * For responses, this returns true if the service returned a value for the InclusionFileNamePatterns property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasInclusionFileNamePatterns() {
        return inclusionFileNamePatterns != null && !(inclusionFileNamePatterns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of regular expression patterns to include certain file names in your GitHub repository or repositories.
     * File names that match the patterns are included in the index. File names that don't match the patterns are
     * excluded from the index. If a file matches both an inclusion and exclusion pattern, the exclusion pattern takes
     * precedence and the file isn't included in the index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInclusionFileNamePatterns} method.
     * </p>
     * 
     * @return A list of regular expression patterns to include certain file names in your GitHub repository or
     *         repositories. File names that match the patterns are included in the index. File names that don't match
     *         the patterns are excluded from the index. If a file matches both an inclusion and exclusion pattern, the
     *         exclusion pattern takes precedence and the file isn't included in the index.
     */
    public final List<String> inclusionFileNamePatterns() {
        return inclusionFileNamePatterns;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExclusionFolderNamePatterns property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasExclusionFolderNamePatterns() {
        return exclusionFolderNamePatterns != null && !(exclusionFolderNamePatterns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of regular expression patterns to exclude certain folder names in your GitHub repository or repositories.
     * Folder names that match the patterns are excluded from the index. Folder names that don't match the patterns are
     * included in the index. If a folder matches both an exclusion and inclusion pattern, the exclusion pattern takes
     * precedence and the folder isn't included in the index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExclusionFolderNamePatterns} method.
     * </p>
     * 
     * @return A list of regular expression patterns to exclude certain folder names in your GitHub repository or
     *         repositories. Folder names that match the patterns are excluded from the index. Folder names that don't
     *         match the patterns are included in the index. If a folder matches both an exclusion and inclusion
     *         pattern, the exclusion pattern takes precedence and the folder isn't included in the index.
     */
    public final List<String> exclusionFolderNamePatterns() {
        return exclusionFolderNamePatterns;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExclusionFileTypePatterns property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasExclusionFileTypePatterns() {
        return exclusionFileTypePatterns != null && !(exclusionFileTypePatterns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of regular expression patterns to exclude certain file types in your GitHub repository or repositories.
     * File types that match the patterns are excluded from the index. File types that don't match the patterns are
     * included in the index. If a file matches both an exclusion and inclusion pattern, the exclusion pattern takes
     * precedence and the file isn't included in the index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExclusionFileTypePatterns} method.
     * </p>
     * 
     * @return A list of regular expression patterns to exclude certain file types in your GitHub repository or
     *         repositories. File types that match the patterns are excluded from the index. File types that don't match
     *         the patterns are included in the index. If a file matches both an exclusion and inclusion pattern, the
     *         exclusion pattern takes precedence and the file isn't included in the index.
     */
    public final List<String> exclusionFileTypePatterns() {
        return exclusionFileTypePatterns;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExclusionFileNamePatterns property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasExclusionFileNamePatterns() {
        return exclusionFileNamePatterns != null && !(exclusionFileNamePatterns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of regular expression patterns to exclude certain file names in your GitHub repository or repositories.
     * File names that match the patterns are excluded from the index. File names that don't match the patterns are
     * included in the index. If a file matches both an exclusion and inclusion pattern, the exclusion pattern takes
     * precedence and the file isn't included in the index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExclusionFileNamePatterns} method.
     * </p>
     * 
     * @return A list of regular expression patterns to exclude certain file names in your GitHub repository or
     *         repositories. File names that match the patterns are excluded from the index. File names that don't match
     *         the patterns are included in the index. If a file matches both an exclusion and inclusion pattern, the
     *         exclusion pattern takes precedence and the file isn't included in the index.
     */
    public final List<String> exclusionFileNamePatterns() {
        return exclusionFileNamePatterns;
    }

    /**
     * <p>
     * Configuration information of an Amazon Virtual Private Cloud to connect to your GitHub. For more information, see
     * <a href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a VPC</a>.
     * </p>
     * 
     * @return Configuration information of an Amazon Virtual Private Cloud to connect to your GitHub. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a VPC</a>.
     */
    public final DataSourceVpcConfiguration vpcConfiguration() {
        return vpcConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the
     * GitHubRepositoryConfigurationFieldMappings property. This DOES NOT check that the value is non-empty (for which,
     * you should check the {@code isEmpty()} method on the property). This is useful because the SDK will never return
     * a null collection or map, but you may need to differentiate between the service returning nothing (or null) and
     * the service returning an empty collection or map. For requests, this returns true if a value for the property was
     * specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasGitHubRepositoryConfigurationFieldMappings() {
        return gitHubRepositoryConfigurationFieldMappings != null
                && !(gitHubRepositoryConfigurationFieldMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DataSourceToIndexFieldMapping</code> objects that map GitHub repository attributes or field names
     * to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map
     * to GitHub fields. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The GitHub
     * data source field names must exist in your GitHub custom metadata.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasGitHubRepositoryConfigurationFieldMappings} method.
     * </p>
     * 
     * @return A list of <code>DataSourceToIndexFieldMapping</code> objects that map GitHub repository attributes or
     *         field names to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code>
     *         API before you map to GitHub fields. For more information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
     *         The GitHub data source field names must exist in your GitHub custom metadata.
     */
    public final List<DataSourceToIndexFieldMapping> gitHubRepositoryConfigurationFieldMappings() {
        return gitHubRepositoryConfigurationFieldMappings;
    }

    /**
     * For responses, this returns true if the service returned a value for the GitHubCommitConfigurationFieldMappings
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasGitHubCommitConfigurationFieldMappings() {
        return gitHubCommitConfigurationFieldMappings != null
                && !(gitHubCommitConfigurationFieldMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub commits
     * to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map
     * to GitHub fields. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The GitHub
     * data source field names must exist in your GitHub custom metadata.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGitHubCommitConfigurationFieldMappings}
     * method.
     * </p>
     * 
     * @return A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub
     *         commits to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API
     *         before you map to GitHub fields. For more information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
     *         The GitHub data source field names must exist in your GitHub custom metadata.
     */
    public final List<DataSourceToIndexFieldMapping> gitHubCommitConfigurationFieldMappings() {
        return gitHubCommitConfigurationFieldMappings;
    }

    /**
     * For responses, this returns true if the service returned a value for the
     * GitHubIssueDocumentConfigurationFieldMappings property. This DOES NOT check that the value is non-empty (for
     * which, you should check the {@code isEmpty()} method on the property). This is useful because the SDK will never
     * return a null collection or map, but you may need to differentiate between the service returning nothing (or
     * null) and the service returning an empty collection or map. For requests, this returns true if a value for the
     * property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasGitHubIssueDocumentConfigurationFieldMappings() {
        return gitHubIssueDocumentConfigurationFieldMappings != null
                && !(gitHubIssueDocumentConfigurationFieldMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub issues
     * to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map
     * to GitHub fields. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The GitHub
     * data source field names must exist in your GitHub custom metadata.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasGitHubIssueDocumentConfigurationFieldMappings} method.
     * </p>
     * 
     * @return A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub
     *         issues to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API
     *         before you map to GitHub fields. For more information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
     *         The GitHub data source field names must exist in your GitHub custom metadata.
     */
    public final List<DataSourceToIndexFieldMapping> gitHubIssueDocumentConfigurationFieldMappings() {
        return gitHubIssueDocumentConfigurationFieldMappings;
    }

    /**
     * For responses, this returns true if the service returned a value for the
     * GitHubIssueCommentConfigurationFieldMappings property. This DOES NOT check that the value is non-empty (for
     * which, you should check the {@code isEmpty()} method on the property). This is useful because the SDK will never
     * return a null collection or map, but you may need to differentiate between the service returning nothing (or
     * null) and the service returning an empty collection or map. For requests, this returns true if a value for the
     * property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasGitHubIssueCommentConfigurationFieldMappings() {
        return gitHubIssueCommentConfigurationFieldMappings != null
                && !(gitHubIssueCommentConfigurationFieldMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub issue
     * comments to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before
     * you map to GitHub fields. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The GitHub
     * data source field names must exist in your GitHub custom metadata.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasGitHubIssueCommentConfigurationFieldMappings} method.
     * </p>
     * 
     * @return A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub
     *         issue comments to Amazon Kendra index field names. To create custom fields, use the
     *         <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
     *         The GitHub data source field names must exist in your GitHub custom metadata.
     */
    public final List<DataSourceToIndexFieldMapping> gitHubIssueCommentConfigurationFieldMappings() {
        return gitHubIssueCommentConfigurationFieldMappings;
    }

    /**
     * For responses, this returns true if the service returned a value for the
     * GitHubIssueAttachmentConfigurationFieldMappings property. This DOES NOT check that the value is non-empty (for
     * which, you should check the {@code isEmpty()} method on the property). This is useful because the SDK will never
     * return a null collection or map, but you may need to differentiate between the service returning nothing (or
     * null) and the service returning an empty collection or map. For requests, this returns true if a value for the
     * property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasGitHubIssueAttachmentConfigurationFieldMappings() {
        return gitHubIssueAttachmentConfigurationFieldMappings != null
                && !(gitHubIssueAttachmentConfigurationFieldMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub issue
     * attachments to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API
     * before you map to GitHub fields. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The GitHub
     * data source field names must exist in your GitHub custom metadata.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasGitHubIssueAttachmentConfigurationFieldMappings} method.
     * </p>
     * 
     * @return A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub
     *         issue attachments to Amazon Kendra index field names. To create custom fields, use the
     *         <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
     *         The GitHub data source field names must exist in your GitHub custom metadata.
     */
    public final List<DataSourceToIndexFieldMapping> gitHubIssueAttachmentConfigurationFieldMappings() {
        return gitHubIssueAttachmentConfigurationFieldMappings;
    }

    /**
     * For responses, this returns true if the service returned a value for the
     * GitHubPullRequestCommentConfigurationFieldMappings property. This DOES NOT check that the value is non-empty (for
     * which, you should check the {@code isEmpty()} method on the property). This is useful because the SDK will never
     * return a null collection or map, but you may need to differentiate between the service returning nothing (or
     * null) and the service returning an empty collection or map. For requests, this returns true if a value for the
     * property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasGitHubPullRequestCommentConfigurationFieldMappings() {
        return gitHubPullRequestCommentConfigurationFieldMappings != null
                && !(gitHubPullRequestCommentConfigurationFieldMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub pull
     * request comments to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code>
     * API before you map to GitHub fields. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The GitHub
     * data source field names must exist in your GitHub custom metadata.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasGitHubPullRequestCommentConfigurationFieldMappings} method.
     * </p>
     * 
     * @return A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub
     *         pull request comments to Amazon Kendra index field names. To create custom fields, use the
     *         <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
     *         The GitHub data source field names must exist in your GitHub custom metadata.
     */
    public final List<DataSourceToIndexFieldMapping> gitHubPullRequestCommentConfigurationFieldMappings() {
        return gitHubPullRequestCommentConfigurationFieldMappings;
    }

    /**
     * For responses, this returns true if the service returned a value for the
     * GitHubPullRequestDocumentConfigurationFieldMappings property. This DOES NOT check that the value is non-empty
     * (for which, you should check the {@code isEmpty()} method on the property). This is useful because the SDK will
     * never return a null collection or map, but you may need to differentiate between the service returning nothing
     * (or null) and the service returning an empty collection or map. For requests, this returns true if a value for
     * the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasGitHubPullRequestDocumentConfigurationFieldMappings() {
        return gitHubPullRequestDocumentConfigurationFieldMappings != null
                && !(gitHubPullRequestDocumentConfigurationFieldMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub pull
     * requests to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before
     * you map to GitHub fields. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The GitHub
     * data source field names must exist in your GitHub custom metadata.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasGitHubPullRequestDocumentConfigurationFieldMappings} method.
     * </p>
     * 
     * @return A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub
     *         pull requests to Amazon Kendra index field names. To create custom fields, use the
     *         <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
     *         The GitHub data source field names must exist in your GitHub custom metadata.
     */
    public final List<DataSourceToIndexFieldMapping> gitHubPullRequestDocumentConfigurationFieldMappings() {
        return gitHubPullRequestDocumentConfigurationFieldMappings;
    }

    /**
     * For responses, this returns true if the service returned a value for the
     * GitHubPullRequestDocumentAttachmentConfigurationFieldMappings property. This DOES NOT check that the value is
     * non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful because the
     * SDK will never return a null collection or map, but you may need to differentiate between the service returning
     * nothing (or null) and the service returning an empty collection or map. For requests, this returns true if a
     * value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasGitHubPullRequestDocumentAttachmentConfigurationFieldMappings() {
        return gitHubPullRequestDocumentAttachmentConfigurationFieldMappings != null
                && !(gitHubPullRequestDocumentAttachmentConfigurationFieldMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub pull
     * request attachments to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code>
     * API before you map to GitHub fields. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The GitHub
     * data source field names must exist in your GitHub custom metadata.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasGitHubPullRequestDocumentAttachmentConfigurationFieldMappings} method.
     * </p>
     * 
     * @return A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub
     *         pull request attachments to Amazon Kendra index field names. To create custom fields, use the
     *         <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
     *         The GitHub data source field names must exist in your GitHub custom metadata.
     */
    public final List<DataSourceToIndexFieldMapping> gitHubPullRequestDocumentAttachmentConfigurationFieldMappings() {
        return gitHubPullRequestDocumentAttachmentConfigurationFieldMappings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(saaSConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(onPremiseConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(useChangeLog());
        hashCode = 31 * hashCode + Objects.hashCode(gitHubDocumentCrawlProperties());
        hashCode = 31 * hashCode + Objects.hashCode(hasRepositoryFilter() ? repositoryFilter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInclusionFolderNamePatterns() ? inclusionFolderNamePatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInclusionFileTypePatterns() ? inclusionFileTypePatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInclusionFileNamePatterns() ? inclusionFileNamePatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExclusionFolderNamePatterns() ? exclusionFolderNamePatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExclusionFileTypePatterns() ? exclusionFileTypePatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExclusionFileNamePatterns() ? exclusionFileNamePatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfiguration());
        hashCode = 31
                * hashCode
                + Objects.hashCode(hasGitHubRepositoryConfigurationFieldMappings() ? gitHubRepositoryConfigurationFieldMappings()
                        : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasGitHubCommitConfigurationFieldMappings() ? gitHubCommitConfigurationFieldMappings() : null);
        hashCode = 31
                * hashCode
                + Objects
                        .hashCode(hasGitHubIssueDocumentConfigurationFieldMappings() ? gitHubIssueDocumentConfigurationFieldMappings()
                                : null);
        hashCode = 31
                * hashCode
                + Objects
                        .hashCode(hasGitHubIssueCommentConfigurationFieldMappings() ? gitHubIssueCommentConfigurationFieldMappings()
                                : null);
        hashCode = 31
                * hashCode
                + Objects
                        .hashCode(hasGitHubIssueAttachmentConfigurationFieldMappings() ? gitHubIssueAttachmentConfigurationFieldMappings()
                                : null);
        hashCode = 31
                * hashCode
                + Objects
                        .hashCode(hasGitHubPullRequestCommentConfigurationFieldMappings() ? gitHubPullRequestCommentConfigurationFieldMappings()
                                : null);
        hashCode = 31
                * hashCode
                + Objects
                        .hashCode(hasGitHubPullRequestDocumentConfigurationFieldMappings() ? gitHubPullRequestDocumentConfigurationFieldMappings()
                                : null);
        hashCode = 31
                * hashCode
                + Objects
                        .hashCode(hasGitHubPullRequestDocumentAttachmentConfigurationFieldMappings() ? gitHubPullRequestDocumentAttachmentConfigurationFieldMappings()
                                : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GitHubConfiguration)) {
            return false;
        }
        GitHubConfiguration other = (GitHubConfiguration) obj;
        return Objects.equals(saaSConfiguration(), other.saaSConfiguration())
                && Objects.equals(onPremiseConfiguration(), other.onPremiseConfiguration())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(secretArn(), other.secretArn())
                && Objects.equals(useChangeLog(), other.useChangeLog())
                && Objects.equals(gitHubDocumentCrawlProperties(), other.gitHubDocumentCrawlProperties())
                && hasRepositoryFilter() == other.hasRepositoryFilter()
                && Objects.equals(repositoryFilter(), other.repositoryFilter())
                && hasInclusionFolderNamePatterns() == other.hasInclusionFolderNamePatterns()
                && Objects.equals(inclusionFolderNamePatterns(), other.inclusionFolderNamePatterns())
                && hasInclusionFileTypePatterns() == other.hasInclusionFileTypePatterns()
                && Objects.equals(inclusionFileTypePatterns(), other.inclusionFileTypePatterns())
                && hasInclusionFileNamePatterns() == other.hasInclusionFileNamePatterns()
                && Objects.equals(inclusionFileNamePatterns(), other.inclusionFileNamePatterns())
                && hasExclusionFolderNamePatterns() == other.hasExclusionFolderNamePatterns()
                && Objects.equals(exclusionFolderNamePatterns(), other.exclusionFolderNamePatterns())
                && hasExclusionFileTypePatterns() == other.hasExclusionFileTypePatterns()
                && Objects.equals(exclusionFileTypePatterns(), other.exclusionFileTypePatterns())
                && hasExclusionFileNamePatterns() == other.hasExclusionFileNamePatterns()
                && Objects.equals(exclusionFileNamePatterns(), other.exclusionFileNamePatterns())
                && Objects.equals(vpcConfiguration(), other.vpcConfiguration())
                && hasGitHubRepositoryConfigurationFieldMappings() == other.hasGitHubRepositoryConfigurationFieldMappings()
                && Objects.equals(gitHubRepositoryConfigurationFieldMappings(),
                        other.gitHubRepositoryConfigurationFieldMappings())
                && hasGitHubCommitConfigurationFieldMappings() == other.hasGitHubCommitConfigurationFieldMappings()
                && Objects.equals(gitHubCommitConfigurationFieldMappings(), other.gitHubCommitConfigurationFieldMappings())
                && hasGitHubIssueDocumentConfigurationFieldMappings() == other.hasGitHubIssueDocumentConfigurationFieldMappings()
                && Objects.equals(gitHubIssueDocumentConfigurationFieldMappings(),
                        other.gitHubIssueDocumentConfigurationFieldMappings())
                && hasGitHubIssueCommentConfigurationFieldMappings() == other.hasGitHubIssueCommentConfigurationFieldMappings()
                && Objects.equals(gitHubIssueCommentConfigurationFieldMappings(),
                        other.gitHubIssueCommentConfigurationFieldMappings())
                && hasGitHubIssueAttachmentConfigurationFieldMappings() == other
                        .hasGitHubIssueAttachmentConfigurationFieldMappings()
                && Objects.equals(gitHubIssueAttachmentConfigurationFieldMappings(),
                        other.gitHubIssueAttachmentConfigurationFieldMappings())
                && hasGitHubPullRequestCommentConfigurationFieldMappings() == other
                        .hasGitHubPullRequestCommentConfigurationFieldMappings()
                && Objects.equals(gitHubPullRequestCommentConfigurationFieldMappings(),
                        other.gitHubPullRequestCommentConfigurationFieldMappings())
                && hasGitHubPullRequestDocumentConfigurationFieldMappings() == other
                        .hasGitHubPullRequestDocumentConfigurationFieldMappings()
                && Objects.equals(gitHubPullRequestDocumentConfigurationFieldMappings(),
                        other.gitHubPullRequestDocumentConfigurationFieldMappings())
                && hasGitHubPullRequestDocumentAttachmentConfigurationFieldMappings() == other
                        .hasGitHubPullRequestDocumentAttachmentConfigurationFieldMappings()
                && Objects.equals(gitHubPullRequestDocumentAttachmentConfigurationFieldMappings(),
                        other.gitHubPullRequestDocumentAttachmentConfigurationFieldMappings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("GitHubConfiguration")
                .add("SaaSConfiguration", saaSConfiguration())
                .add("OnPremiseConfiguration", onPremiseConfiguration())
                .add("Type", typeAsString())
                .add("SecretArn", secretArn())
                .add("UseChangeLog", useChangeLog())
                .add("GitHubDocumentCrawlProperties", gitHubDocumentCrawlProperties())
                .add("RepositoryFilter", hasRepositoryFilter() ? repositoryFilter() : null)
                .add("InclusionFolderNamePatterns", hasInclusionFolderNamePatterns() ? inclusionFolderNamePatterns() : null)
                .add("InclusionFileTypePatterns", hasInclusionFileTypePatterns() ? inclusionFileTypePatterns() : null)
                .add("InclusionFileNamePatterns", hasInclusionFileNamePatterns() ? inclusionFileNamePatterns() : null)
                .add("ExclusionFolderNamePatterns", hasExclusionFolderNamePatterns() ? exclusionFolderNamePatterns() : null)
                .add("ExclusionFileTypePatterns", hasExclusionFileTypePatterns() ? exclusionFileTypePatterns() : null)
                .add("ExclusionFileNamePatterns", hasExclusionFileNamePatterns() ? exclusionFileNamePatterns() : null)
                .add("VpcConfiguration", vpcConfiguration())
                .add("GitHubRepositoryConfigurationFieldMappings",
                        hasGitHubRepositoryConfigurationFieldMappings() ? gitHubRepositoryConfigurationFieldMappings() : null)
                .add("GitHubCommitConfigurationFieldMappings",
                        hasGitHubCommitConfigurationFieldMappings() ? gitHubCommitConfigurationFieldMappings() : null)
                .add("GitHubIssueDocumentConfigurationFieldMappings",
                        hasGitHubIssueDocumentConfigurationFieldMappings() ? gitHubIssueDocumentConfigurationFieldMappings()
                                : null)
                .add("GitHubIssueCommentConfigurationFieldMappings",
                        hasGitHubIssueCommentConfigurationFieldMappings() ? gitHubIssueCommentConfigurationFieldMappings() : null)
                .add("GitHubIssueAttachmentConfigurationFieldMappings",
                        hasGitHubIssueAttachmentConfigurationFieldMappings() ? gitHubIssueAttachmentConfigurationFieldMappings()
                                : null)
                .add("GitHubPullRequestCommentConfigurationFieldMappings",
                        hasGitHubPullRequestCommentConfigurationFieldMappings() ? gitHubPullRequestCommentConfigurationFieldMappings()
                                : null)
                .add("GitHubPullRequestDocumentConfigurationFieldMappings",
                        hasGitHubPullRequestDocumentConfigurationFieldMappings() ? gitHubPullRequestDocumentConfigurationFieldMappings()
                                : null)
                .add("GitHubPullRequestDocumentAttachmentConfigurationFieldMappings",
                        hasGitHubPullRequestDocumentAttachmentConfigurationFieldMappings() ? gitHubPullRequestDocumentAttachmentConfigurationFieldMappings()
                                : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SaaSConfiguration":
            return Optional.ofNullable(clazz.cast(saaSConfiguration()));
        case "OnPremiseConfiguration":
            return Optional.ofNullable(clazz.cast(onPremiseConfiguration()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "UseChangeLog":
            return Optional.ofNullable(clazz.cast(useChangeLog()));
        case "GitHubDocumentCrawlProperties":
            return Optional.ofNullable(clazz.cast(gitHubDocumentCrawlProperties()));
        case "RepositoryFilter":
            return Optional.ofNullable(clazz.cast(repositoryFilter()));
        case "InclusionFolderNamePatterns":
            return Optional.ofNullable(clazz.cast(inclusionFolderNamePatterns()));
        case "InclusionFileTypePatterns":
            return Optional.ofNullable(clazz.cast(inclusionFileTypePatterns()));
        case "InclusionFileNamePatterns":
            return Optional.ofNullable(clazz.cast(inclusionFileNamePatterns()));
        case "ExclusionFolderNamePatterns":
            return Optional.ofNullable(clazz.cast(exclusionFolderNamePatterns()));
        case "ExclusionFileTypePatterns":
            return Optional.ofNullable(clazz.cast(exclusionFileTypePatterns()));
        case "ExclusionFileNamePatterns":
            return Optional.ofNullable(clazz.cast(exclusionFileNamePatterns()));
        case "VpcConfiguration":
            return Optional.ofNullable(clazz.cast(vpcConfiguration()));
        case "GitHubRepositoryConfigurationFieldMappings":
            return Optional.ofNullable(clazz.cast(gitHubRepositoryConfigurationFieldMappings()));
        case "GitHubCommitConfigurationFieldMappings":
            return Optional.ofNullable(clazz.cast(gitHubCommitConfigurationFieldMappings()));
        case "GitHubIssueDocumentConfigurationFieldMappings":
            return Optional.ofNullable(clazz.cast(gitHubIssueDocumentConfigurationFieldMappings()));
        case "GitHubIssueCommentConfigurationFieldMappings":
            return Optional.ofNullable(clazz.cast(gitHubIssueCommentConfigurationFieldMappings()));
        case "GitHubIssueAttachmentConfigurationFieldMappings":
            return Optional.ofNullable(clazz.cast(gitHubIssueAttachmentConfigurationFieldMappings()));
        case "GitHubPullRequestCommentConfigurationFieldMappings":
            return Optional.ofNullable(clazz.cast(gitHubPullRequestCommentConfigurationFieldMappings()));
        case "GitHubPullRequestDocumentConfigurationFieldMappings":
            return Optional.ofNullable(clazz.cast(gitHubPullRequestDocumentConfigurationFieldMappings()));
        case "GitHubPullRequestDocumentAttachmentConfigurationFieldMappings":
            return Optional.ofNullable(clazz.cast(gitHubPullRequestDocumentAttachmentConfigurationFieldMappings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GitHubConfiguration, T> g) {
        return obj -> g.apply((GitHubConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GitHubConfiguration> {
        /**
         * <p>
         * Configuration information to connect to GitHub Enterprise Cloud (SaaS).
         * </p>
         * 
         * @param saaSConfiguration
         *        Configuration information to connect to GitHub Enterprise Cloud (SaaS).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder saaSConfiguration(SaaSConfiguration saaSConfiguration);

        /**
         * <p>
         * Configuration information to connect to GitHub Enterprise Cloud (SaaS).
         * </p>
         * This is a convenience method that creates an instance of the {@link SaaSConfiguration.Builder} avoiding the
         * need to create one manually via {@link SaaSConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SaaSConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #saaSConfiguration(SaaSConfiguration)}.
         * 
         * @param saaSConfiguration
         *        a consumer that will call methods on {@link SaaSConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #saaSConfiguration(SaaSConfiguration)
         */
        default Builder saaSConfiguration(Consumer<SaaSConfiguration.Builder> saaSConfiguration) {
            return saaSConfiguration(SaaSConfiguration.builder().applyMutation(saaSConfiguration).build());
        }

        /**
         * <p>
         * Configuration information to connect to GitHub Enterprise Server (on premises).
         * </p>
         * 
         * @param onPremiseConfiguration
         *        Configuration information to connect to GitHub Enterprise Server (on premises).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onPremiseConfiguration(OnPremiseConfiguration onPremiseConfiguration);

        /**
         * <p>
         * Configuration information to connect to GitHub Enterprise Server (on premises).
         * </p>
         * This is a convenience method that creates an instance of the {@link OnPremiseConfiguration.Builder} avoiding
         * the need to create one manually via {@link OnPremiseConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OnPremiseConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #onPremiseConfiguration(OnPremiseConfiguration)}.
         * 
         * @param onPremiseConfiguration
         *        a consumer that will call methods on {@link OnPremiseConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onPremiseConfiguration(OnPremiseConfiguration)
         */
        default Builder onPremiseConfiguration(Consumer<OnPremiseConfiguration.Builder> onPremiseConfiguration) {
            return onPremiseConfiguration(OnPremiseConfiguration.builder().applyMutation(onPremiseConfiguration).build());
        }

        /**
         * <p>
         * The type of GitHub service you want to connect to—GitHub Enterprise Cloud (SaaS) or GitHub Enterprise Server
         * (on premises).
         * </p>
         * 
         * @param type
         *        The type of GitHub service you want to connect to—GitHub Enterprise Cloud (SaaS) or GitHub Enterprise
         *        Server (on premises).
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(String type);

        /**
         * <p>
         * The type of GitHub service you want to connect to—GitHub Enterprise Cloud (SaaS) or GitHub Enterprise Server
         * (on premises).
         * </p>
         * 
         * @param type
         *        The type of GitHub service you want to connect to—GitHub Enterprise Cloud (SaaS) or GitHub Enterprise
         *        Server (on premises).
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(Type type);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the key-value pairs required to
         * connect to your GitHub. The secret must contain a JSON structure with the following keys:
         * </p>
         * <ul>
         * <li>
         * <p>
         * personalToken—The access token created in GitHub. For more information on creating a token in GitHub, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-github.html">Using a GitHub data source</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param secretArn
         *        The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the key-value pairs required
         *        to connect to your GitHub. The secret must contain a JSON structure with the following keys:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        personalToken—The access token created in GitHub. For more information on creating a token in GitHub,
         *        see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-github.html">Using a GitHub data
         *        source</a>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);

        /**
         * <p>
         * <code>TRUE</code> to use the GitHub change log to determine which documents require updating in the index.
         * Depending on the GitHub change log's size, it may take longer for Amazon Kendra to use the change log than to
         * scan all of your documents in GitHub.
         * </p>
         * 
         * @param useChangeLog
         *        <code>TRUE</code> to use the GitHub change log to determine which documents require updating in the
         *        index. Depending on the GitHub change log's size, it may take longer for Amazon Kendra to use the
         *        change log than to scan all of your documents in GitHub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useChangeLog(Boolean useChangeLog);

        /**
         * <p>
         * Configuration information to include certain types of GitHub content. You can configure to index repository
         * files only, or also include issues and pull requests, comments, and comment attachments.
         * </p>
         * 
         * @param gitHubDocumentCrawlProperties
         *        Configuration information to include certain types of GitHub content. You can configure to index
         *        repository files only, or also include issues and pull requests, comments, and comment attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gitHubDocumentCrawlProperties(GitHubDocumentCrawlProperties gitHubDocumentCrawlProperties);

        /**
         * <p>
         * Configuration information to include certain types of GitHub content. You can configure to index repository
         * files only, or also include issues and pull requests, comments, and comment attachments.
         * </p>
         * This is a convenience method that creates an instance of the {@link GitHubDocumentCrawlProperties.Builder}
         * avoiding the need to create one manually via {@link GitHubDocumentCrawlProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GitHubDocumentCrawlProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #gitHubDocumentCrawlProperties(GitHubDocumentCrawlProperties)}.
         * 
         * @param gitHubDocumentCrawlProperties
         *        a consumer that will call methods on {@link GitHubDocumentCrawlProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gitHubDocumentCrawlProperties(GitHubDocumentCrawlProperties)
         */
        default Builder gitHubDocumentCrawlProperties(
                Consumer<GitHubDocumentCrawlProperties.Builder> gitHubDocumentCrawlProperties) {
            return gitHubDocumentCrawlProperties(GitHubDocumentCrawlProperties.builder()
                    .applyMutation(gitHubDocumentCrawlProperties).build());
        }

        /**
         * <p>
         * A list of names of the specific repositories you want to index.
         * </p>
         * 
         * @param repositoryFilter
         *        A list of names of the specific repositories you want to index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryFilter(Collection<String> repositoryFilter);

        /**
         * <p>
         * A list of names of the specific repositories you want to index.
         * </p>
         * 
         * @param repositoryFilter
         *        A list of names of the specific repositories you want to index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryFilter(String... repositoryFilter);

        /**
         * <p>
         * A list of regular expression patterns to include certain folder names in your GitHub repository or
         * repositories. Folder names that match the patterns are included in the index. Folder names that don't match
         * the patterns are excluded from the index. If a folder matches both an inclusion and exclusion pattern, the
         * exclusion pattern takes precedence and the folder isn't included in the index.
         * </p>
         * 
         * @param inclusionFolderNamePatterns
         *        A list of regular expression patterns to include certain folder names in your GitHub repository or
         *        repositories. Folder names that match the patterns are included in the index. Folder names that don't
         *        match the patterns are excluded from the index. If a folder matches both an inclusion and exclusion
         *        pattern, the exclusion pattern takes precedence and the folder isn't included in the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusionFolderNamePatterns(Collection<String> inclusionFolderNamePatterns);

        /**
         * <p>
         * A list of regular expression patterns to include certain folder names in your GitHub repository or
         * repositories. Folder names that match the patterns are included in the index. Folder names that don't match
         * the patterns are excluded from the index. If a folder matches both an inclusion and exclusion pattern, the
         * exclusion pattern takes precedence and the folder isn't included in the index.
         * </p>
         * 
         * @param inclusionFolderNamePatterns
         *        A list of regular expression patterns to include certain folder names in your GitHub repository or
         *        repositories. Folder names that match the patterns are included in the index. Folder names that don't
         *        match the patterns are excluded from the index. If a folder matches both an inclusion and exclusion
         *        pattern, the exclusion pattern takes precedence and the folder isn't included in the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusionFolderNamePatterns(String... inclusionFolderNamePatterns);

        /**
         * <p>
         * A list of regular expression patterns to include certain file types in your GitHub repository or
         * repositories. File types that match the patterns are included in the index. File types that don't match the
         * patterns are excluded from the index. If a file matches both an inclusion and exclusion pattern, the
         * exclusion pattern takes precedence and the file isn't included in the index.
         * </p>
         * 
         * @param inclusionFileTypePatterns
         *        A list of regular expression patterns to include certain file types in your GitHub repository or
         *        repositories. File types that match the patterns are included in the index. File types that don't
         *        match the patterns are excluded from the index. If a file matches both an inclusion and exclusion
         *        pattern, the exclusion pattern takes precedence and the file isn't included in the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusionFileTypePatterns(Collection<String> inclusionFileTypePatterns);

        /**
         * <p>
         * A list of regular expression patterns to include certain file types in your GitHub repository or
         * repositories. File types that match the patterns are included in the index. File types that don't match the
         * patterns are excluded from the index. If a file matches both an inclusion and exclusion pattern, the
         * exclusion pattern takes precedence and the file isn't included in the index.
         * </p>
         * 
         * @param inclusionFileTypePatterns
         *        A list of regular expression patterns to include certain file types in your GitHub repository or
         *        repositories. File types that match the patterns are included in the index. File types that don't
         *        match the patterns are excluded from the index. If a file matches both an inclusion and exclusion
         *        pattern, the exclusion pattern takes precedence and the file isn't included in the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusionFileTypePatterns(String... inclusionFileTypePatterns);

        /**
         * <p>
         * A list of regular expression patterns to include certain file names in your GitHub repository or
         * repositories. File names that match the patterns are included in the index. File names that don't match the
         * patterns are excluded from the index. If a file matches both an inclusion and exclusion pattern, the
         * exclusion pattern takes precedence and the file isn't included in the index.
         * </p>
         * 
         * @param inclusionFileNamePatterns
         *        A list of regular expression patterns to include certain file names in your GitHub repository or
         *        repositories. File names that match the patterns are included in the index. File names that don't
         *        match the patterns are excluded from the index. If a file matches both an inclusion and exclusion
         *        pattern, the exclusion pattern takes precedence and the file isn't included in the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusionFileNamePatterns(Collection<String> inclusionFileNamePatterns);

        /**
         * <p>
         * A list of regular expression patterns to include certain file names in your GitHub repository or
         * repositories. File names that match the patterns are included in the index. File names that don't match the
         * patterns are excluded from the index. If a file matches both an inclusion and exclusion pattern, the
         * exclusion pattern takes precedence and the file isn't included in the index.
         * </p>
         * 
         * @param inclusionFileNamePatterns
         *        A list of regular expression patterns to include certain file names in your GitHub repository or
         *        repositories. File names that match the patterns are included in the index. File names that don't
         *        match the patterns are excluded from the index. If a file matches both an inclusion and exclusion
         *        pattern, the exclusion pattern takes precedence and the file isn't included in the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusionFileNamePatterns(String... inclusionFileNamePatterns);

        /**
         * <p>
         * A list of regular expression patterns to exclude certain folder names in your GitHub repository or
         * repositories. Folder names that match the patterns are excluded from the index. Folder names that don't match
         * the patterns are included in the index. If a folder matches both an exclusion and inclusion pattern, the
         * exclusion pattern takes precedence and the folder isn't included in the index.
         * </p>
         * 
         * @param exclusionFolderNamePatterns
         *        A list of regular expression patterns to exclude certain folder names in your GitHub repository or
         *        repositories. Folder names that match the patterns are excluded from the index. Folder names that
         *        don't match the patterns are included in the index. If a folder matches both an exclusion and
         *        inclusion pattern, the exclusion pattern takes precedence and the folder isn't included in the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusionFolderNamePatterns(Collection<String> exclusionFolderNamePatterns);

        /**
         * <p>
         * A list of regular expression patterns to exclude certain folder names in your GitHub repository or
         * repositories. Folder names that match the patterns are excluded from the index. Folder names that don't match
         * the patterns are included in the index. If a folder matches both an exclusion and inclusion pattern, the
         * exclusion pattern takes precedence and the folder isn't included in the index.
         * </p>
         * 
         * @param exclusionFolderNamePatterns
         *        A list of regular expression patterns to exclude certain folder names in your GitHub repository or
         *        repositories. Folder names that match the patterns are excluded from the index. Folder names that
         *        don't match the patterns are included in the index. If a folder matches both an exclusion and
         *        inclusion pattern, the exclusion pattern takes precedence and the folder isn't included in the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusionFolderNamePatterns(String... exclusionFolderNamePatterns);

        /**
         * <p>
         * A list of regular expression patterns to exclude certain file types in your GitHub repository or
         * repositories. File types that match the patterns are excluded from the index. File types that don't match the
         * patterns are included in the index. If a file matches both an exclusion and inclusion pattern, the exclusion
         * pattern takes precedence and the file isn't included in the index.
         * </p>
         * 
         * @param exclusionFileTypePatterns
         *        A list of regular expression patterns to exclude certain file types in your GitHub repository or
         *        repositories. File types that match the patterns are excluded from the index. File types that don't
         *        match the patterns are included in the index. If a file matches both an exclusion and inclusion
         *        pattern, the exclusion pattern takes precedence and the file isn't included in the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusionFileTypePatterns(Collection<String> exclusionFileTypePatterns);

        /**
         * <p>
         * A list of regular expression patterns to exclude certain file types in your GitHub repository or
         * repositories. File types that match the patterns are excluded from the index. File types that don't match the
         * patterns are included in the index. If a file matches both an exclusion and inclusion pattern, the exclusion
         * pattern takes precedence and the file isn't included in the index.
         * </p>
         * 
         * @param exclusionFileTypePatterns
         *        A list of regular expression patterns to exclude certain file types in your GitHub repository or
         *        repositories. File types that match the patterns are excluded from the index. File types that don't
         *        match the patterns are included in the index. If a file matches both an exclusion and inclusion
         *        pattern, the exclusion pattern takes precedence and the file isn't included in the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusionFileTypePatterns(String... exclusionFileTypePatterns);

        /**
         * <p>
         * A list of regular expression patterns to exclude certain file names in your GitHub repository or
         * repositories. File names that match the patterns are excluded from the index. File names that don't match the
         * patterns are included in the index. If a file matches both an exclusion and inclusion pattern, the exclusion
         * pattern takes precedence and the file isn't included in the index.
         * </p>
         * 
         * @param exclusionFileNamePatterns
         *        A list of regular expression patterns to exclude certain file names in your GitHub repository or
         *        repositories. File names that match the patterns are excluded from the index. File names that don't
         *        match the patterns are included in the index. If a file matches both an exclusion and inclusion
         *        pattern, the exclusion pattern takes precedence and the file isn't included in the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusionFileNamePatterns(Collection<String> exclusionFileNamePatterns);

        /**
         * <p>
         * A list of regular expression patterns to exclude certain file names in your GitHub repository or
         * repositories. File names that match the patterns are excluded from the index. File names that don't match the
         * patterns are included in the index. If a file matches both an exclusion and inclusion pattern, the exclusion
         * pattern takes precedence and the file isn't included in the index.
         * </p>
         * 
         * @param exclusionFileNamePatterns
         *        A list of regular expression patterns to exclude certain file names in your GitHub repository or
         *        repositories. File names that match the patterns are excluded from the index. File names that don't
         *        match the patterns are included in the index. If a file matches both an exclusion and inclusion
         *        pattern, the exclusion pattern takes precedence and the file isn't included in the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusionFileNamePatterns(String... exclusionFileNamePatterns);

        /**
         * <p>
         * Configuration information of an Amazon Virtual Private Cloud to connect to your GitHub. For more information,
         * see <a href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a VPC</a>.
         * </p>
         * 
         * @param vpcConfiguration
         *        Configuration information of an Amazon Virtual Private Cloud to connect to your GitHub. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a VPC</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfiguration(DataSourceVpcConfiguration vpcConfiguration);

        /**
         * <p>
         * Configuration information of an Amazon Virtual Private Cloud to connect to your GitHub. For more information,
         * see <a href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a VPC</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourceVpcConfiguration.Builder}
         * avoiding the need to create one manually via {@link DataSourceVpcConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSourceVpcConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #vpcConfiguration(DataSourceVpcConfiguration)}.
         * 
         * @param vpcConfiguration
         *        a consumer that will call methods on {@link DataSourceVpcConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfiguration(DataSourceVpcConfiguration)
         */
        default Builder vpcConfiguration(Consumer<DataSourceVpcConfiguration.Builder> vpcConfiguration) {
            return vpcConfiguration(DataSourceVpcConfiguration.builder().applyMutation(vpcConfiguration).build());
        }

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map GitHub repository attributes or field
         * names to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API
         * before you map to GitHub fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * GitHub data source field names must exist in your GitHub custom metadata.
         * </p>
         * 
         * @param gitHubRepositoryConfigurationFieldMappings
         *        A list of <code>DataSourceToIndexFieldMapping</code> objects that map GitHub repository attributes or
         *        field names to Amazon Kendra index field names. To create custom fields, use the
         *        <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
         *        The GitHub data source field names must exist in your GitHub custom metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gitHubRepositoryConfigurationFieldMappings(
                Collection<DataSourceToIndexFieldMapping> gitHubRepositoryConfigurationFieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map GitHub repository attributes or field
         * names to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API
         * before you map to GitHub fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * GitHub data source field names must exist in your GitHub custom metadata.
         * </p>
         * 
         * @param gitHubRepositoryConfigurationFieldMappings
         *        A list of <code>DataSourceToIndexFieldMapping</code> objects that map GitHub repository attributes or
         *        field names to Amazon Kendra index field names. To create custom fields, use the
         *        <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
         *        The GitHub data source field names must exist in your GitHub custom metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gitHubRepositoryConfigurationFieldMappings(
                DataSourceToIndexFieldMapping... gitHubRepositoryConfigurationFieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map GitHub repository attributes or field
         * names to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API
         * before you map to GitHub fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * GitHub data source field names must exist in your GitHub custom metadata.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #gitHubRepositoryConfigurationFieldMappings(List<DataSourceToIndexFieldMapping>)}.
         * 
         * @param gitHubRepositoryConfigurationFieldMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gitHubRepositoryConfigurationFieldMappings(java.util.Collection<DataSourceToIndexFieldMapping>)
         */
        Builder gitHubRepositoryConfigurationFieldMappings(
                Consumer<DataSourceToIndexFieldMapping.Builder>... gitHubRepositoryConfigurationFieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub
         * commits to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API
         * before you map to GitHub fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * GitHub data source field names must exist in your GitHub custom metadata.
         * </p>
         * 
         * @param gitHubCommitConfigurationFieldMappings
         *        A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of
         *        GitHub commits to Amazon Kendra index field names. To create custom fields, use the
         *        <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
         *        The GitHub data source field names must exist in your GitHub custom metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gitHubCommitConfigurationFieldMappings(
                Collection<DataSourceToIndexFieldMapping> gitHubCommitConfigurationFieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub
         * commits to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API
         * before you map to GitHub fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * GitHub data source field names must exist in your GitHub custom metadata.
         * </p>
         * 
         * @param gitHubCommitConfigurationFieldMappings
         *        A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of
         *        GitHub commits to Amazon Kendra index field names. To create custom fields, use the
         *        <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
         *        The GitHub data source field names must exist in your GitHub custom metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gitHubCommitConfigurationFieldMappings(DataSourceToIndexFieldMapping... gitHubCommitConfigurationFieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub
         * commits to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API
         * before you map to GitHub fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * GitHub data source field names must exist in your GitHub custom metadata.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #gitHubCommitConfigurationFieldMappings(List<DataSourceToIndexFieldMapping>)}.
         * 
         * @param gitHubCommitConfigurationFieldMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gitHubCommitConfigurationFieldMappings(java.util.Collection<DataSourceToIndexFieldMapping>)
         */
        Builder gitHubCommitConfigurationFieldMappings(
                Consumer<DataSourceToIndexFieldMapping.Builder>... gitHubCommitConfigurationFieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub
         * issues to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API
         * before you map to GitHub fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * GitHub data source field names must exist in your GitHub custom metadata.
         * </p>
         * 
         * @param gitHubIssueDocumentConfigurationFieldMappings
         *        A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of
         *        GitHub issues to Amazon Kendra index field names. To create custom fields, use the
         *        <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
         *        The GitHub data source field names must exist in your GitHub custom metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gitHubIssueDocumentConfigurationFieldMappings(
                Collection<DataSourceToIndexFieldMapping> gitHubIssueDocumentConfigurationFieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub
         * issues to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API
         * before you map to GitHub fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * GitHub data source field names must exist in your GitHub custom metadata.
         * </p>
         * 
         * @param gitHubIssueDocumentConfigurationFieldMappings
         *        A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of
         *        GitHub issues to Amazon Kendra index field names. To create custom fields, use the
         *        <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
         *        The GitHub data source field names must exist in your GitHub custom metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gitHubIssueDocumentConfigurationFieldMappings(
                DataSourceToIndexFieldMapping... gitHubIssueDocumentConfigurationFieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub
         * issues to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API
         * before you map to GitHub fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * GitHub data source field names must exist in your GitHub custom metadata.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #gitHubIssueDocumentConfigurationFieldMappings(List<DataSourceToIndexFieldMapping>)}.
         * 
         * @param gitHubIssueDocumentConfigurationFieldMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gitHubIssueDocumentConfigurationFieldMappings(java.util.Collection<DataSourceToIndexFieldMapping>)
         */
        Builder gitHubIssueDocumentConfigurationFieldMappings(
                Consumer<DataSourceToIndexFieldMapping.Builder>... gitHubIssueDocumentConfigurationFieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub
         * issue comments to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code>
         * API before you map to GitHub fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * GitHub data source field names must exist in your GitHub custom metadata.
         * </p>
         * 
         * @param gitHubIssueCommentConfigurationFieldMappings
         *        A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of
         *        GitHub issue comments to Amazon Kendra index field names. To create custom fields, use the
         *        <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
         *        The GitHub data source field names must exist in your GitHub custom metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gitHubIssueCommentConfigurationFieldMappings(
                Collection<DataSourceToIndexFieldMapping> gitHubIssueCommentConfigurationFieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub
         * issue comments to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code>
         * API before you map to GitHub fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * GitHub data source field names must exist in your GitHub custom metadata.
         * </p>
         * 
         * @param gitHubIssueCommentConfigurationFieldMappings
         *        A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of
         *        GitHub issue comments to Amazon Kendra index field names. To create custom fields, use the
         *        <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
         *        The GitHub data source field names must exist in your GitHub custom metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gitHubIssueCommentConfigurationFieldMappings(
                DataSourceToIndexFieldMapping... gitHubIssueCommentConfigurationFieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub
         * issue comments to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code>
         * API before you map to GitHub fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * GitHub data source field names must exist in your GitHub custom metadata.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #gitHubIssueCommentConfigurationFieldMappings(List<DataSourceToIndexFieldMapping>)}.
         * 
         * @param gitHubIssueCommentConfigurationFieldMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gitHubIssueCommentConfigurationFieldMappings(java.util.Collection<DataSourceToIndexFieldMapping>)
         */
        Builder gitHubIssueCommentConfigurationFieldMappings(
                Consumer<DataSourceToIndexFieldMapping.Builder>... gitHubIssueCommentConfigurationFieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub
         * issue attachments to Amazon Kendra index field names. To create custom fields, use the
         * <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * GitHub data source field names must exist in your GitHub custom metadata.
         * </p>
         * 
         * @param gitHubIssueAttachmentConfigurationFieldMappings
         *        A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of
         *        GitHub issue attachments to Amazon Kendra index field names. To create custom fields, use the
         *        <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
         *        The GitHub data source field names must exist in your GitHub custom metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gitHubIssueAttachmentConfigurationFieldMappings(
                Collection<DataSourceToIndexFieldMapping> gitHubIssueAttachmentConfigurationFieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub
         * issue attachments to Amazon Kendra index field names. To create custom fields, use the
         * <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * GitHub data source field names must exist in your GitHub custom metadata.
         * </p>
         * 
         * @param gitHubIssueAttachmentConfigurationFieldMappings
         *        A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of
         *        GitHub issue attachments to Amazon Kendra index field names. To create custom fields, use the
         *        <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
         *        The GitHub data source field names must exist in your GitHub custom metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gitHubIssueAttachmentConfigurationFieldMappings(
                DataSourceToIndexFieldMapping... gitHubIssueAttachmentConfigurationFieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub
         * issue attachments to Amazon Kendra index field names. To create custom fields, use the
         * <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * GitHub data source field names must exist in your GitHub custom metadata.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #gitHubIssueAttachmentConfigurationFieldMappings(List<DataSourceToIndexFieldMapping>)}.
         * 
         * @param gitHubIssueAttachmentConfigurationFieldMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gitHubIssueAttachmentConfigurationFieldMappings(java.util.Collection<DataSourceToIndexFieldMapping>)
         */
        Builder gitHubIssueAttachmentConfigurationFieldMappings(
                Consumer<DataSourceToIndexFieldMapping.Builder>... gitHubIssueAttachmentConfigurationFieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub
         * pull request comments to Amazon Kendra index field names. To create custom fields, use the
         * <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * GitHub data source field names must exist in your GitHub custom metadata.
         * </p>
         * 
         * @param gitHubPullRequestCommentConfigurationFieldMappings
         *        A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of
         *        GitHub pull request comments to Amazon Kendra index field names. To create custom fields, use the
         *        <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
         *        The GitHub data source field names must exist in your GitHub custom metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gitHubPullRequestCommentConfigurationFieldMappings(
                Collection<DataSourceToIndexFieldMapping> gitHubPullRequestCommentConfigurationFieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub
         * pull request comments to Amazon Kendra index field names. To create custom fields, use the
         * <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * GitHub data source field names must exist in your GitHub custom metadata.
         * </p>
         * 
         * @param gitHubPullRequestCommentConfigurationFieldMappings
         *        A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of
         *        GitHub pull request comments to Amazon Kendra index field names. To create custom fields, use the
         *        <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
         *        The GitHub data source field names must exist in your GitHub custom metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gitHubPullRequestCommentConfigurationFieldMappings(
                DataSourceToIndexFieldMapping... gitHubPullRequestCommentConfigurationFieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub
         * pull request comments to Amazon Kendra index field names. To create custom fields, use the
         * <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * GitHub data source field names must exist in your GitHub custom metadata.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #gitHubPullRequestCommentConfigurationFieldMappings(List<DataSourceToIndexFieldMapping>)}.
         * 
         * @param gitHubPullRequestCommentConfigurationFieldMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gitHubPullRequestCommentConfigurationFieldMappings(java.util.Collection<DataSourceToIndexFieldMapping>)
         */
        Builder gitHubPullRequestCommentConfigurationFieldMappings(
                Consumer<DataSourceToIndexFieldMapping.Builder>... gitHubPullRequestCommentConfigurationFieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub
         * pull requests to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code>
         * API before you map to GitHub fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * GitHub data source field names must exist in your GitHub custom metadata.
         * </p>
         * 
         * @param gitHubPullRequestDocumentConfigurationFieldMappings
         *        A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of
         *        GitHub pull requests to Amazon Kendra index field names. To create custom fields, use the
         *        <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
         *        The GitHub data source field names must exist in your GitHub custom metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gitHubPullRequestDocumentConfigurationFieldMappings(
                Collection<DataSourceToIndexFieldMapping> gitHubPullRequestDocumentConfigurationFieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub
         * pull requests to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code>
         * API before you map to GitHub fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * GitHub data source field names must exist in your GitHub custom metadata.
         * </p>
         * 
         * @param gitHubPullRequestDocumentConfigurationFieldMappings
         *        A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of
         *        GitHub pull requests to Amazon Kendra index field names. To create custom fields, use the
         *        <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
         *        The GitHub data source field names must exist in your GitHub custom metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gitHubPullRequestDocumentConfigurationFieldMappings(
                DataSourceToIndexFieldMapping... gitHubPullRequestDocumentConfigurationFieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub
         * pull requests to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code>
         * API before you map to GitHub fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * GitHub data source field names must exist in your GitHub custom metadata.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #gitHubPullRequestDocumentConfigurationFieldMappings(List<DataSourceToIndexFieldMapping>)}.
         * 
         * @param gitHubPullRequestDocumentConfigurationFieldMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see 
         *      #gitHubPullRequestDocumentConfigurationFieldMappings(java.util.Collection<DataSourceToIndexFieldMapping>)
         */
        Builder gitHubPullRequestDocumentConfigurationFieldMappings(
                Consumer<DataSourceToIndexFieldMapping.Builder>... gitHubPullRequestDocumentConfigurationFieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub
         * pull request attachments to Amazon Kendra index field names. To create custom fields, use the
         * <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * GitHub data source field names must exist in your GitHub custom metadata.
         * </p>
         * 
         * @param gitHubPullRequestDocumentAttachmentConfigurationFieldMappings
         *        A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of
         *        GitHub pull request attachments to Amazon Kendra index field names. To create custom fields, use the
         *        <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
         *        The GitHub data source field names must exist in your GitHub custom metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gitHubPullRequestDocumentAttachmentConfigurationFieldMappings(
                Collection<DataSourceToIndexFieldMapping> gitHubPullRequestDocumentAttachmentConfigurationFieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub
         * pull request attachments to Amazon Kendra index field names. To create custom fields, use the
         * <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * GitHub data source field names must exist in your GitHub custom metadata.
         * </p>
         * 
         * @param gitHubPullRequestDocumentAttachmentConfigurationFieldMappings
         *        A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of
         *        GitHub pull request attachments to Amazon Kendra index field names. To create custom fields, use the
         *        <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
         *        The GitHub data source field names must exist in your GitHub custom metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gitHubPullRequestDocumentAttachmentConfigurationFieldMappings(
                DataSourceToIndexFieldMapping... gitHubPullRequestDocumentAttachmentConfigurationFieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub
         * pull request attachments to Amazon Kendra index field names. To create custom fields, use the
         * <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * GitHub data source field names must exist in your GitHub custom metadata.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #gitHubPullRequestDocumentAttachmentConfigurationFieldMappings(List<DataSourceToIndexFieldMapping>)}.
         * 
         * @param gitHubPullRequestDocumentAttachmentConfigurationFieldMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gitHubPullRequestDocumentAttachmentConfigurationFieldMappings(java.util.Collection<
         *      DataSourceToIndexFieldMapping>)
         */
        Builder gitHubPullRequestDocumentAttachmentConfigurationFieldMappings(
                Consumer<DataSourceToIndexFieldMapping.Builder>... gitHubPullRequestDocumentAttachmentConfigurationFieldMappings);
    }

    static final class BuilderImpl implements Builder {
        private SaaSConfiguration saaSConfiguration;

        private OnPremiseConfiguration onPremiseConfiguration;

        private String type;

        private String secretArn;

        private Boolean useChangeLog;

        private GitHubDocumentCrawlProperties gitHubDocumentCrawlProperties;

        private List<String> repositoryFilter = DefaultSdkAutoConstructList.getInstance();

        private List<String> inclusionFolderNamePatterns = DefaultSdkAutoConstructList.getInstance();

        private List<String> inclusionFileTypePatterns = DefaultSdkAutoConstructList.getInstance();

        private List<String> inclusionFileNamePatterns = DefaultSdkAutoConstructList.getInstance();

        private List<String> exclusionFolderNamePatterns = DefaultSdkAutoConstructList.getInstance();

        private List<String> exclusionFileTypePatterns = DefaultSdkAutoConstructList.getInstance();

        private List<String> exclusionFileNamePatterns = DefaultSdkAutoConstructList.getInstance();

        private DataSourceVpcConfiguration vpcConfiguration;

        private List<DataSourceToIndexFieldMapping> gitHubRepositoryConfigurationFieldMappings = DefaultSdkAutoConstructList
                .getInstance();

        private List<DataSourceToIndexFieldMapping> gitHubCommitConfigurationFieldMappings = DefaultSdkAutoConstructList
                .getInstance();

        private List<DataSourceToIndexFieldMapping> gitHubIssueDocumentConfigurationFieldMappings = DefaultSdkAutoConstructList
                .getInstance();

        private List<DataSourceToIndexFieldMapping> gitHubIssueCommentConfigurationFieldMappings = DefaultSdkAutoConstructList
                .getInstance();

        private List<DataSourceToIndexFieldMapping> gitHubIssueAttachmentConfigurationFieldMappings = DefaultSdkAutoConstructList
                .getInstance();

        private List<DataSourceToIndexFieldMapping> gitHubPullRequestCommentConfigurationFieldMappings = DefaultSdkAutoConstructList
                .getInstance();

        private List<DataSourceToIndexFieldMapping> gitHubPullRequestDocumentConfigurationFieldMappings = DefaultSdkAutoConstructList
                .getInstance();

        private List<DataSourceToIndexFieldMapping> gitHubPullRequestDocumentAttachmentConfigurationFieldMappings = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GitHubConfiguration model) {
            saaSConfiguration(model.saaSConfiguration);
            onPremiseConfiguration(model.onPremiseConfiguration);
            type(model.type);
            secretArn(model.secretArn);
            useChangeLog(model.useChangeLog);
            gitHubDocumentCrawlProperties(model.gitHubDocumentCrawlProperties);
            repositoryFilter(model.repositoryFilter);
            inclusionFolderNamePatterns(model.inclusionFolderNamePatterns);
            inclusionFileTypePatterns(model.inclusionFileTypePatterns);
            inclusionFileNamePatterns(model.inclusionFileNamePatterns);
            exclusionFolderNamePatterns(model.exclusionFolderNamePatterns);
            exclusionFileTypePatterns(model.exclusionFileTypePatterns);
            exclusionFileNamePatterns(model.exclusionFileNamePatterns);
            vpcConfiguration(model.vpcConfiguration);
            gitHubRepositoryConfigurationFieldMappings(model.gitHubRepositoryConfigurationFieldMappings);
            gitHubCommitConfigurationFieldMappings(model.gitHubCommitConfigurationFieldMappings);
            gitHubIssueDocumentConfigurationFieldMappings(model.gitHubIssueDocumentConfigurationFieldMappings);
            gitHubIssueCommentConfigurationFieldMappings(model.gitHubIssueCommentConfigurationFieldMappings);
            gitHubIssueAttachmentConfigurationFieldMappings(model.gitHubIssueAttachmentConfigurationFieldMappings);
            gitHubPullRequestCommentConfigurationFieldMappings(model.gitHubPullRequestCommentConfigurationFieldMappings);
            gitHubPullRequestDocumentConfigurationFieldMappings(model.gitHubPullRequestDocumentConfigurationFieldMappings);
            gitHubPullRequestDocumentAttachmentConfigurationFieldMappings(model.gitHubPullRequestDocumentAttachmentConfigurationFieldMappings);
        }

        public final SaaSConfiguration.Builder getSaaSConfiguration() {
            return saaSConfiguration != null ? saaSConfiguration.toBuilder() : null;
        }

        public final void setSaaSConfiguration(SaaSConfiguration.BuilderImpl saaSConfiguration) {
            this.saaSConfiguration = saaSConfiguration != null ? saaSConfiguration.build() : null;
        }

        @Override
        public final Builder saaSConfiguration(SaaSConfiguration saaSConfiguration) {
            this.saaSConfiguration = saaSConfiguration;
            return this;
        }

        public final OnPremiseConfiguration.Builder getOnPremiseConfiguration() {
            return onPremiseConfiguration != null ? onPremiseConfiguration.toBuilder() : null;
        }

        public final void setOnPremiseConfiguration(OnPremiseConfiguration.BuilderImpl onPremiseConfiguration) {
            this.onPremiseConfiguration = onPremiseConfiguration != null ? onPremiseConfiguration.build() : null;
        }

        @Override
        public final Builder onPremiseConfiguration(OnPremiseConfiguration onPremiseConfiguration) {
            this.onPremiseConfiguration = onPremiseConfiguration;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getSecretArn() {
            return secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final Boolean getUseChangeLog() {
            return useChangeLog;
        }

        public final void setUseChangeLog(Boolean useChangeLog) {
            this.useChangeLog = useChangeLog;
        }

        @Override
        public final Builder useChangeLog(Boolean useChangeLog) {
            this.useChangeLog = useChangeLog;
            return this;
        }

        public final GitHubDocumentCrawlProperties.Builder getGitHubDocumentCrawlProperties() {
            return gitHubDocumentCrawlProperties != null ? gitHubDocumentCrawlProperties.toBuilder() : null;
        }

        public final void setGitHubDocumentCrawlProperties(GitHubDocumentCrawlProperties.BuilderImpl gitHubDocumentCrawlProperties) {
            this.gitHubDocumentCrawlProperties = gitHubDocumentCrawlProperties != null ? gitHubDocumentCrawlProperties.build()
                    : null;
        }

        @Override
        public final Builder gitHubDocumentCrawlProperties(GitHubDocumentCrawlProperties gitHubDocumentCrawlProperties) {
            this.gitHubDocumentCrawlProperties = gitHubDocumentCrawlProperties;
            return this;
        }

        public final Collection<String> getRepositoryFilter() {
            if (repositoryFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return repositoryFilter;
        }

        public final void setRepositoryFilter(Collection<String> repositoryFilter) {
            this.repositoryFilter = RepositoryNamesCopier.copy(repositoryFilter);
        }

        @Override
        public final Builder repositoryFilter(Collection<String> repositoryFilter) {
            this.repositoryFilter = RepositoryNamesCopier.copy(repositoryFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositoryFilter(String... repositoryFilter) {
            repositoryFilter(Arrays.asList(repositoryFilter));
            return this;
        }

        public final Collection<String> getInclusionFolderNamePatterns() {
            if (inclusionFolderNamePatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return inclusionFolderNamePatterns;
        }

        public final void setInclusionFolderNamePatterns(Collection<String> inclusionFolderNamePatterns) {
            this.inclusionFolderNamePatterns = StringListCopier.copy(inclusionFolderNamePatterns);
        }

        @Override
        public final Builder inclusionFolderNamePatterns(Collection<String> inclusionFolderNamePatterns) {
            this.inclusionFolderNamePatterns = StringListCopier.copy(inclusionFolderNamePatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionFolderNamePatterns(String... inclusionFolderNamePatterns) {
            inclusionFolderNamePatterns(Arrays.asList(inclusionFolderNamePatterns));
            return this;
        }

        public final Collection<String> getInclusionFileTypePatterns() {
            if (inclusionFileTypePatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return inclusionFileTypePatterns;
        }

        public final void setInclusionFileTypePatterns(Collection<String> inclusionFileTypePatterns) {
            this.inclusionFileTypePatterns = StringListCopier.copy(inclusionFileTypePatterns);
        }

        @Override
        public final Builder inclusionFileTypePatterns(Collection<String> inclusionFileTypePatterns) {
            this.inclusionFileTypePatterns = StringListCopier.copy(inclusionFileTypePatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionFileTypePatterns(String... inclusionFileTypePatterns) {
            inclusionFileTypePatterns(Arrays.asList(inclusionFileTypePatterns));
            return this;
        }

        public final Collection<String> getInclusionFileNamePatterns() {
            if (inclusionFileNamePatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return inclusionFileNamePatterns;
        }

        public final void setInclusionFileNamePatterns(Collection<String> inclusionFileNamePatterns) {
            this.inclusionFileNamePatterns = StringListCopier.copy(inclusionFileNamePatterns);
        }

        @Override
        public final Builder inclusionFileNamePatterns(Collection<String> inclusionFileNamePatterns) {
            this.inclusionFileNamePatterns = StringListCopier.copy(inclusionFileNamePatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionFileNamePatterns(String... inclusionFileNamePatterns) {
            inclusionFileNamePatterns(Arrays.asList(inclusionFileNamePatterns));
            return this;
        }

        public final Collection<String> getExclusionFolderNamePatterns() {
            if (exclusionFolderNamePatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return exclusionFolderNamePatterns;
        }

        public final void setExclusionFolderNamePatterns(Collection<String> exclusionFolderNamePatterns) {
            this.exclusionFolderNamePatterns = StringListCopier.copy(exclusionFolderNamePatterns);
        }

        @Override
        public final Builder exclusionFolderNamePatterns(Collection<String> exclusionFolderNamePatterns) {
            this.exclusionFolderNamePatterns = StringListCopier.copy(exclusionFolderNamePatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionFolderNamePatterns(String... exclusionFolderNamePatterns) {
            exclusionFolderNamePatterns(Arrays.asList(exclusionFolderNamePatterns));
            return this;
        }

        public final Collection<String> getExclusionFileTypePatterns() {
            if (exclusionFileTypePatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return exclusionFileTypePatterns;
        }

        public final void setExclusionFileTypePatterns(Collection<String> exclusionFileTypePatterns) {
            this.exclusionFileTypePatterns = StringListCopier.copy(exclusionFileTypePatterns);
        }

        @Override
        public final Builder exclusionFileTypePatterns(Collection<String> exclusionFileTypePatterns) {
            this.exclusionFileTypePatterns = StringListCopier.copy(exclusionFileTypePatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionFileTypePatterns(String... exclusionFileTypePatterns) {
            exclusionFileTypePatterns(Arrays.asList(exclusionFileTypePatterns));
            return this;
        }

        public final Collection<String> getExclusionFileNamePatterns() {
            if (exclusionFileNamePatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return exclusionFileNamePatterns;
        }

        public final void setExclusionFileNamePatterns(Collection<String> exclusionFileNamePatterns) {
            this.exclusionFileNamePatterns = StringListCopier.copy(exclusionFileNamePatterns);
        }

        @Override
        public final Builder exclusionFileNamePatterns(Collection<String> exclusionFileNamePatterns) {
            this.exclusionFileNamePatterns = StringListCopier.copy(exclusionFileNamePatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionFileNamePatterns(String... exclusionFileNamePatterns) {
            exclusionFileNamePatterns(Arrays.asList(exclusionFileNamePatterns));
            return this;
        }

        public final DataSourceVpcConfiguration.Builder getVpcConfiguration() {
            return vpcConfiguration != null ? vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(DataSourceVpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getGitHubRepositoryConfigurationFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier
                    .copyToBuilder(this.gitHubRepositoryConfigurationFieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGitHubRepositoryConfigurationFieldMappings(
                Collection<DataSourceToIndexFieldMapping.BuilderImpl> gitHubRepositoryConfigurationFieldMappings) {
            this.gitHubRepositoryConfigurationFieldMappings = DataSourceToIndexFieldMappingListCopier
                    .copyFromBuilder(gitHubRepositoryConfigurationFieldMappings);
        }

        @Override
        public final Builder gitHubRepositoryConfigurationFieldMappings(
                Collection<DataSourceToIndexFieldMapping> gitHubRepositoryConfigurationFieldMappings) {
            this.gitHubRepositoryConfigurationFieldMappings = DataSourceToIndexFieldMappingListCopier
                    .copy(gitHubRepositoryConfigurationFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gitHubRepositoryConfigurationFieldMappings(
                DataSourceToIndexFieldMapping... gitHubRepositoryConfigurationFieldMappings) {
            gitHubRepositoryConfigurationFieldMappings(Arrays.asList(gitHubRepositoryConfigurationFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gitHubRepositoryConfigurationFieldMappings(
                Consumer<DataSourceToIndexFieldMapping.Builder>... gitHubRepositoryConfigurationFieldMappings) {
            gitHubRepositoryConfigurationFieldMappings(Stream.of(gitHubRepositoryConfigurationFieldMappings)
                    .map(c -> DataSourceToIndexFieldMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getGitHubCommitConfigurationFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier
                    .copyToBuilder(this.gitHubCommitConfigurationFieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGitHubCommitConfigurationFieldMappings(
                Collection<DataSourceToIndexFieldMapping.BuilderImpl> gitHubCommitConfigurationFieldMappings) {
            this.gitHubCommitConfigurationFieldMappings = DataSourceToIndexFieldMappingListCopier
                    .copyFromBuilder(gitHubCommitConfigurationFieldMappings);
        }

        @Override
        public final Builder gitHubCommitConfigurationFieldMappings(
                Collection<DataSourceToIndexFieldMapping> gitHubCommitConfigurationFieldMappings) {
            this.gitHubCommitConfigurationFieldMappings = DataSourceToIndexFieldMappingListCopier
                    .copy(gitHubCommitConfigurationFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gitHubCommitConfigurationFieldMappings(
                DataSourceToIndexFieldMapping... gitHubCommitConfigurationFieldMappings) {
            gitHubCommitConfigurationFieldMappings(Arrays.asList(gitHubCommitConfigurationFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gitHubCommitConfigurationFieldMappings(
                Consumer<DataSourceToIndexFieldMapping.Builder>... gitHubCommitConfigurationFieldMappings) {
            gitHubCommitConfigurationFieldMappings(Stream.of(gitHubCommitConfigurationFieldMappings)
                    .map(c -> DataSourceToIndexFieldMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getGitHubIssueDocumentConfigurationFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier
                    .copyToBuilder(this.gitHubIssueDocumentConfigurationFieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGitHubIssueDocumentConfigurationFieldMappings(
                Collection<DataSourceToIndexFieldMapping.BuilderImpl> gitHubIssueDocumentConfigurationFieldMappings) {
            this.gitHubIssueDocumentConfigurationFieldMappings = DataSourceToIndexFieldMappingListCopier
                    .copyFromBuilder(gitHubIssueDocumentConfigurationFieldMappings);
        }

        @Override
        public final Builder gitHubIssueDocumentConfigurationFieldMappings(
                Collection<DataSourceToIndexFieldMapping> gitHubIssueDocumentConfigurationFieldMappings) {
            this.gitHubIssueDocumentConfigurationFieldMappings = DataSourceToIndexFieldMappingListCopier
                    .copy(gitHubIssueDocumentConfigurationFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gitHubIssueDocumentConfigurationFieldMappings(
                DataSourceToIndexFieldMapping... gitHubIssueDocumentConfigurationFieldMappings) {
            gitHubIssueDocumentConfigurationFieldMappings(Arrays.asList(gitHubIssueDocumentConfigurationFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gitHubIssueDocumentConfigurationFieldMappings(
                Consumer<DataSourceToIndexFieldMapping.Builder>... gitHubIssueDocumentConfigurationFieldMappings) {
            gitHubIssueDocumentConfigurationFieldMappings(Stream.of(gitHubIssueDocumentConfigurationFieldMappings)
                    .map(c -> DataSourceToIndexFieldMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getGitHubIssueCommentConfigurationFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier
                    .copyToBuilder(this.gitHubIssueCommentConfigurationFieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGitHubIssueCommentConfigurationFieldMappings(
                Collection<DataSourceToIndexFieldMapping.BuilderImpl> gitHubIssueCommentConfigurationFieldMappings) {
            this.gitHubIssueCommentConfigurationFieldMappings = DataSourceToIndexFieldMappingListCopier
                    .copyFromBuilder(gitHubIssueCommentConfigurationFieldMappings);
        }

        @Override
        public final Builder gitHubIssueCommentConfigurationFieldMappings(
                Collection<DataSourceToIndexFieldMapping> gitHubIssueCommentConfigurationFieldMappings) {
            this.gitHubIssueCommentConfigurationFieldMappings = DataSourceToIndexFieldMappingListCopier
                    .copy(gitHubIssueCommentConfigurationFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gitHubIssueCommentConfigurationFieldMappings(
                DataSourceToIndexFieldMapping... gitHubIssueCommentConfigurationFieldMappings) {
            gitHubIssueCommentConfigurationFieldMappings(Arrays.asList(gitHubIssueCommentConfigurationFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gitHubIssueCommentConfigurationFieldMappings(
                Consumer<DataSourceToIndexFieldMapping.Builder>... gitHubIssueCommentConfigurationFieldMappings) {
            gitHubIssueCommentConfigurationFieldMappings(Stream.of(gitHubIssueCommentConfigurationFieldMappings)
                    .map(c -> DataSourceToIndexFieldMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getGitHubIssueAttachmentConfigurationFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier
                    .copyToBuilder(this.gitHubIssueAttachmentConfigurationFieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGitHubIssueAttachmentConfigurationFieldMappings(
                Collection<DataSourceToIndexFieldMapping.BuilderImpl> gitHubIssueAttachmentConfigurationFieldMappings) {
            this.gitHubIssueAttachmentConfigurationFieldMappings = DataSourceToIndexFieldMappingListCopier
                    .copyFromBuilder(gitHubIssueAttachmentConfigurationFieldMappings);
        }

        @Override
        public final Builder gitHubIssueAttachmentConfigurationFieldMappings(
                Collection<DataSourceToIndexFieldMapping> gitHubIssueAttachmentConfigurationFieldMappings) {
            this.gitHubIssueAttachmentConfigurationFieldMappings = DataSourceToIndexFieldMappingListCopier
                    .copy(gitHubIssueAttachmentConfigurationFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gitHubIssueAttachmentConfigurationFieldMappings(
                DataSourceToIndexFieldMapping... gitHubIssueAttachmentConfigurationFieldMappings) {
            gitHubIssueAttachmentConfigurationFieldMappings(Arrays.asList(gitHubIssueAttachmentConfigurationFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gitHubIssueAttachmentConfigurationFieldMappings(
                Consumer<DataSourceToIndexFieldMapping.Builder>... gitHubIssueAttachmentConfigurationFieldMappings) {
            gitHubIssueAttachmentConfigurationFieldMappings(Stream.of(gitHubIssueAttachmentConfigurationFieldMappings)
                    .map(c -> DataSourceToIndexFieldMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getGitHubPullRequestCommentConfigurationFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier
                    .copyToBuilder(this.gitHubPullRequestCommentConfigurationFieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGitHubPullRequestCommentConfigurationFieldMappings(
                Collection<DataSourceToIndexFieldMapping.BuilderImpl> gitHubPullRequestCommentConfigurationFieldMappings) {
            this.gitHubPullRequestCommentConfigurationFieldMappings = DataSourceToIndexFieldMappingListCopier
                    .copyFromBuilder(gitHubPullRequestCommentConfigurationFieldMappings);
        }

        @Override
        public final Builder gitHubPullRequestCommentConfigurationFieldMappings(
                Collection<DataSourceToIndexFieldMapping> gitHubPullRequestCommentConfigurationFieldMappings) {
            this.gitHubPullRequestCommentConfigurationFieldMappings = DataSourceToIndexFieldMappingListCopier
                    .copy(gitHubPullRequestCommentConfigurationFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gitHubPullRequestCommentConfigurationFieldMappings(
                DataSourceToIndexFieldMapping... gitHubPullRequestCommentConfigurationFieldMappings) {
            gitHubPullRequestCommentConfigurationFieldMappings(Arrays.asList(gitHubPullRequestCommentConfigurationFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gitHubPullRequestCommentConfigurationFieldMappings(
                Consumer<DataSourceToIndexFieldMapping.Builder>... gitHubPullRequestCommentConfigurationFieldMappings) {
            gitHubPullRequestCommentConfigurationFieldMappings(Stream.of(gitHubPullRequestCommentConfigurationFieldMappings)
                    .map(c -> DataSourceToIndexFieldMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getGitHubPullRequestDocumentConfigurationFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier
                    .copyToBuilder(this.gitHubPullRequestDocumentConfigurationFieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGitHubPullRequestDocumentConfigurationFieldMappings(
                Collection<DataSourceToIndexFieldMapping.BuilderImpl> gitHubPullRequestDocumentConfigurationFieldMappings) {
            this.gitHubPullRequestDocumentConfigurationFieldMappings = DataSourceToIndexFieldMappingListCopier
                    .copyFromBuilder(gitHubPullRequestDocumentConfigurationFieldMappings);
        }

        @Override
        public final Builder gitHubPullRequestDocumentConfigurationFieldMappings(
                Collection<DataSourceToIndexFieldMapping> gitHubPullRequestDocumentConfigurationFieldMappings) {
            this.gitHubPullRequestDocumentConfigurationFieldMappings = DataSourceToIndexFieldMappingListCopier
                    .copy(gitHubPullRequestDocumentConfigurationFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gitHubPullRequestDocumentConfigurationFieldMappings(
                DataSourceToIndexFieldMapping... gitHubPullRequestDocumentConfigurationFieldMappings) {
            gitHubPullRequestDocumentConfigurationFieldMappings(Arrays
                    .asList(gitHubPullRequestDocumentConfigurationFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gitHubPullRequestDocumentConfigurationFieldMappings(
                Consumer<DataSourceToIndexFieldMapping.Builder>... gitHubPullRequestDocumentConfigurationFieldMappings) {
            gitHubPullRequestDocumentConfigurationFieldMappings(Stream.of(gitHubPullRequestDocumentConfigurationFieldMappings)
                    .map(c -> DataSourceToIndexFieldMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getGitHubPullRequestDocumentAttachmentConfigurationFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier
                    .copyToBuilder(this.gitHubPullRequestDocumentAttachmentConfigurationFieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGitHubPullRequestDocumentAttachmentConfigurationFieldMappings(
                Collection<DataSourceToIndexFieldMapping.BuilderImpl> gitHubPullRequestDocumentAttachmentConfigurationFieldMappings) {
            this.gitHubPullRequestDocumentAttachmentConfigurationFieldMappings = DataSourceToIndexFieldMappingListCopier
                    .copyFromBuilder(gitHubPullRequestDocumentAttachmentConfigurationFieldMappings);
        }

        @Override
        public final Builder gitHubPullRequestDocumentAttachmentConfigurationFieldMappings(
                Collection<DataSourceToIndexFieldMapping> gitHubPullRequestDocumentAttachmentConfigurationFieldMappings) {
            this.gitHubPullRequestDocumentAttachmentConfigurationFieldMappings = DataSourceToIndexFieldMappingListCopier
                    .copy(gitHubPullRequestDocumentAttachmentConfigurationFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gitHubPullRequestDocumentAttachmentConfigurationFieldMappings(
                DataSourceToIndexFieldMapping... gitHubPullRequestDocumentAttachmentConfigurationFieldMappings) {
            gitHubPullRequestDocumentAttachmentConfigurationFieldMappings(Arrays
                    .asList(gitHubPullRequestDocumentAttachmentConfigurationFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gitHubPullRequestDocumentAttachmentConfigurationFieldMappings(
                Consumer<DataSourceToIndexFieldMapping.Builder>... gitHubPullRequestDocumentAttachmentConfigurationFieldMappings) {
            gitHubPullRequestDocumentAttachmentConfigurationFieldMappings(Stream
                    .of(gitHubPullRequestDocumentAttachmentConfigurationFieldMappings)
                    .map(c -> DataSourceToIndexFieldMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GitHubConfiguration build() {
            return new GitHubConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
