/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Gets information on the configuration of document fields/attributes that you want to base query suggestions on. To
 * change your configuration, use <a
 * href="https://docs.aws.amazon.com/kendra/latest/dg/API_AttributeSuggestionsUpdateConfig.html"
 * >AttributeSuggestionsUpdateConfig</a> and then call <a
 * href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateQuerySuggestionsConfig.html"
 * >UpdateQuerySuggestionsConfig</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttributeSuggestionsDescribeConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AttributeSuggestionsDescribeConfig.Builder, AttributeSuggestionsDescribeConfig> {
    private static final SdkField<List<SuggestableConfig>> SUGGESTABLE_CONFIG_LIST_FIELD = SdkField
            .<List<SuggestableConfig>> builder(MarshallingType.LIST)
            .memberName("SuggestableConfigList")
            .getter(getter(AttributeSuggestionsDescribeConfig::suggestableConfigList))
            .setter(setter(Builder::suggestableConfigList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuggestableConfigList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SuggestableConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(SuggestableConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ATTRIBUTE_SUGGESTIONS_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeSuggestionsMode")
            .getter(getter(AttributeSuggestionsDescribeConfig::attributeSuggestionsModeAsString))
            .setter(setter(Builder::attributeSuggestionsMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeSuggestionsMode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUGGESTABLE_CONFIG_LIST_FIELD,
            ATTRIBUTE_SUGGESTIONS_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<SuggestableConfig> suggestableConfigList;

    private final String attributeSuggestionsMode;

    private AttributeSuggestionsDescribeConfig(BuilderImpl builder) {
        this.suggestableConfigList = builder.suggestableConfigList;
        this.attributeSuggestionsMode = builder.attributeSuggestionsMode;
    }

    /**
     * For responses, this returns true if the service returned a value for the SuggestableConfigList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSuggestableConfigList() {
        return suggestableConfigList != null && !(suggestableConfigList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of fields/attributes that you want to set as suggestible for query suggestions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuggestableConfigList} method.
     * </p>
     * 
     * @return The list of fields/attributes that you want to set as suggestible for query suggestions.
     */
    public final List<SuggestableConfig> suggestableConfigList() {
        return suggestableConfigList;
    }

    /**
     * <p>
     * The mode is set to either <code>ACTIVE</code> or <code>INACTIVE</code>. If the <code>Mode</code> for query
     * history is set to <code>ENABLED</code> when calling <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateQuerySuggestionsConfig.html"
     * >UpdateQuerySuggestionsConfig</a> and <code>AttributeSuggestionsMode</code> to use fields/attributes is set to
     * <code>ACTIVE</code>, and you haven't set your <code>SuggestionTypes</code> preference to
     * <code>DOCUMENT_ATTRIBUTES</code>, then Amazon Kendra uses the query history.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #attributeSuggestionsMode} will return {@link AttributeSuggestionsMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #attributeSuggestionsModeAsString}.
     * </p>
     * 
     * @return The mode is set to either <code>ACTIVE</code> or <code>INACTIVE</code>. If the <code>Mode</code> for
     *         query history is set to <code>ENABLED</code> when calling <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateQuerySuggestionsConfig.html"
     *         >UpdateQuerySuggestionsConfig</a> and <code>AttributeSuggestionsMode</code> to use fields/attributes is
     *         set to <code>ACTIVE</code>, and you haven't set your <code>SuggestionTypes</code> preference to
     *         <code>DOCUMENT_ATTRIBUTES</code>, then Amazon Kendra uses the query history.
     * @see AttributeSuggestionsMode
     */
    public final AttributeSuggestionsMode attributeSuggestionsMode() {
        return AttributeSuggestionsMode.fromValue(attributeSuggestionsMode);
    }

    /**
     * <p>
     * The mode is set to either <code>ACTIVE</code> or <code>INACTIVE</code>. If the <code>Mode</code> for query
     * history is set to <code>ENABLED</code> when calling <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateQuerySuggestionsConfig.html"
     * >UpdateQuerySuggestionsConfig</a> and <code>AttributeSuggestionsMode</code> to use fields/attributes is set to
     * <code>ACTIVE</code>, and you haven't set your <code>SuggestionTypes</code> preference to
     * <code>DOCUMENT_ATTRIBUTES</code>, then Amazon Kendra uses the query history.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #attributeSuggestionsMode} will return {@link AttributeSuggestionsMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #attributeSuggestionsModeAsString}.
     * </p>
     * 
     * @return The mode is set to either <code>ACTIVE</code> or <code>INACTIVE</code>. If the <code>Mode</code> for
     *         query history is set to <code>ENABLED</code> when calling <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateQuerySuggestionsConfig.html"
     *         >UpdateQuerySuggestionsConfig</a> and <code>AttributeSuggestionsMode</code> to use fields/attributes is
     *         set to <code>ACTIVE</code>, and you haven't set your <code>SuggestionTypes</code> preference to
     *         <code>DOCUMENT_ATTRIBUTES</code>, then Amazon Kendra uses the query history.
     * @see AttributeSuggestionsMode
     */
    public final String attributeSuggestionsModeAsString() {
        return attributeSuggestionsMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSuggestableConfigList() ? suggestableConfigList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(attributeSuggestionsModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeSuggestionsDescribeConfig)) {
            return false;
        }
        AttributeSuggestionsDescribeConfig other = (AttributeSuggestionsDescribeConfig) obj;
        return hasSuggestableConfigList() == other.hasSuggestableConfigList()
                && Objects.equals(suggestableConfigList(), other.suggestableConfigList())
                && Objects.equals(attributeSuggestionsModeAsString(), other.attributeSuggestionsModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttributeSuggestionsDescribeConfig")
                .add("SuggestableConfigList", hasSuggestableConfigList() ? suggestableConfigList() : null)
                .add("AttributeSuggestionsMode", attributeSuggestionsModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SuggestableConfigList":
            return Optional.ofNullable(clazz.cast(suggestableConfigList()));
        case "AttributeSuggestionsMode":
            return Optional.ofNullable(clazz.cast(attributeSuggestionsModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttributeSuggestionsDescribeConfig, T> g) {
        return obj -> g.apply((AttributeSuggestionsDescribeConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttributeSuggestionsDescribeConfig> {
        /**
         * <p>
         * The list of fields/attributes that you want to set as suggestible for query suggestions.
         * </p>
         * 
         * @param suggestableConfigList
         *        The list of fields/attributes that you want to set as suggestible for query suggestions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestableConfigList(Collection<SuggestableConfig> suggestableConfigList);

        /**
         * <p>
         * The list of fields/attributes that you want to set as suggestible for query suggestions.
         * </p>
         * 
         * @param suggestableConfigList
         *        The list of fields/attributes that you want to set as suggestible for query suggestions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestableConfigList(SuggestableConfig... suggestableConfigList);

        /**
         * <p>
         * The list of fields/attributes that you want to set as suggestible for query suggestions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.SuggestableConfig.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.kendra.model.SuggestableConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.SuggestableConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #suggestableConfigList(List<SuggestableConfig>)}.
         * 
         * @param suggestableConfigList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.SuggestableConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #suggestableConfigList(java.util.Collection<SuggestableConfig>)
         */
        Builder suggestableConfigList(Consumer<SuggestableConfig.Builder>... suggestableConfigList);

        /**
         * <p>
         * The mode is set to either <code>ACTIVE</code> or <code>INACTIVE</code>. If the <code>Mode</code> for query
         * history is set to <code>ENABLED</code> when calling <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateQuerySuggestionsConfig.html"
         * >UpdateQuerySuggestionsConfig</a> and <code>AttributeSuggestionsMode</code> to use fields/attributes is set
         * to <code>ACTIVE</code>, and you haven't set your <code>SuggestionTypes</code> preference to
         * <code>DOCUMENT_ATTRIBUTES</code>, then Amazon Kendra uses the query history.
         * </p>
         * 
         * @param attributeSuggestionsMode
         *        The mode is set to either <code>ACTIVE</code> or <code>INACTIVE</code>. If the <code>Mode</code> for
         *        query history is set to <code>ENABLED</code> when calling <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateQuerySuggestionsConfig.html"
         *        >UpdateQuerySuggestionsConfig</a> and <code>AttributeSuggestionsMode</code> to use fields/attributes
         *        is set to <code>ACTIVE</code>, and you haven't set your <code>SuggestionTypes</code> preference to
         *        <code>DOCUMENT_ATTRIBUTES</code>, then Amazon Kendra uses the query history.
         * @see AttributeSuggestionsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttributeSuggestionsMode
         */
        Builder attributeSuggestionsMode(String attributeSuggestionsMode);

        /**
         * <p>
         * The mode is set to either <code>ACTIVE</code> or <code>INACTIVE</code>. If the <code>Mode</code> for query
         * history is set to <code>ENABLED</code> when calling <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateQuerySuggestionsConfig.html"
         * >UpdateQuerySuggestionsConfig</a> and <code>AttributeSuggestionsMode</code> to use fields/attributes is set
         * to <code>ACTIVE</code>, and you haven't set your <code>SuggestionTypes</code> preference to
         * <code>DOCUMENT_ATTRIBUTES</code>, then Amazon Kendra uses the query history.
         * </p>
         * 
         * @param attributeSuggestionsMode
         *        The mode is set to either <code>ACTIVE</code> or <code>INACTIVE</code>. If the <code>Mode</code> for
         *        query history is set to <code>ENABLED</code> when calling <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateQuerySuggestionsConfig.html"
         *        >UpdateQuerySuggestionsConfig</a> and <code>AttributeSuggestionsMode</code> to use fields/attributes
         *        is set to <code>ACTIVE</code>, and you haven't set your <code>SuggestionTypes</code> preference to
         *        <code>DOCUMENT_ATTRIBUTES</code>, then Amazon Kendra uses the query history.
         * @see AttributeSuggestionsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttributeSuggestionsMode
         */
        Builder attributeSuggestionsMode(AttributeSuggestionsMode attributeSuggestionsMode);
    }

    static final class BuilderImpl implements Builder {
        private List<SuggestableConfig> suggestableConfigList = DefaultSdkAutoConstructList.getInstance();

        private String attributeSuggestionsMode;

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeSuggestionsDescribeConfig model) {
            suggestableConfigList(model.suggestableConfigList);
            attributeSuggestionsMode(model.attributeSuggestionsMode);
        }

        public final List<SuggestableConfig.Builder> getSuggestableConfigList() {
            List<SuggestableConfig.Builder> result = SuggestableConfigListCopier.copyToBuilder(this.suggestableConfigList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuggestableConfigList(Collection<SuggestableConfig.BuilderImpl> suggestableConfigList) {
            this.suggestableConfigList = SuggestableConfigListCopier.copyFromBuilder(suggestableConfigList);
        }

        @Override
        public final Builder suggestableConfigList(Collection<SuggestableConfig> suggestableConfigList) {
            this.suggestableConfigList = SuggestableConfigListCopier.copy(suggestableConfigList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestableConfigList(SuggestableConfig... suggestableConfigList) {
            suggestableConfigList(Arrays.asList(suggestableConfigList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestableConfigList(Consumer<SuggestableConfig.Builder>... suggestableConfigList) {
            suggestableConfigList(Stream.of(suggestableConfigList).map(c -> SuggestableConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getAttributeSuggestionsMode() {
            return attributeSuggestionsMode;
        }

        public final void setAttributeSuggestionsMode(String attributeSuggestionsMode) {
            this.attributeSuggestionsMode = attributeSuggestionsMode;
        }

        @Override
        public final Builder attributeSuggestionsMode(String attributeSuggestionsMode) {
            this.attributeSuggestionsMode = attributeSuggestionsMode;
            return this;
        }

        @Override
        public final Builder attributeSuggestionsMode(AttributeSuggestionsMode attributeSuggestionsMode) {
            this.attributeSuggestionsMode(attributeSuggestionsMode == null ? null : attributeSuggestionsMode.toString());
            return this;
        }

        @Override
        public AttributeSuggestionsDescribeConfig build() {
            return new AttributeSuggestionsDescribeConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
