/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kendra.KendraClient;
import software.amazon.awssdk.services.kendra.model.ListAccessControlConfigurationsRequest;
import software.amazon.awssdk.services.kendra.model.ListAccessControlConfigurationsResponse;

public class ListAccessControlConfigurationsIterable
implements SdkIterable<ListAccessControlConfigurationsResponse> {
    private final KendraClient client;
    private final ListAccessControlConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccessControlConfigurationsIterable(KendraClient client, ListAccessControlConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAccessControlConfigurationsResponseFetcher();
    }

    public Iterator<ListAccessControlConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAccessControlConfigurationsResponseFetcher
    implements SyncPageFetcher<ListAccessControlConfigurationsResponse> {
        private ListAccessControlConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessControlConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAccessControlConfigurationsResponse nextPage(ListAccessControlConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListAccessControlConfigurationsIterable.this.client.listAccessControlConfigurations(ListAccessControlConfigurationsIterable.this.firstRequest);
            }
            return ListAccessControlConfigurationsIterable.this.client.listAccessControlConfigurations((ListAccessControlConfigurationsRequest)((Object)ListAccessControlConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

