/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DocumentAttributeValueType {
    STRING_VALUE("STRING_VALUE"),
    STRING_LIST_VALUE("STRING_LIST_VALUE"),
    LONG_VALUE("LONG_VALUE"),
    DATE_VALUE("DATE_VALUE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DocumentAttributeValueType> VALUE_MAP;
    private final String value;

    private DocumentAttributeValueType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DocumentAttributeValueType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DocumentAttributeValueType> knownValues() {
        EnumSet<DocumentAttributeValueType> knownValues = EnumSet.allOf(DocumentAttributeValueType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DocumentAttributeValueType.class, DocumentAttributeValueType::toString);
    }
}

