/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.BatchGetDocumentStatusResponseError;
import software.amazon.awssdk.services.kendra.model.BatchGetDocumentStatusResponseErrorsCopier;
import software.amazon.awssdk.services.kendra.model.DocumentStatusListCopier;
import software.amazon.awssdk.services.kendra.model.KendraResponse;
import software.amazon.awssdk.services.kendra.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetDocumentStatusResponse
extends KendraResponse
implements ToCopyableBuilder<Builder, BatchGetDocumentStatusResponse> {
    private static final SdkField<List<BatchGetDocumentStatusResponseError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(BatchGetDocumentStatusResponse.getter(BatchGetDocumentStatusResponse::errors)).setter(BatchGetDocumentStatusResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetDocumentStatusResponseError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Status>> DOCUMENT_STATUS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DocumentStatusList").getter(BatchGetDocumentStatusResponse.getter(BatchGetDocumentStatusResponse::documentStatusList)).setter(BatchGetDocumentStatusResponse.setter(Builder::documentStatusList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentStatusList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Status::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD, DOCUMENT_STATUS_LIST_FIELD));
    private final List<BatchGetDocumentStatusResponseError> errors;
    private final List<Status> documentStatusList;

    private BatchGetDocumentStatusResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
        this.documentStatusList = builder.documentStatusList;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<BatchGetDocumentStatusResponseError> errors() {
        return this.errors;
    }

    public final boolean hasDocumentStatusList() {
        return this.documentStatusList != null && !(this.documentStatusList instanceof SdkAutoConstructList);
    }

    public final List<Status> documentStatusList() {
        return this.documentStatusList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDocumentStatusList() ? this.documentStatusList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDocumentStatusResponse)) {
            return false;
        }
        BatchGetDocumentStatusResponse other = (BatchGetDocumentStatusResponse)((Object)obj);
        return this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors()) && this.hasDocumentStatusList() == other.hasDocumentStatusList() && Objects.equals(this.documentStatusList(), other.documentStatusList());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetDocumentStatusResponse").add("Errors", this.hasErrors() ? this.errors() : null).add("DocumentStatusList", this.hasDocumentStatusList() ? this.documentStatusList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
            case "DocumentStatusList": {
                return Optional.ofNullable(clazz.cast(this.documentStatusList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetDocumentStatusResponse, T> g) {
        return obj -> g.apply((BatchGetDocumentStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraResponse.BuilderImpl
    implements Builder {
        private List<BatchGetDocumentStatusResponseError> errors = DefaultSdkAutoConstructList.getInstance();
        private List<Status> documentStatusList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDocumentStatusResponse model) {
            super(model);
            this.errors(model.errors);
            this.documentStatusList(model.documentStatusList);
        }

        public final List<BatchGetDocumentStatusResponseError.Builder> getErrors() {
            List<BatchGetDocumentStatusResponseError.Builder> result = BatchGetDocumentStatusResponseErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchGetDocumentStatusResponseError.BuilderImpl> errors) {
            this.errors = BatchGetDocumentStatusResponseErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchGetDocumentStatusResponseError> errors) {
            this.errors = BatchGetDocumentStatusResponseErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchGetDocumentStatusResponseError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchGetDocumentStatusResponseError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchGetDocumentStatusResponseError)((BatchGetDocumentStatusResponseError.Builder)BatchGetDocumentStatusResponseError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Status.Builder> getDocumentStatusList() {
            List<Status.Builder> result = DocumentStatusListCopier.copyToBuilder(this.documentStatusList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentStatusList(Collection<Status.BuilderImpl> documentStatusList) {
            this.documentStatusList = DocumentStatusListCopier.copyFromBuilder(documentStatusList);
        }

        @Override
        public final Builder documentStatusList(Collection<Status> documentStatusList) {
            this.documentStatusList = DocumentStatusListCopier.copy(documentStatusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentStatusList(Status ... documentStatusList) {
            this.documentStatusList(Arrays.asList(documentStatusList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentStatusList(Consumer<Status.Builder> ... documentStatusList) {
            this.documentStatusList(Stream.of(documentStatusList).map(c -> (Status)((Status.Builder)Status.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetDocumentStatusResponse build() {
            return new BatchGetDocumentStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KendraResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetDocumentStatusResponse> {
        public Builder errors(Collection<BatchGetDocumentStatusResponseError> var1);

        public Builder errors(BatchGetDocumentStatusResponseError ... var1);

        public Builder errors(Consumer<BatchGetDocumentStatusResponseError.Builder> ... var1);

        public Builder documentStatusList(Collection<Status> var1);

        public Builder documentStatusList(Status ... var1);

        public Builder documentStatusList(Consumer<Status.Builder> ... var1);
    }
}

