/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kendra.KendraClient;
import software.amazon.awssdk.services.kendra.internal.UserAgentUtils;
import software.amazon.awssdk.services.kendra.model.ListThesauriRequest;
import software.amazon.awssdk.services.kendra.model.ListThesauriResponse;

public class ListThesauriIterable
implements SdkIterable<ListThesauriResponse> {
    private final KendraClient client;
    private final ListThesauriRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListThesauriIterable(KendraClient client, ListThesauriRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListThesauriResponseFetcher();
    }

    public Iterator<ListThesauriResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListThesauriResponseFetcher
    implements SyncPageFetcher<ListThesauriResponse> {
        private ListThesauriResponseFetcher() {
        }

        public boolean hasNextPage(ListThesauriResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListThesauriResponse nextPage(ListThesauriResponse previousPage) {
            if (previousPage == null) {
                return ListThesauriIterable.this.client.listThesauri(ListThesauriIterable.this.firstRequest);
            }
            return ListThesauriIterable.this.client.listThesauri((ListThesauriRequest)((Object)ListThesauriIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

