/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kendra.KendraClient;
import software.amazon.awssdk.services.kendra.model.ListFaqsRequest;
import software.amazon.awssdk.services.kendra.model.ListFaqsResponse;

public class ListFaqsIterable
implements SdkIterable<ListFaqsResponse> {
    private final KendraClient client;
    private final ListFaqsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFaqsIterable(KendraClient client, ListFaqsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListFaqsResponseFetcher();
    }

    public Iterator<ListFaqsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListFaqsResponseFetcher
    implements SyncPageFetcher<ListFaqsResponse> {
        private ListFaqsResponseFetcher() {
        }

        public boolean hasNextPage(ListFaqsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFaqsResponse nextPage(ListFaqsResponse previousPage) {
            if (previousPage == null) {
                return ListFaqsIterable.this.client.listFaqs(ListFaqsIterable.this.firstRequest);
            }
            return ListFaqsIterable.this.client.listFaqs((ListFaqsRequest)((Object)ListFaqsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

