/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConditionOperator {
    GREATER_THAN("GreaterThan"),
    GREATER_THAN_OR_EQUALS("GreaterThanOrEquals"),
    LESS_THAN("LessThan"),
    LESS_THAN_OR_EQUALS("LessThanOrEquals"),
    EQUALS("Equals"),
    NOT_EQUALS("NotEquals"),
    CONTAINS("Contains"),
    NOT_CONTAINS("NotContains"),
    EXISTS("Exists"),
    NOT_EXISTS("NotExists"),
    BEGINS_WITH("BeginsWith"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConditionOperator> VALUE_MAP;
    private final String value;

    private ConditionOperator(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConditionOperator fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConditionOperator> knownValues() {
        EnumSet<ConditionOperator> knownValues = EnumSet.allOf(ConditionOperator.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConditionOperator.class, ConditionOperator::toString);
    }
}

