/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kendra.KendraAsyncClient;
import software.amazon.awssdk.services.kendra.model.ListFaqsRequest;
import software.amazon.awssdk.services.kendra.model.ListFaqsResponse;

public class ListFaqsPublisher
implements SdkPublisher<ListFaqsResponse> {
    private final KendraAsyncClient client;
    private final ListFaqsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFaqsPublisher(KendraAsyncClient client, ListFaqsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFaqsPublisher(KendraAsyncClient client, ListFaqsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFaqsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFaqsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListFaqsResponseFetcher
    implements AsyncPageFetcher<ListFaqsResponse> {
        private ListFaqsResponseFetcher() {
        }

        public boolean hasNextPage(ListFaqsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFaqsResponse> nextPage(ListFaqsResponse previousPage) {
            if (previousPage == null) {
                return ListFaqsPublisher.this.client.listFaqs(ListFaqsPublisher.this.firstRequest);
            }
            return ListFaqsPublisher.this.client.listFaqs((ListFaqsRequest)((Object)ListFaqsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

