/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kendra.model.KendraRequest;
import software.amazon.awssdk.services.kendra.model.Mode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateQuerySuggestionsConfigRequest
extends KendraRequest
implements ToCopyableBuilder<Builder, UpdateQuerySuggestionsConfigRequest> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexId").getter(UpdateQuerySuggestionsConfigRequest.getter(UpdateQuerySuggestionsConfigRequest::indexId)).setter(UpdateQuerySuggestionsConfigRequest.setter(Builder::indexId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(UpdateQuerySuggestionsConfigRequest.getter(UpdateQuerySuggestionsConfigRequest::modeAsString)).setter(UpdateQuerySuggestionsConfigRequest.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final SdkField<Integer> QUERY_LOG_LOOK_BACK_WINDOW_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("QueryLogLookBackWindowInDays").getter(UpdateQuerySuggestionsConfigRequest.getter(UpdateQuerySuggestionsConfigRequest::queryLogLookBackWindowInDays)).setter(UpdateQuerySuggestionsConfigRequest.setter(Builder::queryLogLookBackWindowInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryLogLookBackWindowInDays").build()}).build();
    private static final SdkField<Boolean> INCLUDE_QUERIES_WITHOUT_USER_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeQueriesWithoutUserInformation").getter(UpdateQuerySuggestionsConfigRequest.getter(UpdateQuerySuggestionsConfigRequest::includeQueriesWithoutUserInformation)).setter(UpdateQuerySuggestionsConfigRequest.setter(Builder::includeQueriesWithoutUserInformation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeQueriesWithoutUserInformation").build()}).build();
    private static final SdkField<Integer> MINIMUM_NUMBER_OF_QUERYING_USERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinimumNumberOfQueryingUsers").getter(UpdateQuerySuggestionsConfigRequest.getter(UpdateQuerySuggestionsConfigRequest::minimumNumberOfQueryingUsers)).setter(UpdateQuerySuggestionsConfigRequest.setter(Builder::minimumNumberOfQueryingUsers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumNumberOfQueryingUsers").build()}).build();
    private static final SdkField<Integer> MINIMUM_QUERY_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinimumQueryCount").getter(UpdateQuerySuggestionsConfigRequest.getter(UpdateQuerySuggestionsConfigRequest::minimumQueryCount)).setter(UpdateQuerySuggestionsConfigRequest.setter(Builder::minimumQueryCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumQueryCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD, MODE_FIELD, QUERY_LOG_LOOK_BACK_WINDOW_IN_DAYS_FIELD, INCLUDE_QUERIES_WITHOUT_USER_INFORMATION_FIELD, MINIMUM_NUMBER_OF_QUERYING_USERS_FIELD, MINIMUM_QUERY_COUNT_FIELD));
    private final String indexId;
    private final String mode;
    private final Integer queryLogLookBackWindowInDays;
    private final Boolean includeQueriesWithoutUserInformation;
    private final Integer minimumNumberOfQueryingUsers;
    private final Integer minimumQueryCount;

    private UpdateQuerySuggestionsConfigRequest(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.mode = builder.mode;
        this.queryLogLookBackWindowInDays = builder.queryLogLookBackWindowInDays;
        this.includeQueriesWithoutUserInformation = builder.includeQueriesWithoutUserInformation;
        this.minimumNumberOfQueryingUsers = builder.minimumNumberOfQueryingUsers;
        this.minimumQueryCount = builder.minimumQueryCount;
    }

    public final String indexId() {
        return this.indexId;
    }

    public final Mode mode() {
        return Mode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final Integer queryLogLookBackWindowInDays() {
        return this.queryLogLookBackWindowInDays;
    }

    public final Boolean includeQueriesWithoutUserInformation() {
        return this.includeQueriesWithoutUserInformation;
    }

    public final Integer minimumNumberOfQueryingUsers() {
        return this.minimumNumberOfQueryingUsers;
    }

    public final Integer minimumQueryCount() {
        return this.minimumQueryCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.indexId());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryLogLookBackWindowInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeQueriesWithoutUserInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumNumberOfQueryingUsers());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumQueryCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateQuerySuggestionsConfigRequest)) {
            return false;
        }
        UpdateQuerySuggestionsConfigRequest other = (UpdateQuerySuggestionsConfigRequest)((Object)obj);
        return Objects.equals(this.indexId(), other.indexId()) && Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.queryLogLookBackWindowInDays(), other.queryLogLookBackWindowInDays()) && Objects.equals(this.includeQueriesWithoutUserInformation(), other.includeQueriesWithoutUserInformation()) && Objects.equals(this.minimumNumberOfQueryingUsers(), other.minimumNumberOfQueryingUsers()) && Objects.equals(this.minimumQueryCount(), other.minimumQueryCount());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateQuerySuggestionsConfigRequest").add("IndexId", (Object)this.indexId()).add("Mode", (Object)this.modeAsString()).add("QueryLogLookBackWindowInDays", (Object)this.queryLogLookBackWindowInDays()).add("IncludeQueriesWithoutUserInformation", (Object)this.includeQueriesWithoutUserInformation()).add("MinimumNumberOfQueryingUsers", (Object)this.minimumNumberOfQueryingUsers()).add("MinimumQueryCount", (Object)this.minimumQueryCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexId": {
                return Optional.ofNullable(clazz.cast(this.indexId()));
            }
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "QueryLogLookBackWindowInDays": {
                return Optional.ofNullable(clazz.cast(this.queryLogLookBackWindowInDays()));
            }
            case "IncludeQueriesWithoutUserInformation": {
                return Optional.ofNullable(clazz.cast(this.includeQueriesWithoutUserInformation()));
            }
            case "MinimumNumberOfQueryingUsers": {
                return Optional.ofNullable(clazz.cast(this.minimumNumberOfQueryingUsers()));
            }
            case "MinimumQueryCount": {
                return Optional.ofNullable(clazz.cast(this.minimumQueryCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateQuerySuggestionsConfigRequest, T> g) {
        return obj -> g.apply((UpdateQuerySuggestionsConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraRequest.BuilderImpl
    implements Builder {
        private String indexId;
        private String mode;
        private Integer queryLogLookBackWindowInDays;
        private Boolean includeQueriesWithoutUserInformation;
        private Integer minimumNumberOfQueryingUsers;
        private Integer minimumQueryCount;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateQuerySuggestionsConfigRequest model) {
            super(model);
            this.indexId(model.indexId);
            this.mode(model.mode);
            this.queryLogLookBackWindowInDays(model.queryLogLookBackWindowInDays);
            this.includeQueriesWithoutUserInformation(model.includeQueriesWithoutUserInformation);
            this.minimumNumberOfQueryingUsers(model.minimumNumberOfQueryingUsers);
            this.minimumQueryCount(model.minimumQueryCount);
        }

        public final String getIndexId() {
            return this.indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        public final String getMode() {
            return this.mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(Mode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        public final Integer getQueryLogLookBackWindowInDays() {
            return this.queryLogLookBackWindowInDays;
        }

        @Override
        public final Builder queryLogLookBackWindowInDays(Integer queryLogLookBackWindowInDays) {
            this.queryLogLookBackWindowInDays = queryLogLookBackWindowInDays;
            return this;
        }

        public final void setQueryLogLookBackWindowInDays(Integer queryLogLookBackWindowInDays) {
            this.queryLogLookBackWindowInDays = queryLogLookBackWindowInDays;
        }

        public final Boolean getIncludeQueriesWithoutUserInformation() {
            return this.includeQueriesWithoutUserInformation;
        }

        @Override
        public final Builder includeQueriesWithoutUserInformation(Boolean includeQueriesWithoutUserInformation) {
            this.includeQueriesWithoutUserInformation = includeQueriesWithoutUserInformation;
            return this;
        }

        public final void setIncludeQueriesWithoutUserInformation(Boolean includeQueriesWithoutUserInformation) {
            this.includeQueriesWithoutUserInformation = includeQueriesWithoutUserInformation;
        }

        public final Integer getMinimumNumberOfQueryingUsers() {
            return this.minimumNumberOfQueryingUsers;
        }

        @Override
        public final Builder minimumNumberOfQueryingUsers(Integer minimumNumberOfQueryingUsers) {
            this.minimumNumberOfQueryingUsers = minimumNumberOfQueryingUsers;
            return this;
        }

        public final void setMinimumNumberOfQueryingUsers(Integer minimumNumberOfQueryingUsers) {
            this.minimumNumberOfQueryingUsers = minimumNumberOfQueryingUsers;
        }

        public final Integer getMinimumQueryCount() {
            return this.minimumQueryCount;
        }

        @Override
        public final Builder minimumQueryCount(Integer minimumQueryCount) {
            this.minimumQueryCount = minimumQueryCount;
            return this;
        }

        public final void setMinimumQueryCount(Integer minimumQueryCount) {
            this.minimumQueryCount = minimumQueryCount;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateQuerySuggestionsConfigRequest build() {
            return new UpdateQuerySuggestionsConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KendraRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateQuerySuggestionsConfigRequest> {
        public Builder indexId(String var1);

        public Builder mode(String var1);

        public Builder mode(Mode var1);

        public Builder queryLogLookBackWindowInDays(Integer var1);

        public Builder includeQueriesWithoutUserInformation(Boolean var1);

        public Builder minimumNumberOfQueryingUsers(Integer var1);

        public Builder minimumQueryCount(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

