/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kendra.model.FaqStatistics;
import software.amazon.awssdk.services.kendra.model.TextDocumentStatistics;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IndexStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IndexStatistics> {
    private static final SdkField<FaqStatistics> FAQ_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FaqStatistics").getter(IndexStatistics.getter(IndexStatistics::faqStatistics)).setter(IndexStatistics.setter(Builder::faqStatistics)).constructor(FaqStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaqStatistics").build()}).build();
    private static final SdkField<TextDocumentStatistics> TEXT_DOCUMENT_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TextDocumentStatistics").getter(IndexStatistics.getter(IndexStatistics::textDocumentStatistics)).setter(IndexStatistics.setter(Builder::textDocumentStatistics)).constructor(TextDocumentStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextDocumentStatistics").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAQ_STATISTICS_FIELD, TEXT_DOCUMENT_STATISTICS_FIELD));
    private static final long serialVersionUID = 1L;
    private final FaqStatistics faqStatistics;
    private final TextDocumentStatistics textDocumentStatistics;

    private IndexStatistics(BuilderImpl builder) {
        this.faqStatistics = builder.faqStatistics;
        this.textDocumentStatistics = builder.textDocumentStatistics;
    }

    public final FaqStatistics faqStatistics() {
        return this.faqStatistics;
    }

    public final TextDocumentStatistics textDocumentStatistics() {
        return this.textDocumentStatistics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.faqStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.textDocumentStatistics());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexStatistics)) {
            return false;
        }
        IndexStatistics other = (IndexStatistics)obj;
        return Objects.equals(this.faqStatistics(), other.faqStatistics()) && Objects.equals(this.textDocumentStatistics(), other.textDocumentStatistics());
    }

    public final String toString() {
        return ToString.builder((String)"IndexStatistics").add("FaqStatistics", (Object)this.faqStatistics()).add("TextDocumentStatistics", (Object)this.textDocumentStatistics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FaqStatistics": {
                return Optional.ofNullable(clazz.cast(this.faqStatistics()));
            }
            case "TextDocumentStatistics": {
                return Optional.ofNullable(clazz.cast(this.textDocumentStatistics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IndexStatistics, T> g) {
        return obj -> g.apply((IndexStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FaqStatistics faqStatistics;
        private TextDocumentStatistics textDocumentStatistics;

        private BuilderImpl() {
        }

        private BuilderImpl(IndexStatistics model) {
            this.faqStatistics(model.faqStatistics);
            this.textDocumentStatistics(model.textDocumentStatistics);
        }

        public final FaqStatistics.Builder getFaqStatistics() {
            return this.faqStatistics != null ? this.faqStatistics.toBuilder() : null;
        }

        public final void setFaqStatistics(FaqStatistics.BuilderImpl faqStatistics) {
            this.faqStatistics = faqStatistics != null ? faqStatistics.build() : null;
        }

        @Override
        @Transient
        public final Builder faqStatistics(FaqStatistics faqStatistics) {
            this.faqStatistics = faqStatistics;
            return this;
        }

        public final TextDocumentStatistics.Builder getTextDocumentStatistics() {
            return this.textDocumentStatistics != null ? this.textDocumentStatistics.toBuilder() : null;
        }

        public final void setTextDocumentStatistics(TextDocumentStatistics.BuilderImpl textDocumentStatistics) {
            this.textDocumentStatistics = textDocumentStatistics != null ? textDocumentStatistics.build() : null;
        }

        @Override
        @Transient
        public final Builder textDocumentStatistics(TextDocumentStatistics textDocumentStatistics) {
            this.textDocumentStatistics = textDocumentStatistics;
            return this;
        }

        public IndexStatistics build() {
            return new IndexStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IndexStatistics> {
        public Builder faqStatistics(FaqStatistics var1);

        default public Builder faqStatistics(Consumer<FaqStatistics.Builder> faqStatistics) {
            return this.faqStatistics((FaqStatistics)((FaqStatistics.Builder)FaqStatistics.builder().applyMutation(faqStatistics)).build());
        }

        public Builder textDocumentStatistics(TextDocumentStatistics var1);

        default public Builder textDocumentStatistics(Consumer<TextDocumentStatistics.Builder> textDocumentStatistics) {
            return this.textDocumentStatistics((TextDocumentStatistics)((TextDocumentStatistics.Builder)TextDocumentStatistics.builder().applyMutation(textDocumentStatistics)).build());
        }
    }
}

