/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kendra.model.KendraResponse;
import software.amazon.awssdk.services.kendra.model.QuerySuggestionsBlockListStatus;
import software.amazon.awssdk.services.kendra.model.S3Path;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeQuerySuggestionsBlockListResponse
extends KendraResponse
implements ToCopyableBuilder<Builder, DescribeQuerySuggestionsBlockListResponse> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexId").getter(DescribeQuerySuggestionsBlockListResponse.getter(DescribeQuerySuggestionsBlockListResponse::indexId)).setter(DescribeQuerySuggestionsBlockListResponse.setter(Builder::indexId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(DescribeQuerySuggestionsBlockListResponse.getter(DescribeQuerySuggestionsBlockListResponse::id)).setter(DescribeQuerySuggestionsBlockListResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeQuerySuggestionsBlockListResponse.getter(DescribeQuerySuggestionsBlockListResponse::name)).setter(DescribeQuerySuggestionsBlockListResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeQuerySuggestionsBlockListResponse.getter(DescribeQuerySuggestionsBlockListResponse::description)).setter(DescribeQuerySuggestionsBlockListResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeQuerySuggestionsBlockListResponse.getter(DescribeQuerySuggestionsBlockListResponse::statusAsString)).setter(DescribeQuerySuggestionsBlockListResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(DescribeQuerySuggestionsBlockListResponse.getter(DescribeQuerySuggestionsBlockListResponse::errorMessage)).setter(DescribeQuerySuggestionsBlockListResponse.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(DescribeQuerySuggestionsBlockListResponse.getter(DescribeQuerySuggestionsBlockListResponse::createdAt)).setter(DescribeQuerySuggestionsBlockListResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(DescribeQuerySuggestionsBlockListResponse.getter(DescribeQuerySuggestionsBlockListResponse::updatedAt)).setter(DescribeQuerySuggestionsBlockListResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final SdkField<S3Path> SOURCE_S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceS3Path").getter(DescribeQuerySuggestionsBlockListResponse.getter(DescribeQuerySuggestionsBlockListResponse::sourceS3Path)).setter(DescribeQuerySuggestionsBlockListResponse.setter(Builder::sourceS3Path)).constructor(S3Path::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceS3Path").build()}).build();
    private static final SdkField<Integer> ITEM_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ItemCount").getter(DescribeQuerySuggestionsBlockListResponse.getter(DescribeQuerySuggestionsBlockListResponse::itemCount)).setter(DescribeQuerySuggestionsBlockListResponse.setter(Builder::itemCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemCount").build()}).build();
    private static final SdkField<Long> FILE_SIZE_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("FileSizeBytes").getter(DescribeQuerySuggestionsBlockListResponse.getter(DescribeQuerySuggestionsBlockListResponse::fileSizeBytes)).setter(DescribeQuerySuggestionsBlockListResponse.setter(Builder::fileSizeBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSizeBytes").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(DescribeQuerySuggestionsBlockListResponse.getter(DescribeQuerySuggestionsBlockListResponse::roleArn)).setter(DescribeQuerySuggestionsBlockListResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD, ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, ERROR_MESSAGE_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, SOURCE_S3_PATH_FIELD, ITEM_COUNT_FIELD, FILE_SIZE_BYTES_FIELD, ROLE_ARN_FIELD));
    private final String indexId;
    private final String id;
    private final String name;
    private final String description;
    private final String status;
    private final String errorMessage;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final S3Path sourceS3Path;
    private final Integer itemCount;
    private final Long fileSizeBytes;
    private final String roleArn;

    private DescribeQuerySuggestionsBlockListResponse(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.status = builder.status;
        this.errorMessage = builder.errorMessage;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.sourceS3Path = builder.sourceS3Path;
        this.itemCount = builder.itemCount;
        this.fileSizeBytes = builder.fileSizeBytes;
        this.roleArn = builder.roleArn;
    }

    public final String indexId() {
        return this.indexId;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final QuerySuggestionsBlockListStatus status() {
        return QuerySuggestionsBlockListStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final S3Path sourceS3Path() {
        return this.sourceS3Path;
    }

    public final Integer itemCount() {
        return this.itemCount;
    }

    public final Long fileSizeBytes() {
        return this.fileSizeBytes;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.indexId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.itemCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeQuerySuggestionsBlockListResponse)) {
            return false;
        }
        DescribeQuerySuggestionsBlockListResponse other = (DescribeQuerySuggestionsBlockListResponse)((Object)obj);
        return Objects.equals(this.indexId(), other.indexId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.sourceS3Path(), other.sourceS3Path()) && Objects.equals(this.itemCount(), other.itemCount()) && Objects.equals(this.fileSizeBytes(), other.fileSizeBytes()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeQuerySuggestionsBlockListResponse").add("IndexId", (Object)this.indexId()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Status", (Object)this.statusAsString()).add("ErrorMessage", (Object)this.errorMessage()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("SourceS3Path", (Object)this.sourceS3Path()).add("ItemCount", (Object)this.itemCount()).add("FileSizeBytes", (Object)this.fileSizeBytes()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexId": {
                return Optional.ofNullable(clazz.cast(this.indexId()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "SourceS3Path": {
                return Optional.ofNullable(clazz.cast(this.sourceS3Path()));
            }
            case "ItemCount": {
                return Optional.ofNullable(clazz.cast(this.itemCount()));
            }
            case "FileSizeBytes": {
                return Optional.ofNullable(clazz.cast(this.fileSizeBytes()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeQuerySuggestionsBlockListResponse, T> g) {
        return obj -> g.apply((DescribeQuerySuggestionsBlockListResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraResponse.BuilderImpl
    implements Builder {
        private String indexId;
        private String id;
        private String name;
        private String description;
        private String status;
        private String errorMessage;
        private Instant createdAt;
        private Instant updatedAt;
        private S3Path sourceS3Path;
        private Integer itemCount;
        private Long fileSizeBytes;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeQuerySuggestionsBlockListResponse model) {
            super(model);
            this.indexId(model.indexId);
            this.id(model.id);
            this.name(model.name);
            this.description(model.description);
            this.status(model.status);
            this.errorMessage(model.errorMessage);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.sourceS3Path(model.sourceS3Path);
            this.itemCount(model.itemCount);
            this.fileSizeBytes(model.fileSizeBytes);
            this.roleArn(model.roleArn);
        }

        public final String getIndexId() {
            return this.indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        @Transient
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(QuerySuggestionsBlockListStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        @Transient
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        @Transient
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final S3Path.Builder getSourceS3Path() {
            return this.sourceS3Path != null ? this.sourceS3Path.toBuilder() : null;
        }

        public final void setSourceS3Path(S3Path.BuilderImpl sourceS3Path) {
            this.sourceS3Path = sourceS3Path != null ? sourceS3Path.build() : null;
        }

        @Override
        @Transient
        public final Builder sourceS3Path(S3Path sourceS3Path) {
            this.sourceS3Path = sourceS3Path;
            return this;
        }

        public final Integer getItemCount() {
            return this.itemCount;
        }

        public final void setItemCount(Integer itemCount) {
            this.itemCount = itemCount;
        }

        @Override
        @Transient
        public final Builder itemCount(Integer itemCount) {
            this.itemCount = itemCount;
            return this;
        }

        public final Long getFileSizeBytes() {
            return this.fileSizeBytes;
        }

        public final void setFileSizeBytes(Long fileSizeBytes) {
            this.fileSizeBytes = fileSizeBytes;
        }

        @Override
        @Transient
        public final Builder fileSizeBytes(Long fileSizeBytes) {
            this.fileSizeBytes = fileSizeBytes;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public DescribeQuerySuggestionsBlockListResponse build() {
            return new DescribeQuerySuggestionsBlockListResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KendraResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeQuerySuggestionsBlockListResponse> {
        public Builder indexId(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(QuerySuggestionsBlockListStatus var1);

        public Builder errorMessage(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder sourceS3Path(S3Path var1);

        default public Builder sourceS3Path(Consumer<S3Path.Builder> sourceS3Path) {
            return this.sourceS3Path((S3Path)((S3Path.Builder)S3Path.builder().applyMutation(sourceS3Path)).build());
        }

        public Builder itemCount(Integer var1);

        public Builder fileSizeBytes(Long var1);

        public Builder roleArn(String var1);
    }
}

