/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kendra.KendraAsyncClient;
import software.amazon.awssdk.services.kendra.model.ListExperiencesRequest;
import software.amazon.awssdk.services.kendra.model.ListExperiencesResponse;

public class ListExperiencesPublisher
implements SdkPublisher<ListExperiencesResponse> {
    private final KendraAsyncClient client;
    private final ListExperiencesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListExperiencesPublisher(KendraAsyncClient client, ListExperiencesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListExperiencesPublisher(KendraAsyncClient client, ListExperiencesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListExperiencesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListExperiencesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListExperiencesResponseFetcher
    implements AsyncPageFetcher<ListExperiencesResponse> {
        private ListExperiencesResponseFetcher() {
        }

        public boolean hasNextPage(ListExperiencesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListExperiencesResponse> nextPage(ListExperiencesResponse previousPage) {
            if (previousPage == null) {
                return ListExperiencesPublisher.this.client.listExperiences(ListExperiencesPublisher.this.firstRequest);
            }
            return ListExperiencesPublisher.this.client.listExperiences((ListExperiencesRequest)((Object)ListExperiencesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

