/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kendra.model.ConfluenceConfiguration;
import software.amazon.awssdk.services.kendra.model.DatabaseConfiguration;
import software.amazon.awssdk.services.kendra.model.FsxConfiguration;
import software.amazon.awssdk.services.kendra.model.GoogleDriveConfiguration;
import software.amazon.awssdk.services.kendra.model.OneDriveConfiguration;
import software.amazon.awssdk.services.kendra.model.S3DataSourceConfiguration;
import software.amazon.awssdk.services.kendra.model.SalesforceConfiguration;
import software.amazon.awssdk.services.kendra.model.ServiceNowConfiguration;
import software.amazon.awssdk.services.kendra.model.SharePointConfiguration;
import software.amazon.awssdk.services.kendra.model.SlackConfiguration;
import software.amazon.awssdk.services.kendra.model.WebCrawlerConfiguration;
import software.amazon.awssdk.services.kendra.model.WorkDocsConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSourceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSourceConfiguration> {
    private static final SdkField<S3DataSourceConfiguration> S3_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Configuration").getter(DataSourceConfiguration.getter(DataSourceConfiguration::s3Configuration)).setter(DataSourceConfiguration.setter(Builder::s3Configuration)).constructor(S3DataSourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Configuration").build()}).build();
    private static final SdkField<SharePointConfiguration> SHARE_POINT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SharePointConfiguration").getter(DataSourceConfiguration.getter(DataSourceConfiguration::sharePointConfiguration)).setter(DataSourceConfiguration.setter(Builder::sharePointConfiguration)).constructor(SharePointConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharePointConfiguration").build()}).build();
    private static final SdkField<DatabaseConfiguration> DATABASE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DatabaseConfiguration").getter(DataSourceConfiguration.getter(DataSourceConfiguration::databaseConfiguration)).setter(DataSourceConfiguration.setter(Builder::databaseConfiguration)).constructor(DatabaseConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseConfiguration").build()}).build();
    private static final SdkField<SalesforceConfiguration> SALESFORCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SalesforceConfiguration").getter(DataSourceConfiguration.getter(DataSourceConfiguration::salesforceConfiguration)).setter(DataSourceConfiguration.setter(Builder::salesforceConfiguration)).constructor(SalesforceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SalesforceConfiguration").build()}).build();
    private static final SdkField<OneDriveConfiguration> ONE_DRIVE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OneDriveConfiguration").getter(DataSourceConfiguration.getter(DataSourceConfiguration::oneDriveConfiguration)).setter(DataSourceConfiguration.setter(Builder::oneDriveConfiguration)).constructor(OneDriveConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OneDriveConfiguration").build()}).build();
    private static final SdkField<ServiceNowConfiguration> SERVICE_NOW_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServiceNowConfiguration").getter(DataSourceConfiguration.getter(DataSourceConfiguration::serviceNowConfiguration)).setter(DataSourceConfiguration.setter(Builder::serviceNowConfiguration)).constructor(ServiceNowConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNowConfiguration").build()}).build();
    private static final SdkField<ConfluenceConfiguration> CONFLUENCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConfluenceConfiguration").getter(DataSourceConfiguration.getter(DataSourceConfiguration::confluenceConfiguration)).setter(DataSourceConfiguration.setter(Builder::confluenceConfiguration)).constructor(ConfluenceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfluenceConfiguration").build()}).build();
    private static final SdkField<GoogleDriveConfiguration> GOOGLE_DRIVE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GoogleDriveConfiguration").getter(DataSourceConfiguration.getter(DataSourceConfiguration::googleDriveConfiguration)).setter(DataSourceConfiguration.setter(Builder::googleDriveConfiguration)).constructor(GoogleDriveConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GoogleDriveConfiguration").build()}).build();
    private static final SdkField<WebCrawlerConfiguration> WEB_CRAWLER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WebCrawlerConfiguration").getter(DataSourceConfiguration.getter(DataSourceConfiguration::webCrawlerConfiguration)).setter(DataSourceConfiguration.setter(Builder::webCrawlerConfiguration)).constructor(WebCrawlerConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebCrawlerConfiguration").build()}).build();
    private static final SdkField<WorkDocsConfiguration> WORK_DOCS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WorkDocsConfiguration").getter(DataSourceConfiguration.getter(DataSourceConfiguration::workDocsConfiguration)).setter(DataSourceConfiguration.setter(Builder::workDocsConfiguration)).constructor(WorkDocsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkDocsConfiguration").build()}).build();
    private static final SdkField<FsxConfiguration> FSX_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FsxConfiguration").getter(DataSourceConfiguration.getter(DataSourceConfiguration::fsxConfiguration)).setter(DataSourceConfiguration.setter(Builder::fsxConfiguration)).constructor(FsxConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FsxConfiguration").build()}).build();
    private static final SdkField<SlackConfiguration> SLACK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SlackConfiguration").getter(DataSourceConfiguration.getter(DataSourceConfiguration::slackConfiguration)).setter(DataSourceConfiguration.setter(Builder::slackConfiguration)).constructor(SlackConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlackConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_CONFIGURATION_FIELD, SHARE_POINT_CONFIGURATION_FIELD, DATABASE_CONFIGURATION_FIELD, SALESFORCE_CONFIGURATION_FIELD, ONE_DRIVE_CONFIGURATION_FIELD, SERVICE_NOW_CONFIGURATION_FIELD, CONFLUENCE_CONFIGURATION_FIELD, GOOGLE_DRIVE_CONFIGURATION_FIELD, WEB_CRAWLER_CONFIGURATION_FIELD, WORK_DOCS_CONFIGURATION_FIELD, FSX_CONFIGURATION_FIELD, SLACK_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final S3DataSourceConfiguration s3Configuration;
    private final SharePointConfiguration sharePointConfiguration;
    private final DatabaseConfiguration databaseConfiguration;
    private final SalesforceConfiguration salesforceConfiguration;
    private final OneDriveConfiguration oneDriveConfiguration;
    private final ServiceNowConfiguration serviceNowConfiguration;
    private final ConfluenceConfiguration confluenceConfiguration;
    private final GoogleDriveConfiguration googleDriveConfiguration;
    private final WebCrawlerConfiguration webCrawlerConfiguration;
    private final WorkDocsConfiguration workDocsConfiguration;
    private final FsxConfiguration fsxConfiguration;
    private final SlackConfiguration slackConfiguration;

    private DataSourceConfiguration(BuilderImpl builder) {
        this.s3Configuration = builder.s3Configuration;
        this.sharePointConfiguration = builder.sharePointConfiguration;
        this.databaseConfiguration = builder.databaseConfiguration;
        this.salesforceConfiguration = builder.salesforceConfiguration;
        this.oneDriveConfiguration = builder.oneDriveConfiguration;
        this.serviceNowConfiguration = builder.serviceNowConfiguration;
        this.confluenceConfiguration = builder.confluenceConfiguration;
        this.googleDriveConfiguration = builder.googleDriveConfiguration;
        this.webCrawlerConfiguration = builder.webCrawlerConfiguration;
        this.workDocsConfiguration = builder.workDocsConfiguration;
        this.fsxConfiguration = builder.fsxConfiguration;
        this.slackConfiguration = builder.slackConfiguration;
    }

    public final S3DataSourceConfiguration s3Configuration() {
        return this.s3Configuration;
    }

    public final SharePointConfiguration sharePointConfiguration() {
        return this.sharePointConfiguration;
    }

    public final DatabaseConfiguration databaseConfiguration() {
        return this.databaseConfiguration;
    }

    public final SalesforceConfiguration salesforceConfiguration() {
        return this.salesforceConfiguration;
    }

    public final OneDriveConfiguration oneDriveConfiguration() {
        return this.oneDriveConfiguration;
    }

    public final ServiceNowConfiguration serviceNowConfiguration() {
        return this.serviceNowConfiguration;
    }

    public final ConfluenceConfiguration confluenceConfiguration() {
        return this.confluenceConfiguration;
    }

    public final GoogleDriveConfiguration googleDriveConfiguration() {
        return this.googleDriveConfiguration;
    }

    public final WebCrawlerConfiguration webCrawlerConfiguration() {
        return this.webCrawlerConfiguration;
    }

    public final WorkDocsConfiguration workDocsConfiguration() {
        return this.workDocsConfiguration;
    }

    public final FsxConfiguration fsxConfiguration() {
        return this.fsxConfiguration;
    }

    public final SlackConfiguration slackConfiguration() {
        return this.slackConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.sharePointConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.salesforceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.oneDriveConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNowConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.confluenceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.googleDriveConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.webCrawlerConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.workDocsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.fsxConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.slackConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceConfiguration)) {
            return false;
        }
        DataSourceConfiguration other = (DataSourceConfiguration)obj;
        return Objects.equals(this.s3Configuration(), other.s3Configuration()) && Objects.equals(this.sharePointConfiguration(), other.sharePointConfiguration()) && Objects.equals(this.databaseConfiguration(), other.databaseConfiguration()) && Objects.equals(this.salesforceConfiguration(), other.salesforceConfiguration()) && Objects.equals(this.oneDriveConfiguration(), other.oneDriveConfiguration()) && Objects.equals(this.serviceNowConfiguration(), other.serviceNowConfiguration()) && Objects.equals(this.confluenceConfiguration(), other.confluenceConfiguration()) && Objects.equals(this.googleDriveConfiguration(), other.googleDriveConfiguration()) && Objects.equals(this.webCrawlerConfiguration(), other.webCrawlerConfiguration()) && Objects.equals(this.workDocsConfiguration(), other.workDocsConfiguration()) && Objects.equals(this.fsxConfiguration(), other.fsxConfiguration()) && Objects.equals(this.slackConfiguration(), other.slackConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"DataSourceConfiguration").add("S3Configuration", (Object)this.s3Configuration()).add("SharePointConfiguration", (Object)this.sharePointConfiguration()).add("DatabaseConfiguration", (Object)this.databaseConfiguration()).add("SalesforceConfiguration", (Object)this.salesforceConfiguration()).add("OneDriveConfiguration", (Object)this.oneDriveConfiguration()).add("ServiceNowConfiguration", (Object)this.serviceNowConfiguration()).add("ConfluenceConfiguration", (Object)this.confluenceConfiguration()).add("GoogleDriveConfiguration", (Object)this.googleDriveConfiguration()).add("WebCrawlerConfiguration", (Object)this.webCrawlerConfiguration()).add("WorkDocsConfiguration", (Object)this.workDocsConfiguration()).add("FsxConfiguration", (Object)this.fsxConfiguration()).add("SlackConfiguration", (Object)this.slackConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3Configuration": {
                return Optional.ofNullable(clazz.cast(this.s3Configuration()));
            }
            case "SharePointConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sharePointConfiguration()));
            }
            case "DatabaseConfiguration": {
                return Optional.ofNullable(clazz.cast(this.databaseConfiguration()));
            }
            case "SalesforceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.salesforceConfiguration()));
            }
            case "OneDriveConfiguration": {
                return Optional.ofNullable(clazz.cast(this.oneDriveConfiguration()));
            }
            case "ServiceNowConfiguration": {
                return Optional.ofNullable(clazz.cast(this.serviceNowConfiguration()));
            }
            case "ConfluenceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.confluenceConfiguration()));
            }
            case "GoogleDriveConfiguration": {
                return Optional.ofNullable(clazz.cast(this.googleDriveConfiguration()));
            }
            case "WebCrawlerConfiguration": {
                return Optional.ofNullable(clazz.cast(this.webCrawlerConfiguration()));
            }
            case "WorkDocsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.workDocsConfiguration()));
            }
            case "FsxConfiguration": {
                return Optional.ofNullable(clazz.cast(this.fsxConfiguration()));
            }
            case "SlackConfiguration": {
                return Optional.ofNullable(clazz.cast(this.slackConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSourceConfiguration, T> g) {
        return obj -> g.apply((DataSourceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private S3DataSourceConfiguration s3Configuration;
        private SharePointConfiguration sharePointConfiguration;
        private DatabaseConfiguration databaseConfiguration;
        private SalesforceConfiguration salesforceConfiguration;
        private OneDriveConfiguration oneDriveConfiguration;
        private ServiceNowConfiguration serviceNowConfiguration;
        private ConfluenceConfiguration confluenceConfiguration;
        private GoogleDriveConfiguration googleDriveConfiguration;
        private WebCrawlerConfiguration webCrawlerConfiguration;
        private WorkDocsConfiguration workDocsConfiguration;
        private FsxConfiguration fsxConfiguration;
        private SlackConfiguration slackConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceConfiguration model) {
            this.s3Configuration(model.s3Configuration);
            this.sharePointConfiguration(model.sharePointConfiguration);
            this.databaseConfiguration(model.databaseConfiguration);
            this.salesforceConfiguration(model.salesforceConfiguration);
            this.oneDriveConfiguration(model.oneDriveConfiguration);
            this.serviceNowConfiguration(model.serviceNowConfiguration);
            this.confluenceConfiguration(model.confluenceConfiguration);
            this.googleDriveConfiguration(model.googleDriveConfiguration);
            this.webCrawlerConfiguration(model.webCrawlerConfiguration);
            this.workDocsConfiguration(model.workDocsConfiguration);
            this.fsxConfiguration(model.fsxConfiguration);
            this.slackConfiguration(model.slackConfiguration);
        }

        public final S3DataSourceConfiguration.Builder getS3Configuration() {
            return this.s3Configuration != null ? this.s3Configuration.toBuilder() : null;
        }

        public final void setS3Configuration(S3DataSourceConfiguration.BuilderImpl s3Configuration) {
            this.s3Configuration = s3Configuration != null ? s3Configuration.build() : null;
        }

        @Override
        @Transient
        public final Builder s3Configuration(S3DataSourceConfiguration s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        public final SharePointConfiguration.Builder getSharePointConfiguration() {
            return this.sharePointConfiguration != null ? this.sharePointConfiguration.toBuilder() : null;
        }

        public final void setSharePointConfiguration(SharePointConfiguration.BuilderImpl sharePointConfiguration) {
            this.sharePointConfiguration = sharePointConfiguration != null ? sharePointConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder sharePointConfiguration(SharePointConfiguration sharePointConfiguration) {
            this.sharePointConfiguration = sharePointConfiguration;
            return this;
        }

        public final DatabaseConfiguration.Builder getDatabaseConfiguration() {
            return this.databaseConfiguration != null ? this.databaseConfiguration.toBuilder() : null;
        }

        public final void setDatabaseConfiguration(DatabaseConfiguration.BuilderImpl databaseConfiguration) {
            this.databaseConfiguration = databaseConfiguration != null ? databaseConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder databaseConfiguration(DatabaseConfiguration databaseConfiguration) {
            this.databaseConfiguration = databaseConfiguration;
            return this;
        }

        public final SalesforceConfiguration.Builder getSalesforceConfiguration() {
            return this.salesforceConfiguration != null ? this.salesforceConfiguration.toBuilder() : null;
        }

        public final void setSalesforceConfiguration(SalesforceConfiguration.BuilderImpl salesforceConfiguration) {
            this.salesforceConfiguration = salesforceConfiguration != null ? salesforceConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder salesforceConfiguration(SalesforceConfiguration salesforceConfiguration) {
            this.salesforceConfiguration = salesforceConfiguration;
            return this;
        }

        public final OneDriveConfiguration.Builder getOneDriveConfiguration() {
            return this.oneDriveConfiguration != null ? this.oneDriveConfiguration.toBuilder() : null;
        }

        public final void setOneDriveConfiguration(OneDriveConfiguration.BuilderImpl oneDriveConfiguration) {
            this.oneDriveConfiguration = oneDriveConfiguration != null ? oneDriveConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder oneDriveConfiguration(OneDriveConfiguration oneDriveConfiguration) {
            this.oneDriveConfiguration = oneDriveConfiguration;
            return this;
        }

        public final ServiceNowConfiguration.Builder getServiceNowConfiguration() {
            return this.serviceNowConfiguration != null ? this.serviceNowConfiguration.toBuilder() : null;
        }

        public final void setServiceNowConfiguration(ServiceNowConfiguration.BuilderImpl serviceNowConfiguration) {
            this.serviceNowConfiguration = serviceNowConfiguration != null ? serviceNowConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder serviceNowConfiguration(ServiceNowConfiguration serviceNowConfiguration) {
            this.serviceNowConfiguration = serviceNowConfiguration;
            return this;
        }

        public final ConfluenceConfiguration.Builder getConfluenceConfiguration() {
            return this.confluenceConfiguration != null ? this.confluenceConfiguration.toBuilder() : null;
        }

        public final void setConfluenceConfiguration(ConfluenceConfiguration.BuilderImpl confluenceConfiguration) {
            this.confluenceConfiguration = confluenceConfiguration != null ? confluenceConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder confluenceConfiguration(ConfluenceConfiguration confluenceConfiguration) {
            this.confluenceConfiguration = confluenceConfiguration;
            return this;
        }

        public final GoogleDriveConfiguration.Builder getGoogleDriveConfiguration() {
            return this.googleDriveConfiguration != null ? this.googleDriveConfiguration.toBuilder() : null;
        }

        public final void setGoogleDriveConfiguration(GoogleDriveConfiguration.BuilderImpl googleDriveConfiguration) {
            this.googleDriveConfiguration = googleDriveConfiguration != null ? googleDriveConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder googleDriveConfiguration(GoogleDriveConfiguration googleDriveConfiguration) {
            this.googleDriveConfiguration = googleDriveConfiguration;
            return this;
        }

        public final WebCrawlerConfiguration.Builder getWebCrawlerConfiguration() {
            return this.webCrawlerConfiguration != null ? this.webCrawlerConfiguration.toBuilder() : null;
        }

        public final void setWebCrawlerConfiguration(WebCrawlerConfiguration.BuilderImpl webCrawlerConfiguration) {
            this.webCrawlerConfiguration = webCrawlerConfiguration != null ? webCrawlerConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder webCrawlerConfiguration(WebCrawlerConfiguration webCrawlerConfiguration) {
            this.webCrawlerConfiguration = webCrawlerConfiguration;
            return this;
        }

        public final WorkDocsConfiguration.Builder getWorkDocsConfiguration() {
            return this.workDocsConfiguration != null ? this.workDocsConfiguration.toBuilder() : null;
        }

        public final void setWorkDocsConfiguration(WorkDocsConfiguration.BuilderImpl workDocsConfiguration) {
            this.workDocsConfiguration = workDocsConfiguration != null ? workDocsConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder workDocsConfiguration(WorkDocsConfiguration workDocsConfiguration) {
            this.workDocsConfiguration = workDocsConfiguration;
            return this;
        }

        public final FsxConfiguration.Builder getFsxConfiguration() {
            return this.fsxConfiguration != null ? this.fsxConfiguration.toBuilder() : null;
        }

        public final void setFsxConfiguration(FsxConfiguration.BuilderImpl fsxConfiguration) {
            this.fsxConfiguration = fsxConfiguration != null ? fsxConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder fsxConfiguration(FsxConfiguration fsxConfiguration) {
            this.fsxConfiguration = fsxConfiguration;
            return this;
        }

        public final SlackConfiguration.Builder getSlackConfiguration() {
            return this.slackConfiguration != null ? this.slackConfiguration.toBuilder() : null;
        }

        public final void setSlackConfiguration(SlackConfiguration.BuilderImpl slackConfiguration) {
            this.slackConfiguration = slackConfiguration != null ? slackConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder slackConfiguration(SlackConfiguration slackConfiguration) {
            this.slackConfiguration = slackConfiguration;
            return this;
        }

        public DataSourceConfiguration build() {
            return new DataSourceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSourceConfiguration> {
        public Builder s3Configuration(S3DataSourceConfiguration var1);

        default public Builder s3Configuration(Consumer<S3DataSourceConfiguration.Builder> s3Configuration) {
            return this.s3Configuration((S3DataSourceConfiguration)((S3DataSourceConfiguration.Builder)S3DataSourceConfiguration.builder().applyMutation(s3Configuration)).build());
        }

        public Builder sharePointConfiguration(SharePointConfiguration var1);

        default public Builder sharePointConfiguration(Consumer<SharePointConfiguration.Builder> sharePointConfiguration) {
            return this.sharePointConfiguration((SharePointConfiguration)((SharePointConfiguration.Builder)SharePointConfiguration.builder().applyMutation(sharePointConfiguration)).build());
        }

        public Builder databaseConfiguration(DatabaseConfiguration var1);

        default public Builder databaseConfiguration(Consumer<DatabaseConfiguration.Builder> databaseConfiguration) {
            return this.databaseConfiguration((DatabaseConfiguration)((DatabaseConfiguration.Builder)DatabaseConfiguration.builder().applyMutation(databaseConfiguration)).build());
        }

        public Builder salesforceConfiguration(SalesforceConfiguration var1);

        default public Builder salesforceConfiguration(Consumer<SalesforceConfiguration.Builder> salesforceConfiguration) {
            return this.salesforceConfiguration((SalesforceConfiguration)((SalesforceConfiguration.Builder)SalesforceConfiguration.builder().applyMutation(salesforceConfiguration)).build());
        }

        public Builder oneDriveConfiguration(OneDriveConfiguration var1);

        default public Builder oneDriveConfiguration(Consumer<OneDriveConfiguration.Builder> oneDriveConfiguration) {
            return this.oneDriveConfiguration((OneDriveConfiguration)((OneDriveConfiguration.Builder)OneDriveConfiguration.builder().applyMutation(oneDriveConfiguration)).build());
        }

        public Builder serviceNowConfiguration(ServiceNowConfiguration var1);

        default public Builder serviceNowConfiguration(Consumer<ServiceNowConfiguration.Builder> serviceNowConfiguration) {
            return this.serviceNowConfiguration((ServiceNowConfiguration)((ServiceNowConfiguration.Builder)ServiceNowConfiguration.builder().applyMutation(serviceNowConfiguration)).build());
        }

        public Builder confluenceConfiguration(ConfluenceConfiguration var1);

        default public Builder confluenceConfiguration(Consumer<ConfluenceConfiguration.Builder> confluenceConfiguration) {
            return this.confluenceConfiguration((ConfluenceConfiguration)((ConfluenceConfiguration.Builder)ConfluenceConfiguration.builder().applyMutation(confluenceConfiguration)).build());
        }

        public Builder googleDriveConfiguration(GoogleDriveConfiguration var1);

        default public Builder googleDriveConfiguration(Consumer<GoogleDriveConfiguration.Builder> googleDriveConfiguration) {
            return this.googleDriveConfiguration((GoogleDriveConfiguration)((GoogleDriveConfiguration.Builder)GoogleDriveConfiguration.builder().applyMutation(googleDriveConfiguration)).build());
        }

        public Builder webCrawlerConfiguration(WebCrawlerConfiguration var1);

        default public Builder webCrawlerConfiguration(Consumer<WebCrawlerConfiguration.Builder> webCrawlerConfiguration) {
            return this.webCrawlerConfiguration((WebCrawlerConfiguration)((WebCrawlerConfiguration.Builder)WebCrawlerConfiguration.builder().applyMutation(webCrawlerConfiguration)).build());
        }

        public Builder workDocsConfiguration(WorkDocsConfiguration var1);

        default public Builder workDocsConfiguration(Consumer<WorkDocsConfiguration.Builder> workDocsConfiguration) {
            return this.workDocsConfiguration((WorkDocsConfiguration)((WorkDocsConfiguration.Builder)WorkDocsConfiguration.builder().applyMutation(workDocsConfiguration)).build());
        }

        public Builder fsxConfiguration(FsxConfiguration var1);

        default public Builder fsxConfiguration(Consumer<FsxConfiguration.Builder> fsxConfiguration) {
            return this.fsxConfiguration((FsxConfiguration)((FsxConfiguration.Builder)FsxConfiguration.builder().applyMutation(fsxConfiguration)).build());
        }

        public Builder slackConfiguration(SlackConfiguration var1);

        default public Builder slackConfiguration(Consumer<SlackConfiguration.Builder> slackConfiguration) {
            return this.slackConfiguration((SlackConfiguration)((SlackConfiguration.Builder)SlackConfiguration.builder().applyMutation(slackConfiguration)).build());
        }
    }
}

