/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.ConfluenceAttachmentConfiguration;
import software.amazon.awssdk.services.kendra.model.ConfluenceBlogConfiguration;
import software.amazon.awssdk.services.kendra.model.ConfluencePageConfiguration;
import software.amazon.awssdk.services.kendra.model.ConfluenceSpaceConfiguration;
import software.amazon.awssdk.services.kendra.model.ConfluenceVersion;
import software.amazon.awssdk.services.kendra.model.DataSourceInclusionsExclusionsStringsCopier;
import software.amazon.awssdk.services.kendra.model.DataSourceVpcConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfluenceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfluenceConfiguration> {
    private static final SdkField<String> SERVER_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerUrl").getter(ConfluenceConfiguration.getter(ConfluenceConfiguration::serverUrl)).setter(ConfluenceConfiguration.setter(Builder::serverUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerUrl").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretArn").getter(ConfluenceConfiguration.getter(ConfluenceConfiguration::secretArn)).setter(ConfluenceConfiguration.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(ConfluenceConfiguration.getter(ConfluenceConfiguration::versionAsString)).setter(ConfluenceConfiguration.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<ConfluenceSpaceConfiguration> SPACE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SpaceConfiguration").getter(ConfluenceConfiguration.getter(ConfluenceConfiguration::spaceConfiguration)).setter(ConfluenceConfiguration.setter(Builder::spaceConfiguration)).constructor(ConfluenceSpaceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceConfiguration").build()}).build();
    private static final SdkField<ConfluencePageConfiguration> PAGE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PageConfiguration").getter(ConfluenceConfiguration.getter(ConfluenceConfiguration::pageConfiguration)).setter(ConfluenceConfiguration.setter(Builder::pageConfiguration)).constructor(ConfluencePageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageConfiguration").build()}).build();
    private static final SdkField<ConfluenceBlogConfiguration> BLOG_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BlogConfiguration").getter(ConfluenceConfiguration.getter(ConfluenceConfiguration::blogConfiguration)).setter(ConfluenceConfiguration.setter(Builder::blogConfiguration)).constructor(ConfluenceBlogConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlogConfiguration").build()}).build();
    private static final SdkField<ConfluenceAttachmentConfiguration> ATTACHMENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AttachmentConfiguration").getter(ConfluenceConfiguration.getter(ConfluenceConfiguration::attachmentConfiguration)).setter(ConfluenceConfiguration.setter(Builder::attachmentConfiguration)).constructor(ConfluenceAttachmentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentConfiguration").build()}).build();
    private static final SdkField<DataSourceVpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfiguration").getter(ConfluenceConfiguration.getter(ConfluenceConfiguration::vpcConfiguration)).setter(ConfluenceConfiguration.setter(Builder::vpcConfiguration)).constructor(DataSourceVpcConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration").build()}).build();
    private static final SdkField<List<String>> INCLUSION_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InclusionPatterns").getter(ConfluenceConfiguration.getter(ConfluenceConfiguration::inclusionPatterns)).setter(ConfluenceConfiguration.setter(Builder::inclusionPatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionPatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUSION_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExclusionPatterns").getter(ConfluenceConfiguration.getter(ConfluenceConfiguration::exclusionPatterns)).setter(ConfluenceConfiguration.setter(Builder::exclusionPatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusionPatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_URL_FIELD, SECRET_ARN_FIELD, VERSION_FIELD, SPACE_CONFIGURATION_FIELD, PAGE_CONFIGURATION_FIELD, BLOG_CONFIGURATION_FIELD, ATTACHMENT_CONFIGURATION_FIELD, VPC_CONFIGURATION_FIELD, INCLUSION_PATTERNS_FIELD, EXCLUSION_PATTERNS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String serverUrl;
    private final String secretArn;
    private final String version;
    private final ConfluenceSpaceConfiguration spaceConfiguration;
    private final ConfluencePageConfiguration pageConfiguration;
    private final ConfluenceBlogConfiguration blogConfiguration;
    private final ConfluenceAttachmentConfiguration attachmentConfiguration;
    private final DataSourceVpcConfiguration vpcConfiguration;
    private final List<String> inclusionPatterns;
    private final List<String> exclusionPatterns;

    private ConfluenceConfiguration(BuilderImpl builder) {
        this.serverUrl = builder.serverUrl;
        this.secretArn = builder.secretArn;
        this.version = builder.version;
        this.spaceConfiguration = builder.spaceConfiguration;
        this.pageConfiguration = builder.pageConfiguration;
        this.blogConfiguration = builder.blogConfiguration;
        this.attachmentConfiguration = builder.attachmentConfiguration;
        this.vpcConfiguration = builder.vpcConfiguration;
        this.inclusionPatterns = builder.inclusionPatterns;
        this.exclusionPatterns = builder.exclusionPatterns;
    }

    public final String serverUrl() {
        return this.serverUrl;
    }

    public final String secretArn() {
        return this.secretArn;
    }

    public final ConfluenceVersion version() {
        return ConfluenceVersion.fromValue(this.version);
    }

    public final String versionAsString() {
        return this.version;
    }

    public final ConfluenceSpaceConfiguration spaceConfiguration() {
        return this.spaceConfiguration;
    }

    public final ConfluencePageConfiguration pageConfiguration() {
        return this.pageConfiguration;
    }

    public final ConfluenceBlogConfiguration blogConfiguration() {
        return this.blogConfiguration;
    }

    public final ConfluenceAttachmentConfiguration attachmentConfiguration() {
        return this.attachmentConfiguration;
    }

    public final DataSourceVpcConfiguration vpcConfiguration() {
        return this.vpcConfiguration;
    }

    public final boolean hasInclusionPatterns() {
        return this.inclusionPatterns != null && !(this.inclusionPatterns instanceof SdkAutoConstructList);
    }

    public final List<String> inclusionPatterns() {
        return this.inclusionPatterns;
    }

    public final boolean hasExclusionPatterns() {
        return this.exclusionPatterns != null && !(this.exclusionPatterns instanceof SdkAutoConstructList);
    }

    public final List<String> exclusionPatterns() {
        return this.exclusionPatterns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serverUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.blogConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInclusionPatterns() ? this.inclusionPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExclusionPatterns() ? this.exclusionPatterns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfluenceConfiguration)) {
            return false;
        }
        ConfluenceConfiguration other = (ConfluenceConfiguration)obj;
        return Objects.equals(this.serverUrl(), other.serverUrl()) && Objects.equals(this.secretArn(), other.secretArn()) && Objects.equals(this.versionAsString(), other.versionAsString()) && Objects.equals(this.spaceConfiguration(), other.spaceConfiguration()) && Objects.equals(this.pageConfiguration(), other.pageConfiguration()) && Objects.equals(this.blogConfiguration(), other.blogConfiguration()) && Objects.equals(this.attachmentConfiguration(), other.attachmentConfiguration()) && Objects.equals(this.vpcConfiguration(), other.vpcConfiguration()) && this.hasInclusionPatterns() == other.hasInclusionPatterns() && Objects.equals(this.inclusionPatterns(), other.inclusionPatterns()) && this.hasExclusionPatterns() == other.hasExclusionPatterns() && Objects.equals(this.exclusionPatterns(), other.exclusionPatterns());
    }

    public final String toString() {
        return ToString.builder((String)"ConfluenceConfiguration").add("ServerUrl", (Object)this.serverUrl()).add("SecretArn", (Object)this.secretArn()).add("Version", (Object)this.versionAsString()).add("SpaceConfiguration", (Object)this.spaceConfiguration()).add("PageConfiguration", (Object)this.pageConfiguration()).add("BlogConfiguration", (Object)this.blogConfiguration()).add("AttachmentConfiguration", (Object)this.attachmentConfiguration()).add("VpcConfiguration", (Object)this.vpcConfiguration()).add("InclusionPatterns", this.hasInclusionPatterns() ? this.inclusionPatterns() : null).add("ExclusionPatterns", this.hasExclusionPatterns() ? this.exclusionPatterns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServerUrl": {
                return Optional.ofNullable(clazz.cast(this.serverUrl()));
            }
            case "SecretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.versionAsString()));
            }
            case "SpaceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.spaceConfiguration()));
            }
            case "PageConfiguration": {
                return Optional.ofNullable(clazz.cast(this.pageConfiguration()));
            }
            case "BlogConfiguration": {
                return Optional.ofNullable(clazz.cast(this.blogConfiguration()));
            }
            case "AttachmentConfiguration": {
                return Optional.ofNullable(clazz.cast(this.attachmentConfiguration()));
            }
            case "VpcConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vpcConfiguration()));
            }
            case "InclusionPatterns": {
                return Optional.ofNullable(clazz.cast(this.inclusionPatterns()));
            }
            case "ExclusionPatterns": {
                return Optional.ofNullable(clazz.cast(this.exclusionPatterns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfluenceConfiguration, T> g) {
        return obj -> g.apply((ConfluenceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serverUrl;
        private String secretArn;
        private String version;
        private ConfluenceSpaceConfiguration spaceConfiguration;
        private ConfluencePageConfiguration pageConfiguration;
        private ConfluenceBlogConfiguration blogConfiguration;
        private ConfluenceAttachmentConfiguration attachmentConfiguration;
        private DataSourceVpcConfiguration vpcConfiguration;
        private List<String> inclusionPatterns = DefaultSdkAutoConstructList.getInstance();
        private List<String> exclusionPatterns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConfluenceConfiguration model) {
            this.serverUrl(model.serverUrl);
            this.secretArn(model.secretArn);
            this.version(model.version);
            this.spaceConfiguration(model.spaceConfiguration);
            this.pageConfiguration(model.pageConfiguration);
            this.blogConfiguration(model.blogConfiguration);
            this.attachmentConfiguration(model.attachmentConfiguration);
            this.vpcConfiguration(model.vpcConfiguration);
            this.inclusionPatterns(model.inclusionPatterns);
            this.exclusionPatterns(model.exclusionPatterns);
        }

        public final String getServerUrl() {
            return this.serverUrl;
        }

        public final void setServerUrl(String serverUrl) {
            this.serverUrl = serverUrl;
        }

        @Override
        @Transient
        public final Builder serverUrl(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        @Transient
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        @Transient
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        @Transient
        public final Builder version(ConfluenceVersion version) {
            this.version(version == null ? null : version.toString());
            return this;
        }

        public final ConfluenceSpaceConfiguration.Builder getSpaceConfiguration() {
            return this.spaceConfiguration != null ? this.spaceConfiguration.toBuilder() : null;
        }

        public final void setSpaceConfiguration(ConfluenceSpaceConfiguration.BuilderImpl spaceConfiguration) {
            this.spaceConfiguration = spaceConfiguration != null ? spaceConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder spaceConfiguration(ConfluenceSpaceConfiguration spaceConfiguration) {
            this.spaceConfiguration = spaceConfiguration;
            return this;
        }

        public final ConfluencePageConfiguration.Builder getPageConfiguration() {
            return this.pageConfiguration != null ? this.pageConfiguration.toBuilder() : null;
        }

        public final void setPageConfiguration(ConfluencePageConfiguration.BuilderImpl pageConfiguration) {
            this.pageConfiguration = pageConfiguration != null ? pageConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder pageConfiguration(ConfluencePageConfiguration pageConfiguration) {
            this.pageConfiguration = pageConfiguration;
            return this;
        }

        public final ConfluenceBlogConfiguration.Builder getBlogConfiguration() {
            return this.blogConfiguration != null ? this.blogConfiguration.toBuilder() : null;
        }

        public final void setBlogConfiguration(ConfluenceBlogConfiguration.BuilderImpl blogConfiguration) {
            this.blogConfiguration = blogConfiguration != null ? blogConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder blogConfiguration(ConfluenceBlogConfiguration blogConfiguration) {
            this.blogConfiguration = blogConfiguration;
            return this;
        }

        public final ConfluenceAttachmentConfiguration.Builder getAttachmentConfiguration() {
            return this.attachmentConfiguration != null ? this.attachmentConfiguration.toBuilder() : null;
        }

        public final void setAttachmentConfiguration(ConfluenceAttachmentConfiguration.BuilderImpl attachmentConfiguration) {
            this.attachmentConfiguration = attachmentConfiguration != null ? attachmentConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder attachmentConfiguration(ConfluenceAttachmentConfiguration attachmentConfiguration) {
            this.attachmentConfiguration = attachmentConfiguration;
            return this;
        }

        public final DataSourceVpcConfiguration.Builder getVpcConfiguration() {
            return this.vpcConfiguration != null ? this.vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(DataSourceVpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder vpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public final Collection<String> getInclusionPatterns() {
            if (this.inclusionPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inclusionPatterns;
        }

        public final void setInclusionPatterns(Collection<String> inclusionPatterns) {
            this.inclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(inclusionPatterns);
        }

        @Override
        @Transient
        public final Builder inclusionPatterns(Collection<String> inclusionPatterns) {
            this.inclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(inclusionPatterns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder inclusionPatterns(String ... inclusionPatterns) {
            this.inclusionPatterns(Arrays.asList(inclusionPatterns));
            return this;
        }

        public final Collection<String> getExclusionPatterns() {
            if (this.exclusionPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exclusionPatterns;
        }

        public final void setExclusionPatterns(Collection<String> exclusionPatterns) {
            this.exclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(exclusionPatterns);
        }

        @Override
        @Transient
        public final Builder exclusionPatterns(Collection<String> exclusionPatterns) {
            this.exclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(exclusionPatterns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder exclusionPatterns(String ... exclusionPatterns) {
            this.exclusionPatterns(Arrays.asList(exclusionPatterns));
            return this;
        }

        public ConfluenceConfiguration build() {
            return new ConfluenceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfluenceConfiguration> {
        public Builder serverUrl(String var1);

        public Builder secretArn(String var1);

        public Builder version(String var1);

        public Builder version(ConfluenceVersion var1);

        public Builder spaceConfiguration(ConfluenceSpaceConfiguration var1);

        default public Builder spaceConfiguration(Consumer<ConfluenceSpaceConfiguration.Builder> spaceConfiguration) {
            return this.spaceConfiguration((ConfluenceSpaceConfiguration)((ConfluenceSpaceConfiguration.Builder)ConfluenceSpaceConfiguration.builder().applyMutation(spaceConfiguration)).build());
        }

        public Builder pageConfiguration(ConfluencePageConfiguration var1);

        default public Builder pageConfiguration(Consumer<ConfluencePageConfiguration.Builder> pageConfiguration) {
            return this.pageConfiguration((ConfluencePageConfiguration)((ConfluencePageConfiguration.Builder)ConfluencePageConfiguration.builder().applyMutation(pageConfiguration)).build());
        }

        public Builder blogConfiguration(ConfluenceBlogConfiguration var1);

        default public Builder blogConfiguration(Consumer<ConfluenceBlogConfiguration.Builder> blogConfiguration) {
            return this.blogConfiguration((ConfluenceBlogConfiguration)((ConfluenceBlogConfiguration.Builder)ConfluenceBlogConfiguration.builder().applyMutation(blogConfiguration)).build());
        }

        public Builder attachmentConfiguration(ConfluenceAttachmentConfiguration var1);

        default public Builder attachmentConfiguration(Consumer<ConfluenceAttachmentConfiguration.Builder> attachmentConfiguration) {
            return this.attachmentConfiguration((ConfluenceAttachmentConfiguration)((ConfluenceAttachmentConfiguration.Builder)ConfluenceAttachmentConfiguration.builder().applyMutation(attachmentConfiguration)).build());
        }

        public Builder vpcConfiguration(DataSourceVpcConfiguration var1);

        default public Builder vpcConfiguration(Consumer<DataSourceVpcConfiguration.Builder> vpcConfiguration) {
            return this.vpcConfiguration((DataSourceVpcConfiguration)((DataSourceVpcConfiguration.Builder)DataSourceVpcConfiguration.builder().applyMutation(vpcConfiguration)).build());
        }

        public Builder inclusionPatterns(Collection<String> var1);

        public Builder inclusionPatterns(String ... var1);

        public Builder exclusionPatterns(Collection<String> var1);

        public Builder exclusionPatterns(String ... var1);
    }
}

