/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kendra.KendraClient;
import software.amazon.awssdk.services.kendra.model.ListEntityPersonasRequest;
import software.amazon.awssdk.services.kendra.model.ListEntityPersonasResponse;

public class ListEntityPersonasIterable
implements SdkIterable<ListEntityPersonasResponse> {
    private final KendraClient client;
    private final ListEntityPersonasRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEntityPersonasIterable(KendraClient client, ListEntityPersonasRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEntityPersonasResponseFetcher();
    }

    public Iterator<ListEntityPersonasResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListEntityPersonasResponseFetcher
    implements SyncPageFetcher<ListEntityPersonasResponse> {
        private ListEntityPersonasResponseFetcher() {
        }

        public boolean hasNextPage(ListEntityPersonasResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEntityPersonasResponse nextPage(ListEntityPersonasResponse previousPage) {
            if (previousPage == null) {
                return ListEntityPersonasIterable.this.client.listEntityPersonas(ListEntityPersonasIterable.this.firstRequest);
            }
            return ListEntityPersonasIterable.this.client.listEntityPersonas((ListEntityPersonasRequest)((Object)ListEntityPersonasIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

