/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping;
import software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMappingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SalesforceCustomKnowledgeArticleTypeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SalesforceCustomKnowledgeArticleTypeConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(SalesforceCustomKnowledgeArticleTypeConfiguration.getter(SalesforceCustomKnowledgeArticleTypeConfiguration::name)).setter(SalesforceCustomKnowledgeArticleTypeConfiguration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DOCUMENT_DATA_FIELD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentDataFieldName").getter(SalesforceCustomKnowledgeArticleTypeConfiguration.getter(SalesforceCustomKnowledgeArticleTypeConfiguration::documentDataFieldName)).setter(SalesforceCustomKnowledgeArticleTypeConfiguration.setter(Builder::documentDataFieldName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentDataFieldName").build()}).build();
    private static final SdkField<String> DOCUMENT_TITLE_FIELD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentTitleFieldName").getter(SalesforceCustomKnowledgeArticleTypeConfiguration.getter(SalesforceCustomKnowledgeArticleTypeConfiguration::documentTitleFieldName)).setter(SalesforceCustomKnowledgeArticleTypeConfiguration.setter(Builder::documentTitleFieldName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentTitleFieldName").build()}).build();
    private static final SdkField<List<DataSourceToIndexFieldMapping>> FIELD_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FieldMappings").getter(SalesforceCustomKnowledgeArticleTypeConfiguration.getter(SalesforceCustomKnowledgeArticleTypeConfiguration::fieldMappings)).setter(SalesforceCustomKnowledgeArticleTypeConfiguration.setter(Builder::fieldMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceToIndexFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DOCUMENT_DATA_FIELD_NAME_FIELD, DOCUMENT_TITLE_FIELD_NAME_FIELD, FIELD_MAPPINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String documentDataFieldName;
    private final String documentTitleFieldName;
    private final List<DataSourceToIndexFieldMapping> fieldMappings;

    private SalesforceCustomKnowledgeArticleTypeConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.documentDataFieldName = builder.documentDataFieldName;
        this.documentTitleFieldName = builder.documentTitleFieldName;
        this.fieldMappings = builder.fieldMappings;
    }

    public final String name() {
        return this.name;
    }

    public final String documentDataFieldName() {
        return this.documentDataFieldName;
    }

    public final String documentTitleFieldName() {
        return this.documentTitleFieldName;
    }

    public final boolean hasFieldMappings() {
        return this.fieldMappings != null && !(this.fieldMappings instanceof SdkAutoConstructList);
    }

    public final List<DataSourceToIndexFieldMapping> fieldMappings() {
        return this.fieldMappings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentDataFieldName());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentTitleFieldName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFieldMappings() ? this.fieldMappings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SalesforceCustomKnowledgeArticleTypeConfiguration)) {
            return false;
        }
        SalesforceCustomKnowledgeArticleTypeConfiguration other = (SalesforceCustomKnowledgeArticleTypeConfiguration)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.documentDataFieldName(), other.documentDataFieldName()) && Objects.equals(this.documentTitleFieldName(), other.documentTitleFieldName()) && this.hasFieldMappings() == other.hasFieldMappings() && Objects.equals(this.fieldMappings(), other.fieldMappings());
    }

    public final String toString() {
        return ToString.builder((String)"SalesforceCustomKnowledgeArticleTypeConfiguration").add("Name", (Object)this.name()).add("DocumentDataFieldName", (Object)this.documentDataFieldName()).add("DocumentTitleFieldName", (Object)this.documentTitleFieldName()).add("FieldMappings", this.hasFieldMappings() ? this.fieldMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "DocumentDataFieldName": {
                return Optional.ofNullable(clazz.cast(this.documentDataFieldName()));
            }
            case "DocumentTitleFieldName": {
                return Optional.ofNullable(clazz.cast(this.documentTitleFieldName()));
            }
            case "FieldMappings": {
                return Optional.ofNullable(clazz.cast(this.fieldMappings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SalesforceCustomKnowledgeArticleTypeConfiguration, T> g) {
        return obj -> g.apply((SalesforceCustomKnowledgeArticleTypeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String documentDataFieldName;
        private String documentTitleFieldName;
        private List<DataSourceToIndexFieldMapping> fieldMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SalesforceCustomKnowledgeArticleTypeConfiguration model) {
            this.name(model.name);
            this.documentDataFieldName(model.documentDataFieldName);
            this.documentTitleFieldName(model.documentTitleFieldName);
            this.fieldMappings(model.fieldMappings);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDocumentDataFieldName() {
            return this.documentDataFieldName;
        }

        public final void setDocumentDataFieldName(String documentDataFieldName) {
            this.documentDataFieldName = documentDataFieldName;
        }

        @Override
        @Transient
        public final Builder documentDataFieldName(String documentDataFieldName) {
            this.documentDataFieldName = documentDataFieldName;
            return this;
        }

        public final String getDocumentTitleFieldName() {
            return this.documentTitleFieldName;
        }

        public final void setDocumentTitleFieldName(String documentTitleFieldName) {
            this.documentTitleFieldName = documentTitleFieldName;
        }

        @Override
        @Transient
        public final Builder documentTitleFieldName(String documentTitleFieldName) {
            this.documentTitleFieldName = documentTitleFieldName;
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier.copyToBuilder(this.fieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(fieldMappings);
        }

        @Override
        @Transient
        public final Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copy(fieldMappings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder fieldMappings(DataSourceToIndexFieldMapping ... fieldMappings) {
            this.fieldMappings(Arrays.asList(fieldMappings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... fieldMappings) {
            this.fieldMappings(Stream.of(fieldMappings).map(c -> (DataSourceToIndexFieldMapping)((DataSourceToIndexFieldMapping.Builder)DataSourceToIndexFieldMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SalesforceCustomKnowledgeArticleTypeConfiguration build() {
            return new SalesforceCustomKnowledgeArticleTypeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SalesforceCustomKnowledgeArticleTypeConfiguration> {
        public Builder name(String var1);

        public Builder documentDataFieldName(String var1);

        public Builder documentTitleFieldName(String var1);

        public Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> var1);

        public Builder fieldMappings(DataSourceToIndexFieldMapping ... var1);

        public Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... var1);
    }
}

