/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.DataSourceInclusionsExclusionsStringsCopier;
import software.amazon.awssdk.services.kendra.model.SalesforceChatterFeedConfiguration;
import software.amazon.awssdk.services.kendra.model.SalesforceKnowledgeArticleConfiguration;
import software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectAttachmentConfiguration;
import software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectConfiguration;
import software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SalesforceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SalesforceConfiguration> {
    private static final SdkField<String> SERVER_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerUrl").getter(SalesforceConfiguration.getter(SalesforceConfiguration::serverUrl)).setter(SalesforceConfiguration.setter(Builder::serverUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerUrl").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretArn").getter(SalesforceConfiguration.getter(SalesforceConfiguration::secretArn)).setter(SalesforceConfiguration.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()}).build();
    private static final SdkField<List<SalesforceStandardObjectConfiguration>> STANDARD_OBJECT_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StandardObjectConfigurations").getter(SalesforceConfiguration.getter(SalesforceConfiguration::standardObjectConfigurations)).setter(SalesforceConfiguration.setter(Builder::standardObjectConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardObjectConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SalesforceStandardObjectConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SalesforceKnowledgeArticleConfiguration> KNOWLEDGE_ARTICLE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KnowledgeArticleConfiguration").getter(SalesforceConfiguration.getter(SalesforceConfiguration::knowledgeArticleConfiguration)).setter(SalesforceConfiguration.setter(Builder::knowledgeArticleConfiguration)).constructor(SalesforceKnowledgeArticleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KnowledgeArticleConfiguration").build()}).build();
    private static final SdkField<SalesforceChatterFeedConfiguration> CHATTER_FEED_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ChatterFeedConfiguration").getter(SalesforceConfiguration.getter(SalesforceConfiguration::chatterFeedConfiguration)).setter(SalesforceConfiguration.setter(Builder::chatterFeedConfiguration)).constructor(SalesforceChatterFeedConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChatterFeedConfiguration").build()}).build();
    private static final SdkField<Boolean> CRAWL_ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CrawlAttachments").getter(SalesforceConfiguration.getter(SalesforceConfiguration::crawlAttachments)).setter(SalesforceConfiguration.setter(Builder::crawlAttachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlAttachments").build()}).build();
    private static final SdkField<SalesforceStandardObjectAttachmentConfiguration> STANDARD_OBJECT_ATTACHMENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StandardObjectAttachmentConfiguration").getter(SalesforceConfiguration.getter(SalesforceConfiguration::standardObjectAttachmentConfiguration)).setter(SalesforceConfiguration.setter(Builder::standardObjectAttachmentConfiguration)).constructor(SalesforceStandardObjectAttachmentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardObjectAttachmentConfiguration").build()}).build();
    private static final SdkField<List<String>> INCLUDE_ATTACHMENT_FILE_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IncludeAttachmentFilePatterns").getter(SalesforceConfiguration.getter(SalesforceConfiguration::includeAttachmentFilePatterns)).setter(SalesforceConfiguration.setter(Builder::includeAttachmentFilePatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeAttachmentFilePatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUDE_ATTACHMENT_FILE_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludeAttachmentFilePatterns").getter(SalesforceConfiguration.getter(SalesforceConfiguration::excludeAttachmentFilePatterns)).setter(SalesforceConfiguration.setter(Builder::excludeAttachmentFilePatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeAttachmentFilePatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_URL_FIELD, SECRET_ARN_FIELD, STANDARD_OBJECT_CONFIGURATIONS_FIELD, KNOWLEDGE_ARTICLE_CONFIGURATION_FIELD, CHATTER_FEED_CONFIGURATION_FIELD, CRAWL_ATTACHMENTS_FIELD, STANDARD_OBJECT_ATTACHMENT_CONFIGURATION_FIELD, INCLUDE_ATTACHMENT_FILE_PATTERNS_FIELD, EXCLUDE_ATTACHMENT_FILE_PATTERNS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String serverUrl;
    private final String secretArn;
    private final List<SalesforceStandardObjectConfiguration> standardObjectConfigurations;
    private final SalesforceKnowledgeArticleConfiguration knowledgeArticleConfiguration;
    private final SalesforceChatterFeedConfiguration chatterFeedConfiguration;
    private final Boolean crawlAttachments;
    private final SalesforceStandardObjectAttachmentConfiguration standardObjectAttachmentConfiguration;
    private final List<String> includeAttachmentFilePatterns;
    private final List<String> excludeAttachmentFilePatterns;

    private SalesforceConfiguration(BuilderImpl builder) {
        this.serverUrl = builder.serverUrl;
        this.secretArn = builder.secretArn;
        this.standardObjectConfigurations = builder.standardObjectConfigurations;
        this.knowledgeArticleConfiguration = builder.knowledgeArticleConfiguration;
        this.chatterFeedConfiguration = builder.chatterFeedConfiguration;
        this.crawlAttachments = builder.crawlAttachments;
        this.standardObjectAttachmentConfiguration = builder.standardObjectAttachmentConfiguration;
        this.includeAttachmentFilePatterns = builder.includeAttachmentFilePatterns;
        this.excludeAttachmentFilePatterns = builder.excludeAttachmentFilePatterns;
    }

    public final String serverUrl() {
        return this.serverUrl;
    }

    public final String secretArn() {
        return this.secretArn;
    }

    public final boolean hasStandardObjectConfigurations() {
        return this.standardObjectConfigurations != null && !(this.standardObjectConfigurations instanceof SdkAutoConstructList);
    }

    public final List<SalesforceStandardObjectConfiguration> standardObjectConfigurations() {
        return this.standardObjectConfigurations;
    }

    public final SalesforceKnowledgeArticleConfiguration knowledgeArticleConfiguration() {
        return this.knowledgeArticleConfiguration;
    }

    public final SalesforceChatterFeedConfiguration chatterFeedConfiguration() {
        return this.chatterFeedConfiguration;
    }

    public final Boolean crawlAttachments() {
        return this.crawlAttachments;
    }

    public final SalesforceStandardObjectAttachmentConfiguration standardObjectAttachmentConfiguration() {
        return this.standardObjectAttachmentConfiguration;
    }

    public final boolean hasIncludeAttachmentFilePatterns() {
        return this.includeAttachmentFilePatterns != null && !(this.includeAttachmentFilePatterns instanceof SdkAutoConstructList);
    }

    public final List<String> includeAttachmentFilePatterns() {
        return this.includeAttachmentFilePatterns;
    }

    public final boolean hasExcludeAttachmentFilePatterns() {
        return this.excludeAttachmentFilePatterns != null && !(this.excludeAttachmentFilePatterns instanceof SdkAutoConstructList);
    }

    public final List<String> excludeAttachmentFilePatterns() {
        return this.excludeAttachmentFilePatterns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serverUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStandardObjectConfigurations() ? this.standardObjectConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeArticleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.chatterFeedConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlAttachments());
        hashCode = 31 * hashCode + Objects.hashCode(this.standardObjectAttachmentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludeAttachmentFilePatterns() ? this.includeAttachmentFilePatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludeAttachmentFilePatterns() ? this.excludeAttachmentFilePatterns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SalesforceConfiguration)) {
            return false;
        }
        SalesforceConfiguration other = (SalesforceConfiguration)obj;
        return Objects.equals(this.serverUrl(), other.serverUrl()) && Objects.equals(this.secretArn(), other.secretArn()) && this.hasStandardObjectConfigurations() == other.hasStandardObjectConfigurations() && Objects.equals(this.standardObjectConfigurations(), other.standardObjectConfigurations()) && Objects.equals(this.knowledgeArticleConfiguration(), other.knowledgeArticleConfiguration()) && Objects.equals(this.chatterFeedConfiguration(), other.chatterFeedConfiguration()) && Objects.equals(this.crawlAttachments(), other.crawlAttachments()) && Objects.equals(this.standardObjectAttachmentConfiguration(), other.standardObjectAttachmentConfiguration()) && this.hasIncludeAttachmentFilePatterns() == other.hasIncludeAttachmentFilePatterns() && Objects.equals(this.includeAttachmentFilePatterns(), other.includeAttachmentFilePatterns()) && this.hasExcludeAttachmentFilePatterns() == other.hasExcludeAttachmentFilePatterns() && Objects.equals(this.excludeAttachmentFilePatterns(), other.excludeAttachmentFilePatterns());
    }

    public final String toString() {
        return ToString.builder((String)"SalesforceConfiguration").add("ServerUrl", (Object)this.serverUrl()).add("SecretArn", (Object)this.secretArn()).add("StandardObjectConfigurations", this.hasStandardObjectConfigurations() ? this.standardObjectConfigurations() : null).add("KnowledgeArticleConfiguration", (Object)this.knowledgeArticleConfiguration()).add("ChatterFeedConfiguration", (Object)this.chatterFeedConfiguration()).add("CrawlAttachments", (Object)this.crawlAttachments()).add("StandardObjectAttachmentConfiguration", (Object)this.standardObjectAttachmentConfiguration()).add("IncludeAttachmentFilePatterns", this.hasIncludeAttachmentFilePatterns() ? this.includeAttachmentFilePatterns() : null).add("ExcludeAttachmentFilePatterns", this.hasExcludeAttachmentFilePatterns() ? this.excludeAttachmentFilePatterns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServerUrl": {
                return Optional.ofNullable(clazz.cast(this.serverUrl()));
            }
            case "SecretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
            case "StandardObjectConfigurations": {
                return Optional.ofNullable(clazz.cast(this.standardObjectConfigurations()));
            }
            case "KnowledgeArticleConfiguration": {
                return Optional.ofNullable(clazz.cast(this.knowledgeArticleConfiguration()));
            }
            case "ChatterFeedConfiguration": {
                return Optional.ofNullable(clazz.cast(this.chatterFeedConfiguration()));
            }
            case "CrawlAttachments": {
                return Optional.ofNullable(clazz.cast(this.crawlAttachments()));
            }
            case "StandardObjectAttachmentConfiguration": {
                return Optional.ofNullable(clazz.cast(this.standardObjectAttachmentConfiguration()));
            }
            case "IncludeAttachmentFilePatterns": {
                return Optional.ofNullable(clazz.cast(this.includeAttachmentFilePatterns()));
            }
            case "ExcludeAttachmentFilePatterns": {
                return Optional.ofNullable(clazz.cast(this.excludeAttachmentFilePatterns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SalesforceConfiguration, T> g) {
        return obj -> g.apply((SalesforceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serverUrl;
        private String secretArn;
        private List<SalesforceStandardObjectConfiguration> standardObjectConfigurations = DefaultSdkAutoConstructList.getInstance();
        private SalesforceKnowledgeArticleConfiguration knowledgeArticleConfiguration;
        private SalesforceChatterFeedConfiguration chatterFeedConfiguration;
        private Boolean crawlAttachments;
        private SalesforceStandardObjectAttachmentConfiguration standardObjectAttachmentConfiguration;
        private List<String> includeAttachmentFilePatterns = DefaultSdkAutoConstructList.getInstance();
        private List<String> excludeAttachmentFilePatterns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SalesforceConfiguration model) {
            this.serverUrl(model.serverUrl);
            this.secretArn(model.secretArn);
            this.standardObjectConfigurations(model.standardObjectConfigurations);
            this.knowledgeArticleConfiguration(model.knowledgeArticleConfiguration);
            this.chatterFeedConfiguration(model.chatterFeedConfiguration);
            this.crawlAttachments(model.crawlAttachments);
            this.standardObjectAttachmentConfiguration(model.standardObjectAttachmentConfiguration);
            this.includeAttachmentFilePatterns(model.includeAttachmentFilePatterns);
            this.excludeAttachmentFilePatterns(model.excludeAttachmentFilePatterns);
        }

        public final String getServerUrl() {
            return this.serverUrl;
        }

        @Override
        public final Builder serverUrl(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        public final void setServerUrl(String serverUrl) {
            this.serverUrl = serverUrl;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        public final List<SalesforceStandardObjectConfiguration.Builder> getStandardObjectConfigurations() {
            List<SalesforceStandardObjectConfiguration.Builder> result = SalesforceStandardObjectConfigurationListCopier.copyToBuilder(this.standardObjectConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder standardObjectConfigurations(Collection<SalesforceStandardObjectConfiguration> standardObjectConfigurations) {
            this.standardObjectConfigurations = SalesforceStandardObjectConfigurationListCopier.copy(standardObjectConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder standardObjectConfigurations(SalesforceStandardObjectConfiguration ... standardObjectConfigurations) {
            this.standardObjectConfigurations(Arrays.asList(standardObjectConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder standardObjectConfigurations(Consumer<SalesforceStandardObjectConfiguration.Builder> ... standardObjectConfigurations) {
            this.standardObjectConfigurations(Stream.of(standardObjectConfigurations).map(c -> (SalesforceStandardObjectConfiguration)((SalesforceStandardObjectConfiguration.Builder)SalesforceStandardObjectConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStandardObjectConfigurations(Collection<SalesforceStandardObjectConfiguration.BuilderImpl> standardObjectConfigurations) {
            this.standardObjectConfigurations = SalesforceStandardObjectConfigurationListCopier.copyFromBuilder(standardObjectConfigurations);
        }

        public final SalesforceKnowledgeArticleConfiguration.Builder getKnowledgeArticleConfiguration() {
            return this.knowledgeArticleConfiguration != null ? this.knowledgeArticleConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder knowledgeArticleConfiguration(SalesforceKnowledgeArticleConfiguration knowledgeArticleConfiguration) {
            this.knowledgeArticleConfiguration = knowledgeArticleConfiguration;
            return this;
        }

        public final void setKnowledgeArticleConfiguration(SalesforceKnowledgeArticleConfiguration.BuilderImpl knowledgeArticleConfiguration) {
            this.knowledgeArticleConfiguration = knowledgeArticleConfiguration != null ? knowledgeArticleConfiguration.build() : null;
        }

        public final SalesforceChatterFeedConfiguration.Builder getChatterFeedConfiguration() {
            return this.chatterFeedConfiguration != null ? this.chatterFeedConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder chatterFeedConfiguration(SalesforceChatterFeedConfiguration chatterFeedConfiguration) {
            this.chatterFeedConfiguration = chatterFeedConfiguration;
            return this;
        }

        public final void setChatterFeedConfiguration(SalesforceChatterFeedConfiguration.BuilderImpl chatterFeedConfiguration) {
            this.chatterFeedConfiguration = chatterFeedConfiguration != null ? chatterFeedConfiguration.build() : null;
        }

        public final Boolean getCrawlAttachments() {
            return this.crawlAttachments;
        }

        @Override
        public final Builder crawlAttachments(Boolean crawlAttachments) {
            this.crawlAttachments = crawlAttachments;
            return this;
        }

        public final void setCrawlAttachments(Boolean crawlAttachments) {
            this.crawlAttachments = crawlAttachments;
        }

        public final SalesforceStandardObjectAttachmentConfiguration.Builder getStandardObjectAttachmentConfiguration() {
            return this.standardObjectAttachmentConfiguration != null ? this.standardObjectAttachmentConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder standardObjectAttachmentConfiguration(SalesforceStandardObjectAttachmentConfiguration standardObjectAttachmentConfiguration) {
            this.standardObjectAttachmentConfiguration = standardObjectAttachmentConfiguration;
            return this;
        }

        public final void setStandardObjectAttachmentConfiguration(SalesforceStandardObjectAttachmentConfiguration.BuilderImpl standardObjectAttachmentConfiguration) {
            this.standardObjectAttachmentConfiguration = standardObjectAttachmentConfiguration != null ? standardObjectAttachmentConfiguration.build() : null;
        }

        public final Collection<String> getIncludeAttachmentFilePatterns() {
            if (this.includeAttachmentFilePatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.includeAttachmentFilePatterns;
        }

        @Override
        public final Builder includeAttachmentFilePatterns(Collection<String> includeAttachmentFilePatterns) {
            this.includeAttachmentFilePatterns = DataSourceInclusionsExclusionsStringsCopier.copy(includeAttachmentFilePatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeAttachmentFilePatterns(String ... includeAttachmentFilePatterns) {
            this.includeAttachmentFilePatterns(Arrays.asList(includeAttachmentFilePatterns));
            return this;
        }

        public final void setIncludeAttachmentFilePatterns(Collection<String> includeAttachmentFilePatterns) {
            this.includeAttachmentFilePatterns = DataSourceInclusionsExclusionsStringsCopier.copy(includeAttachmentFilePatterns);
        }

        public final Collection<String> getExcludeAttachmentFilePatterns() {
            if (this.excludeAttachmentFilePatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludeAttachmentFilePatterns;
        }

        @Override
        public final Builder excludeAttachmentFilePatterns(Collection<String> excludeAttachmentFilePatterns) {
            this.excludeAttachmentFilePatterns = DataSourceInclusionsExclusionsStringsCopier.copy(excludeAttachmentFilePatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeAttachmentFilePatterns(String ... excludeAttachmentFilePatterns) {
            this.excludeAttachmentFilePatterns(Arrays.asList(excludeAttachmentFilePatterns));
            return this;
        }

        public final void setExcludeAttachmentFilePatterns(Collection<String> excludeAttachmentFilePatterns) {
            this.excludeAttachmentFilePatterns = DataSourceInclusionsExclusionsStringsCopier.copy(excludeAttachmentFilePatterns);
        }

        public SalesforceConfiguration build() {
            return new SalesforceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SalesforceConfiguration> {
        public Builder serverUrl(String var1);

        public Builder secretArn(String var1);

        public Builder standardObjectConfigurations(Collection<SalesforceStandardObjectConfiguration> var1);

        public Builder standardObjectConfigurations(SalesforceStandardObjectConfiguration ... var1);

        public Builder standardObjectConfigurations(Consumer<SalesforceStandardObjectConfiguration.Builder> ... var1);

        public Builder knowledgeArticleConfiguration(SalesforceKnowledgeArticleConfiguration var1);

        default public Builder knowledgeArticleConfiguration(Consumer<SalesforceKnowledgeArticleConfiguration.Builder> knowledgeArticleConfiguration) {
            return this.knowledgeArticleConfiguration((SalesforceKnowledgeArticleConfiguration)((SalesforceKnowledgeArticleConfiguration.Builder)SalesforceKnowledgeArticleConfiguration.builder().applyMutation(knowledgeArticleConfiguration)).build());
        }

        public Builder chatterFeedConfiguration(SalesforceChatterFeedConfiguration var1);

        default public Builder chatterFeedConfiguration(Consumer<SalesforceChatterFeedConfiguration.Builder> chatterFeedConfiguration) {
            return this.chatterFeedConfiguration((SalesforceChatterFeedConfiguration)((SalesforceChatterFeedConfiguration.Builder)SalesforceChatterFeedConfiguration.builder().applyMutation(chatterFeedConfiguration)).build());
        }

        public Builder crawlAttachments(Boolean var1);

        public Builder standardObjectAttachmentConfiguration(SalesforceStandardObjectAttachmentConfiguration var1);

        default public Builder standardObjectAttachmentConfiguration(Consumer<SalesforceStandardObjectAttachmentConfiguration.Builder> standardObjectAttachmentConfiguration) {
            return this.standardObjectAttachmentConfiguration((SalesforceStandardObjectAttachmentConfiguration)((SalesforceStandardObjectAttachmentConfiguration.Builder)SalesforceStandardObjectAttachmentConfiguration.builder().applyMutation(standardObjectAttachmentConfiguration)).build());
        }

        public Builder includeAttachmentFilePatterns(Collection<String> var1);

        public Builder includeAttachmentFilePatterns(String ... var1);

        public Builder excludeAttachmentFilePatterns(Collection<String> var1);

        public Builder excludeAttachmentFilePatterns(String ... var1);
    }
}

