/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kendra.model.KendraRequest;
import software.amazon.awssdk.services.kendra.model.S3Path;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateQuerySuggestionsBlockListRequest
extends KendraRequest
implements ToCopyableBuilder<Builder, UpdateQuerySuggestionsBlockListRequest> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexId").getter(UpdateQuerySuggestionsBlockListRequest.getter(UpdateQuerySuggestionsBlockListRequest::indexId)).setter(UpdateQuerySuggestionsBlockListRequest.setter(Builder::indexId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(UpdateQuerySuggestionsBlockListRequest.getter(UpdateQuerySuggestionsBlockListRequest::id)).setter(UpdateQuerySuggestionsBlockListRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateQuerySuggestionsBlockListRequest.getter(UpdateQuerySuggestionsBlockListRequest::name)).setter(UpdateQuerySuggestionsBlockListRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateQuerySuggestionsBlockListRequest.getter(UpdateQuerySuggestionsBlockListRequest::description)).setter(UpdateQuerySuggestionsBlockListRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<S3Path> SOURCE_S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceS3Path").getter(UpdateQuerySuggestionsBlockListRequest.getter(UpdateQuerySuggestionsBlockListRequest::sourceS3Path)).setter(UpdateQuerySuggestionsBlockListRequest.setter(Builder::sourceS3Path)).constructor(S3Path::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceS3Path").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(UpdateQuerySuggestionsBlockListRequest.getter(UpdateQuerySuggestionsBlockListRequest::roleArn)).setter(UpdateQuerySuggestionsBlockListRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD, ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, SOURCE_S3_PATH_FIELD, ROLE_ARN_FIELD));
    private final String indexId;
    private final String id;
    private final String name;
    private final String description;
    private final S3Path sourceS3Path;
    private final String roleArn;

    private UpdateQuerySuggestionsBlockListRequest(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.sourceS3Path = builder.sourceS3Path;
        this.roleArn = builder.roleArn;
    }

    public final String indexId() {
        return this.indexId;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final S3Path sourceS3Path() {
        return this.sourceS3Path;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.indexId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateQuerySuggestionsBlockListRequest)) {
            return false;
        }
        UpdateQuerySuggestionsBlockListRequest other = (UpdateQuerySuggestionsBlockListRequest)((Object)obj);
        return Objects.equals(this.indexId(), other.indexId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.sourceS3Path(), other.sourceS3Path()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateQuerySuggestionsBlockListRequest").add("IndexId", (Object)this.indexId()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("SourceS3Path", (Object)this.sourceS3Path()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexId": {
                return Optional.ofNullable(clazz.cast(this.indexId()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "SourceS3Path": {
                return Optional.ofNullable(clazz.cast(this.sourceS3Path()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateQuerySuggestionsBlockListRequest, T> g) {
        return obj -> g.apply((UpdateQuerySuggestionsBlockListRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraRequest.BuilderImpl
    implements Builder {
        private String indexId;
        private String id;
        private String name;
        private String description;
        private S3Path sourceS3Path;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateQuerySuggestionsBlockListRequest model) {
            super(model);
            this.indexId(model.indexId);
            this.id(model.id);
            this.name(model.name);
            this.description(model.description);
            this.sourceS3Path(model.sourceS3Path);
            this.roleArn(model.roleArn);
        }

        public final String getIndexId() {
            return this.indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final S3Path.Builder getSourceS3Path() {
            return this.sourceS3Path != null ? this.sourceS3Path.toBuilder() : null;
        }

        @Override
        public final Builder sourceS3Path(S3Path sourceS3Path) {
            this.sourceS3Path = sourceS3Path;
            return this;
        }

        public final void setSourceS3Path(S3Path.BuilderImpl sourceS3Path) {
            this.sourceS3Path = sourceS3Path != null ? sourceS3Path.build() : null;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateQuerySuggestionsBlockListRequest build() {
            return new UpdateQuerySuggestionsBlockListRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KendraRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateQuerySuggestionsBlockListRequest> {
        public Builder indexId(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder sourceS3Path(S3Path var1);

        default public Builder sourceS3Path(Consumer<S3Path.Builder> sourceS3Path) {
            return this.sourceS3Path((S3Path)((S3Path.Builder)S3Path.builder().applyMutation(sourceS3Path)).build());
        }

        public Builder roleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

