/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum KeyLocation {
    URL("URL"),
    SECRET_MANAGER("SECRET_MANAGER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private KeyLocation(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KeyLocation fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(KeyLocation.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KeyLocation> knownValues() {
        return Stream.of(KeyLocation.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

