/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kendra.model.RelevanceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RelevanceFeedback
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RelevanceFeedback> {
    private static final SdkField<String> RESULT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResultId").getter(RelevanceFeedback.getter(RelevanceFeedback::resultId)).setter(RelevanceFeedback.setter(Builder::resultId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultId").build()}).build();
    private static final SdkField<String> RELEVANCE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RelevanceValue").getter(RelevanceFeedback.getter(RelevanceFeedback::relevanceValueAsString)).setter(RelevanceFeedback.setter(Builder::relevanceValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelevanceValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_ID_FIELD, RELEVANCE_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resultId;
    private final String relevanceValue;

    private RelevanceFeedback(BuilderImpl builder) {
        this.resultId = builder.resultId;
        this.relevanceValue = builder.relevanceValue;
    }

    public final String resultId() {
        return this.resultId;
    }

    public final RelevanceType relevanceValue() {
        return RelevanceType.fromValue(this.relevanceValue);
    }

    public final String relevanceValueAsString() {
        return this.relevanceValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resultId());
        hashCode = 31 * hashCode + Objects.hashCode(this.relevanceValueAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelevanceFeedback)) {
            return false;
        }
        RelevanceFeedback other = (RelevanceFeedback)obj;
        return Objects.equals(this.resultId(), other.resultId()) && Objects.equals(this.relevanceValueAsString(), other.relevanceValueAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RelevanceFeedback").add("ResultId", (Object)this.resultId()).add("RelevanceValue", (Object)this.relevanceValueAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResultId": {
                return Optional.ofNullable(clazz.cast(this.resultId()));
            }
            case "RelevanceValue": {
                return Optional.ofNullable(clazz.cast(this.relevanceValueAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RelevanceFeedback, T> g) {
        return obj -> g.apply((RelevanceFeedback)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resultId;
        private String relevanceValue;

        private BuilderImpl() {
        }

        private BuilderImpl(RelevanceFeedback model) {
            this.resultId(model.resultId);
            this.relevanceValue(model.relevanceValue);
        }

        public final String getResultId() {
            return this.resultId;
        }

        @Override
        public final Builder resultId(String resultId) {
            this.resultId = resultId;
            return this;
        }

        public final void setResultId(String resultId) {
            this.resultId = resultId;
        }

        public final String getRelevanceValue() {
            return this.relevanceValue;
        }

        @Override
        public final Builder relevanceValue(String relevanceValue) {
            this.relevanceValue = relevanceValue;
            return this;
        }

        @Override
        public final Builder relevanceValue(RelevanceType relevanceValue) {
            this.relevanceValue(relevanceValue == null ? null : relevanceValue.toString());
            return this;
        }

        public final void setRelevanceValue(String relevanceValue) {
            this.relevanceValue = relevanceValue;
        }

        public RelevanceFeedback build() {
            return new RelevanceFeedback(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RelevanceFeedback> {
        public Builder resultId(String var1);

        public Builder relevanceValue(String var1);

        public Builder relevanceValue(RelevanceType var1);
    }
}

