/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.DocumentAttributeStringListValueCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentAttributeValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentAttributeValue> {
    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StringValue").getter(DocumentAttributeValue.getter(DocumentAttributeValue::stringValue)).setter(DocumentAttributeValue.setter(Builder::stringValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringValue").build()}).build();
    private static final SdkField<List<String>> STRING_LIST_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StringListValue").getter(DocumentAttributeValue.getter(DocumentAttributeValue::stringListValue)).setter(DocumentAttributeValue.setter(Builder::stringListValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringListValue").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> LONG_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("LongValue").getter(DocumentAttributeValue.getter(DocumentAttributeValue::longValue)).setter(DocumentAttributeValue.setter(Builder::longValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LongValue").build()}).build();
    private static final SdkField<Instant> DATE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DateValue").getter(DocumentAttributeValue.getter(DocumentAttributeValue::dateValue)).setter(DocumentAttributeValue.setter(Builder::dateValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_VALUE_FIELD, STRING_LIST_VALUE_FIELD, LONG_VALUE_FIELD, DATE_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String stringValue;
    private final List<String> stringListValue;
    private final Long longValue;
    private final Instant dateValue;

    private DocumentAttributeValue(BuilderImpl builder) {
        this.stringValue = builder.stringValue;
        this.stringListValue = builder.stringListValue;
        this.longValue = builder.longValue;
        this.dateValue = builder.dateValue;
    }

    public final String stringValue() {
        return this.stringValue;
    }

    public final boolean hasStringListValue() {
        return this.stringListValue != null && !(this.stringListValue instanceof SdkAutoConstructList);
    }

    public final List<String> stringListValue() {
        return this.stringListValue;
    }

    public final Long longValue() {
        return this.longValue;
    }

    public final Instant dateValue() {
        return this.dateValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStringListValue() ? this.stringListValue() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.longValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentAttributeValue)) {
            return false;
        }
        DocumentAttributeValue other = (DocumentAttributeValue)obj;
        return Objects.equals(this.stringValue(), other.stringValue()) && this.hasStringListValue() == other.hasStringListValue() && Objects.equals(this.stringListValue(), other.stringListValue()) && Objects.equals(this.longValue(), other.longValue()) && Objects.equals(this.dateValue(), other.dateValue());
    }

    public final String toString() {
        return ToString.builder((String)"DocumentAttributeValue").add("StringValue", (Object)this.stringValue()).add("StringListValue", this.hasStringListValue() ? this.stringListValue() : null).add("LongValue", (Object)this.longValue()).add("DateValue", (Object)this.dateValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StringValue": {
                return Optional.ofNullable(clazz.cast(this.stringValue()));
            }
            case "StringListValue": {
                return Optional.ofNullable(clazz.cast(this.stringListValue()));
            }
            case "LongValue": {
                return Optional.ofNullable(clazz.cast(this.longValue()));
            }
            case "DateValue": {
                return Optional.ofNullable(clazz.cast(this.dateValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentAttributeValue, T> g) {
        return obj -> g.apply((DocumentAttributeValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stringValue;
        private List<String> stringListValue = DefaultSdkAutoConstructList.getInstance();
        private Long longValue;
        private Instant dateValue;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentAttributeValue model) {
            this.stringValue(model.stringValue);
            this.stringListValue(model.stringListValue);
            this.longValue(model.longValue);
            this.dateValue(model.dateValue);
        }

        public final String getStringValue() {
            return this.stringValue;
        }

        @Override
        public final Builder stringValue(String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        public final void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }

        public final Collection<String> getStringListValue() {
            if (this.stringListValue instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stringListValue;
        }

        @Override
        public final Builder stringListValue(Collection<String> stringListValue) {
            this.stringListValue = DocumentAttributeStringListValueCopier.copy(stringListValue);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringListValue(String ... stringListValue) {
            this.stringListValue(Arrays.asList(stringListValue));
            return this;
        }

        public final void setStringListValue(Collection<String> stringListValue) {
            this.stringListValue = DocumentAttributeStringListValueCopier.copy(stringListValue);
        }

        public final Long getLongValue() {
            return this.longValue;
        }

        @Override
        public final Builder longValue(Long longValue) {
            this.longValue = longValue;
            return this;
        }

        public final void setLongValue(Long longValue) {
            this.longValue = longValue;
        }

        public final Instant getDateValue() {
            return this.dateValue;
        }

        @Override
        public final Builder dateValue(Instant dateValue) {
            this.dateValue = dateValue;
            return this;
        }

        public final void setDateValue(Instant dateValue) {
            this.dateValue = dateValue;
        }

        public DocumentAttributeValue build() {
            return new DocumentAttributeValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentAttributeValue> {
        public Builder stringValue(String var1);

        public Builder stringListValue(Collection<String> var1);

        public Builder stringListValue(String ... var1);

        public Builder longValue(Long var1);

        public Builder dateValue(Instant var1);
    }
}

