/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kendra.model.AdditionalResultAttributeValue;
import software.amazon.awssdk.services.kendra.model.AdditionalResultAttributeValueType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdditionalResultAttribute
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AdditionalResultAttribute> {
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(AdditionalResultAttribute.getter(AdditionalResultAttribute::key)).setter(AdditionalResultAttribute.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()}).build();
    private static final SdkField<String> VALUE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValueType").getter(AdditionalResultAttribute.getter(AdditionalResultAttribute::valueTypeAsString)).setter(AdditionalResultAttribute.setter(Builder::valueType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueType").build()}).build();
    private static final SdkField<AdditionalResultAttributeValue> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Value").getter(AdditionalResultAttribute.getter(AdditionalResultAttribute::value)).setter(AdditionalResultAttribute.setter(Builder::value)).constructor(AdditionalResultAttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUE_TYPE_FIELD, VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String key;
    private final String valueType;
    private final AdditionalResultAttributeValue value;

    private AdditionalResultAttribute(BuilderImpl builder) {
        this.key = builder.key;
        this.valueType = builder.valueType;
        this.value = builder.value;
    }

    public String key() {
        return this.key;
    }

    public AdditionalResultAttributeValueType valueType() {
        return AdditionalResultAttributeValueType.fromValue(this.valueType);
    }

    public String valueTypeAsString() {
        return this.valueType;
    }

    public AdditionalResultAttributeValue value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdditionalResultAttribute)) {
            return false;
        }
        AdditionalResultAttribute other = (AdditionalResultAttribute)obj;
        return Objects.equals(this.key(), other.key()) && Objects.equals(this.valueTypeAsString(), other.valueTypeAsString()) && Objects.equals(this.value(), other.value());
    }

    public String toString() {
        return ToString.builder((String)"AdditionalResultAttribute").add("Key", (Object)this.key()).add("ValueType", (Object)this.valueTypeAsString()).add("Value", (Object)this.value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "ValueType": {
                return Optional.ofNullable(clazz.cast(this.valueTypeAsString()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdditionalResultAttribute, T> g) {
        return obj -> g.apply((AdditionalResultAttribute)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String key;
        private String valueType;
        private AdditionalResultAttributeValue value;

        private BuilderImpl() {
        }

        private BuilderImpl(AdditionalResultAttribute model) {
            this.key(model.key);
            this.valueType(model.valueType);
            this.value(model.value);
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getValueType() {
            return this.valueType;
        }

        @Override
        public final Builder valueType(String valueType) {
            this.valueType = valueType;
            return this;
        }

        @Override
        public final Builder valueType(AdditionalResultAttributeValueType valueType) {
            this.valueType(valueType == null ? null : valueType.toString());
            return this;
        }

        public final void setValueType(String valueType) {
            this.valueType = valueType;
        }

        public final AdditionalResultAttributeValue.Builder getValue() {
            return this.value != null ? this.value.toBuilder() : null;
        }

        @Override
        public final Builder value(AdditionalResultAttributeValue value) {
            this.value = value;
            return this;
        }

        public final void setValue(AdditionalResultAttributeValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        public AdditionalResultAttribute build() {
            return new AdditionalResultAttribute(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AdditionalResultAttribute> {
        public Builder key(String var1);

        public Builder valueType(String var1);

        public Builder valueType(AdditionalResultAttributeValueType var1);

        public Builder value(AdditionalResultAttributeValue var1);

        default public Builder value(Consumer<AdditionalResultAttributeValue.Builder> value) {
            return this.value((AdditionalResultAttributeValue)((AdditionalResultAttributeValue.Builder)AdditionalResultAttributeValue.builder().applyMutation(value)).build());
        }
    }
}

