/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.AccessControlListConfiguration;
import software.amazon.awssdk.services.kendra.model.DataSourceInclusionsExclusionsStringsCopier;
import software.amazon.awssdk.services.kendra.model.DocumentsMetadataConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3DataSourceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3DataSourceConfiguration> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketName").getter(S3DataSourceConfiguration.getter(S3DataSourceConfiguration::bucketName)).setter(S3DataSourceConfiguration.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketName").build()}).build();
    private static final SdkField<List<String>> INCLUSION_PREFIXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InclusionPrefixes").getter(S3DataSourceConfiguration.getter(S3DataSourceConfiguration::inclusionPrefixes)).setter(S3DataSourceConfiguration.setter(Builder::inclusionPrefixes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionPrefixes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INCLUSION_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InclusionPatterns").getter(S3DataSourceConfiguration.getter(S3DataSourceConfiguration::inclusionPatterns)).setter(S3DataSourceConfiguration.setter(Builder::inclusionPatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionPatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUSION_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExclusionPatterns").getter(S3DataSourceConfiguration.getter(S3DataSourceConfiguration::exclusionPatterns)).setter(S3DataSourceConfiguration.setter(Builder::exclusionPatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusionPatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DocumentsMetadataConfiguration> DOCUMENTS_METADATA_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DocumentsMetadataConfiguration").getter(S3DataSourceConfiguration.getter(S3DataSourceConfiguration::documentsMetadataConfiguration)).setter(S3DataSourceConfiguration.setter(Builder::documentsMetadataConfiguration)).constructor(DocumentsMetadataConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentsMetadataConfiguration").build()}).build();
    private static final SdkField<AccessControlListConfiguration> ACCESS_CONTROL_LIST_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccessControlListConfiguration").getter(S3DataSourceConfiguration.getter(S3DataSourceConfiguration::accessControlListConfiguration)).setter(S3DataSourceConfiguration.setter(Builder::accessControlListConfiguration)).constructor(AccessControlListConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessControlListConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD, INCLUSION_PREFIXES_FIELD, INCLUSION_PATTERNS_FIELD, EXCLUSION_PATTERNS_FIELD, DOCUMENTS_METADATA_CONFIGURATION_FIELD, ACCESS_CONTROL_LIST_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String bucketName;
    private final List<String> inclusionPrefixes;
    private final List<String> inclusionPatterns;
    private final List<String> exclusionPatterns;
    private final DocumentsMetadataConfiguration documentsMetadataConfiguration;
    private final AccessControlListConfiguration accessControlListConfiguration;

    private S3DataSourceConfiguration(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.inclusionPrefixes = builder.inclusionPrefixes;
        this.inclusionPatterns = builder.inclusionPatterns;
        this.exclusionPatterns = builder.exclusionPatterns;
        this.documentsMetadataConfiguration = builder.documentsMetadataConfiguration;
        this.accessControlListConfiguration = builder.accessControlListConfiguration;
    }

    public String bucketName() {
        return this.bucketName;
    }

    public boolean hasInclusionPrefixes() {
        return this.inclusionPrefixes != null && !(this.inclusionPrefixes instanceof SdkAutoConstructList);
    }

    public List<String> inclusionPrefixes() {
        return this.inclusionPrefixes;
    }

    public boolean hasInclusionPatterns() {
        return this.inclusionPatterns != null && !(this.inclusionPatterns instanceof SdkAutoConstructList);
    }

    public List<String> inclusionPatterns() {
        return this.inclusionPatterns;
    }

    public boolean hasExclusionPatterns() {
        return this.exclusionPatterns != null && !(this.exclusionPatterns instanceof SdkAutoConstructList);
    }

    public List<String> exclusionPatterns() {
        return this.exclusionPatterns;
    }

    public DocumentsMetadataConfiguration documentsMetadataConfiguration() {
        return this.documentsMetadataConfiguration;
    }

    public AccessControlListConfiguration accessControlListConfiguration() {
        return this.accessControlListConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInclusionPrefixes() ? this.inclusionPrefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInclusionPatterns() ? this.inclusionPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExclusionPatterns() ? this.exclusionPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.documentsMetadataConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessControlListConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DataSourceConfiguration)) {
            return false;
        }
        S3DataSourceConfiguration other = (S3DataSourceConfiguration)obj;
        return Objects.equals(this.bucketName(), other.bucketName()) && this.hasInclusionPrefixes() == other.hasInclusionPrefixes() && Objects.equals(this.inclusionPrefixes(), other.inclusionPrefixes()) && this.hasInclusionPatterns() == other.hasInclusionPatterns() && Objects.equals(this.inclusionPatterns(), other.inclusionPatterns()) && this.hasExclusionPatterns() == other.hasExclusionPatterns() && Objects.equals(this.exclusionPatterns(), other.exclusionPatterns()) && Objects.equals(this.documentsMetadataConfiguration(), other.documentsMetadataConfiguration()) && Objects.equals(this.accessControlListConfiguration(), other.accessControlListConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"S3DataSourceConfiguration").add("BucketName", (Object)this.bucketName()).add("InclusionPrefixes", this.hasInclusionPrefixes() ? this.inclusionPrefixes() : null).add("InclusionPatterns", this.hasInclusionPatterns() ? this.inclusionPatterns() : null).add("ExclusionPatterns", this.hasExclusionPatterns() ? this.exclusionPatterns() : null).add("DocumentsMetadataConfiguration", (Object)this.documentsMetadataConfiguration()).add("AccessControlListConfiguration", (Object)this.accessControlListConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "InclusionPrefixes": {
                return Optional.ofNullable(clazz.cast(this.inclusionPrefixes()));
            }
            case "InclusionPatterns": {
                return Optional.ofNullable(clazz.cast(this.inclusionPatterns()));
            }
            case "ExclusionPatterns": {
                return Optional.ofNullable(clazz.cast(this.exclusionPatterns()));
            }
            case "DocumentsMetadataConfiguration": {
                return Optional.ofNullable(clazz.cast(this.documentsMetadataConfiguration()));
            }
            case "AccessControlListConfiguration": {
                return Optional.ofNullable(clazz.cast(this.accessControlListConfiguration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3DataSourceConfiguration, T> g) {
        return obj -> g.apply((S3DataSourceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucketName;
        private List<String> inclusionPrefixes = DefaultSdkAutoConstructList.getInstance();
        private List<String> inclusionPatterns = DefaultSdkAutoConstructList.getInstance();
        private List<String> exclusionPatterns = DefaultSdkAutoConstructList.getInstance();
        private DocumentsMetadataConfiguration documentsMetadataConfiguration;
        private AccessControlListConfiguration accessControlListConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(S3DataSourceConfiguration model) {
            this.bucketName(model.bucketName);
            this.inclusionPrefixes(model.inclusionPrefixes);
            this.inclusionPatterns(model.inclusionPatterns);
            this.exclusionPatterns(model.exclusionPatterns);
            this.documentsMetadataConfiguration(model.documentsMetadataConfiguration);
            this.accessControlListConfiguration(model.accessControlListConfiguration);
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final Collection<String> getInclusionPrefixes() {
            if (this.inclusionPrefixes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inclusionPrefixes;
        }

        @Override
        public final Builder inclusionPrefixes(Collection<String> inclusionPrefixes) {
            this.inclusionPrefixes = DataSourceInclusionsExclusionsStringsCopier.copy(inclusionPrefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionPrefixes(String ... inclusionPrefixes) {
            this.inclusionPrefixes(Arrays.asList(inclusionPrefixes));
            return this;
        }

        public final void setInclusionPrefixes(Collection<String> inclusionPrefixes) {
            this.inclusionPrefixes = DataSourceInclusionsExclusionsStringsCopier.copy(inclusionPrefixes);
        }

        public final Collection<String> getInclusionPatterns() {
            if (this.inclusionPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inclusionPatterns;
        }

        @Override
        public final Builder inclusionPatterns(Collection<String> inclusionPatterns) {
            this.inclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(inclusionPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionPatterns(String ... inclusionPatterns) {
            this.inclusionPatterns(Arrays.asList(inclusionPatterns));
            return this;
        }

        public final void setInclusionPatterns(Collection<String> inclusionPatterns) {
            this.inclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(inclusionPatterns);
        }

        public final Collection<String> getExclusionPatterns() {
            if (this.exclusionPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exclusionPatterns;
        }

        @Override
        public final Builder exclusionPatterns(Collection<String> exclusionPatterns) {
            this.exclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(exclusionPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionPatterns(String ... exclusionPatterns) {
            this.exclusionPatterns(Arrays.asList(exclusionPatterns));
            return this;
        }

        public final void setExclusionPatterns(Collection<String> exclusionPatterns) {
            this.exclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(exclusionPatterns);
        }

        public final DocumentsMetadataConfiguration.Builder getDocumentsMetadataConfiguration() {
            return this.documentsMetadataConfiguration != null ? this.documentsMetadataConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder documentsMetadataConfiguration(DocumentsMetadataConfiguration documentsMetadataConfiguration) {
            this.documentsMetadataConfiguration = documentsMetadataConfiguration;
            return this;
        }

        public final void setDocumentsMetadataConfiguration(DocumentsMetadataConfiguration.BuilderImpl documentsMetadataConfiguration) {
            this.documentsMetadataConfiguration = documentsMetadataConfiguration != null ? documentsMetadataConfiguration.build() : null;
        }

        public final AccessControlListConfiguration.Builder getAccessControlListConfiguration() {
            return this.accessControlListConfiguration != null ? this.accessControlListConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder accessControlListConfiguration(AccessControlListConfiguration accessControlListConfiguration) {
            this.accessControlListConfiguration = accessControlListConfiguration;
            return this;
        }

        public final void setAccessControlListConfiguration(AccessControlListConfiguration.BuilderImpl accessControlListConfiguration) {
            this.accessControlListConfiguration = accessControlListConfiguration != null ? accessControlListConfiguration.build() : null;
        }

        public S3DataSourceConfiguration build() {
            return new S3DataSourceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3DataSourceConfiguration> {
        public Builder bucketName(String var1);

        public Builder inclusionPrefixes(Collection<String> var1);

        public Builder inclusionPrefixes(String ... var1);

        public Builder inclusionPatterns(Collection<String> var1);

        public Builder inclusionPatterns(String ... var1);

        public Builder exclusionPatterns(Collection<String> var1);

        public Builder exclusionPatterns(String ... var1);

        public Builder documentsMetadataConfiguration(DocumentsMetadataConfiguration var1);

        default public Builder documentsMetadataConfiguration(Consumer<DocumentsMetadataConfiguration.Builder> documentsMetadataConfiguration) {
            return this.documentsMetadataConfiguration((DocumentsMetadataConfiguration)((DocumentsMetadataConfiguration.Builder)DocumentsMetadataConfiguration.builder().applyMutation(documentsMetadataConfiguration)).build());
        }

        public Builder accessControlListConfiguration(AccessControlListConfiguration var1);

        default public Builder accessControlListConfiguration(Consumer<AccessControlListConfiguration.Builder> accessControlListConfiguration) {
            return this.accessControlListConfiguration((AccessControlListConfiguration)((AccessControlListConfiguration.Builder)AccessControlListConfiguration.builder().applyMutation(accessControlListConfiguration)).build());
        }
    }
}

