/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.AttributeFilter;
import software.amazon.awssdk.services.kendra.model.DocumentAttributeKeyListCopier;
import software.amazon.awssdk.services.kendra.model.Facet;
import software.amazon.awssdk.services.kendra.model.FacetListCopier;
import software.amazon.awssdk.services.kendra.model.KendraRequest;
import software.amazon.awssdk.services.kendra.model.QueryResultType;
import software.amazon.awssdk.services.kendra.model.SortingConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryRequest
extends KendraRequest
implements ToCopyableBuilder<Builder, QueryRequest> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexId").getter(QueryRequest.getter(QueryRequest::indexId)).setter(QueryRequest.setter(Builder::indexId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()}).build();
    private static final SdkField<String> QUERY_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryText").getter(QueryRequest.getter(QueryRequest::queryText)).setter(QueryRequest.setter(Builder::queryText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryText").build()}).build();
    private static final SdkField<AttributeFilter> ATTRIBUTE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AttributeFilter").getter(QueryRequest.getter(QueryRequest::attributeFilter)).setter(QueryRequest.setter(Builder::attributeFilter)).constructor(AttributeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeFilter").build()}).build();
    private static final SdkField<List<Facet>> FACETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Facets").getter(QueryRequest.getter(QueryRequest::facets)).setter(QueryRequest.setter(Builder::facets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Facets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Facet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REQUESTED_DOCUMENT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RequestedDocumentAttributes").getter(QueryRequest.getter(QueryRequest::requestedDocumentAttributes)).setter(QueryRequest.setter(Builder::requestedDocumentAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedDocumentAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> QUERY_RESULT_TYPE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryResultTypeFilter").getter(QueryRequest.getter(QueryRequest::queryResultTypeFilterAsString)).setter(QueryRequest.setter(Builder::queryResultTypeFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryResultTypeFilter").build()}).build();
    private static final SdkField<Integer> PAGE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PageNumber").getter(QueryRequest.getter(QueryRequest::pageNumber)).setter(QueryRequest.setter(Builder::pageNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageNumber").build()}).build();
    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PageSize").getter(QueryRequest.getter(QueryRequest::pageSize)).setter(QueryRequest.setter(Builder::pageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()}).build();
    private static final SdkField<SortingConfiguration> SORTING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SortingConfiguration").getter(QueryRequest.getter(QueryRequest::sortingConfiguration)).setter(QueryRequest.setter(Builder::sortingConfiguration)).constructor(SortingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortingConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD, QUERY_TEXT_FIELD, ATTRIBUTE_FILTER_FIELD, FACETS_FIELD, REQUESTED_DOCUMENT_ATTRIBUTES_FIELD, QUERY_RESULT_TYPE_FILTER_FIELD, PAGE_NUMBER_FIELD, PAGE_SIZE_FIELD, SORTING_CONFIGURATION_FIELD));
    private final String indexId;
    private final String queryText;
    private final AttributeFilter attributeFilter;
    private final List<Facet> facets;
    private final List<String> requestedDocumentAttributes;
    private final String queryResultTypeFilter;
    private final Integer pageNumber;
    private final Integer pageSize;
    private final SortingConfiguration sortingConfiguration;

    private QueryRequest(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.queryText = builder.queryText;
        this.attributeFilter = builder.attributeFilter;
        this.facets = builder.facets;
        this.requestedDocumentAttributes = builder.requestedDocumentAttributes;
        this.queryResultTypeFilter = builder.queryResultTypeFilter;
        this.pageNumber = builder.pageNumber;
        this.pageSize = builder.pageSize;
        this.sortingConfiguration = builder.sortingConfiguration;
    }

    public String indexId() {
        return this.indexId;
    }

    public String queryText() {
        return this.queryText;
    }

    public AttributeFilter attributeFilter() {
        return this.attributeFilter;
    }

    public boolean hasFacets() {
        return this.facets != null && !(this.facets instanceof SdkAutoConstructList);
    }

    public List<Facet> facets() {
        return this.facets;
    }

    public boolean hasRequestedDocumentAttributes() {
        return this.requestedDocumentAttributes != null && !(this.requestedDocumentAttributes instanceof SdkAutoConstructList);
    }

    public List<String> requestedDocumentAttributes() {
        return this.requestedDocumentAttributes;
    }

    public QueryResultType queryResultTypeFilter() {
        return QueryResultType.fromValue(this.queryResultTypeFilter);
    }

    public String queryResultTypeFilterAsString() {
        return this.queryResultTypeFilter;
    }

    public Integer pageNumber() {
        return this.pageNumber;
    }

    public Integer pageSize() {
        return this.pageSize;
    }

    public SortingConfiguration sortingConfiguration() {
        return this.sortingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.indexId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryText());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.facets());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedDocumentAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryResultTypeFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortingConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryRequest)) {
            return false;
        }
        QueryRequest other = (QueryRequest)((Object)obj);
        return Objects.equals(this.indexId(), other.indexId()) && Objects.equals(this.queryText(), other.queryText()) && Objects.equals(this.attributeFilter(), other.attributeFilter()) && Objects.equals(this.facets(), other.facets()) && Objects.equals(this.requestedDocumentAttributes(), other.requestedDocumentAttributes()) && Objects.equals(this.queryResultTypeFilterAsString(), other.queryResultTypeFilterAsString()) && Objects.equals(this.pageNumber(), other.pageNumber()) && Objects.equals(this.pageSize(), other.pageSize()) && Objects.equals(this.sortingConfiguration(), other.sortingConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"QueryRequest").add("IndexId", (Object)this.indexId()).add("QueryText", (Object)this.queryText()).add("AttributeFilter", (Object)this.attributeFilter()).add("Facets", this.facets()).add("RequestedDocumentAttributes", this.requestedDocumentAttributes()).add("QueryResultTypeFilter", (Object)this.queryResultTypeFilterAsString()).add("PageNumber", (Object)this.pageNumber()).add("PageSize", (Object)this.pageSize()).add("SortingConfiguration", (Object)this.sortingConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexId": {
                return Optional.ofNullable(clazz.cast(this.indexId()));
            }
            case "QueryText": {
                return Optional.ofNullable(clazz.cast(this.queryText()));
            }
            case "AttributeFilter": {
                return Optional.ofNullable(clazz.cast(this.attributeFilter()));
            }
            case "Facets": {
                return Optional.ofNullable(clazz.cast(this.facets()));
            }
            case "RequestedDocumentAttributes": {
                return Optional.ofNullable(clazz.cast(this.requestedDocumentAttributes()));
            }
            case "QueryResultTypeFilter": {
                return Optional.ofNullable(clazz.cast(this.queryResultTypeFilterAsString()));
            }
            case "PageNumber": {
                return Optional.ofNullable(clazz.cast(this.pageNumber()));
            }
            case "PageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
            case "SortingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sortingConfiguration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryRequest, T> g) {
        return obj -> g.apply((QueryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraRequest.BuilderImpl
    implements Builder {
        private String indexId;
        private String queryText;
        private AttributeFilter attributeFilter;
        private List<Facet> facets = DefaultSdkAutoConstructList.getInstance();
        private List<String> requestedDocumentAttributes = DefaultSdkAutoConstructList.getInstance();
        private String queryResultTypeFilter;
        private Integer pageNumber;
        private Integer pageSize;
        private SortingConfiguration sortingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryRequest model) {
            super(model);
            this.indexId(model.indexId);
            this.queryText(model.queryText);
            this.attributeFilter(model.attributeFilter);
            this.facets(model.facets);
            this.requestedDocumentAttributes(model.requestedDocumentAttributes);
            this.queryResultTypeFilter(model.queryResultTypeFilter);
            this.pageNumber(model.pageNumber);
            this.pageSize(model.pageSize);
            this.sortingConfiguration(model.sortingConfiguration);
        }

        public final String getIndexId() {
            return this.indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        public final String getQueryText() {
            return this.queryText;
        }

        @Override
        public final Builder queryText(String queryText) {
            this.queryText = queryText;
            return this;
        }

        public final void setQueryText(String queryText) {
            this.queryText = queryText;
        }

        public final AttributeFilter.Builder getAttributeFilter() {
            return this.attributeFilter != null ? this.attributeFilter.toBuilder() : null;
        }

        @Override
        public final Builder attributeFilter(AttributeFilter attributeFilter) {
            this.attributeFilter = attributeFilter;
            return this;
        }

        public final void setAttributeFilter(AttributeFilter.BuilderImpl attributeFilter) {
            this.attributeFilter = attributeFilter != null ? attributeFilter.build() : null;
        }

        public final Collection<Facet.Builder> getFacets() {
            return this.facets != null ? (Collection)this.facets.stream().map(Facet::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder facets(Collection<Facet> facets) {
            this.facets = FacetListCopier.copy(facets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder facets(Facet ... facets) {
            this.facets(Arrays.asList(facets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder facets(Consumer<Facet.Builder> ... facets) {
            this.facets(Stream.of(facets).map(c -> (Facet)((Facet.Builder)Facet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFacets(Collection<Facet.BuilderImpl> facets) {
            this.facets = FacetListCopier.copyFromBuilder(facets);
        }

        public final Collection<String> getRequestedDocumentAttributes() {
            return this.requestedDocumentAttributes;
        }

        @Override
        public final Builder requestedDocumentAttributes(Collection<String> requestedDocumentAttributes) {
            this.requestedDocumentAttributes = DocumentAttributeKeyListCopier.copy(requestedDocumentAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestedDocumentAttributes(String ... requestedDocumentAttributes) {
            this.requestedDocumentAttributes(Arrays.asList(requestedDocumentAttributes));
            return this;
        }

        public final void setRequestedDocumentAttributes(Collection<String> requestedDocumentAttributes) {
            this.requestedDocumentAttributes = DocumentAttributeKeyListCopier.copy(requestedDocumentAttributes);
        }

        public final String getQueryResultTypeFilter() {
            return this.queryResultTypeFilter;
        }

        @Override
        public final Builder queryResultTypeFilter(String queryResultTypeFilter) {
            this.queryResultTypeFilter = queryResultTypeFilter;
            return this;
        }

        @Override
        public final Builder queryResultTypeFilter(QueryResultType queryResultTypeFilter) {
            this.queryResultTypeFilter(queryResultTypeFilter == null ? null : queryResultTypeFilter.toString());
            return this;
        }

        public final void setQueryResultTypeFilter(String queryResultTypeFilter) {
            this.queryResultTypeFilter = queryResultTypeFilter;
        }

        public final Integer getPageNumber() {
            return this.pageNumber;
        }

        @Override
        public final Builder pageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public final void setPageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public final SortingConfiguration.Builder getSortingConfiguration() {
            return this.sortingConfiguration != null ? this.sortingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder sortingConfiguration(SortingConfiguration sortingConfiguration) {
            this.sortingConfiguration = sortingConfiguration;
            return this;
        }

        public final void setSortingConfiguration(SortingConfiguration.BuilderImpl sortingConfiguration) {
            this.sortingConfiguration = sortingConfiguration != null ? sortingConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public QueryRequest build() {
            return new QueryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KendraRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, QueryRequest> {
        public Builder indexId(String var1);

        public Builder queryText(String var1);

        public Builder attributeFilter(AttributeFilter var1);

        default public Builder attributeFilter(Consumer<AttributeFilter.Builder> attributeFilter) {
            return this.attributeFilter((AttributeFilter)((AttributeFilter.Builder)AttributeFilter.builder().applyMutation(attributeFilter)).build());
        }

        public Builder facets(Collection<Facet> var1);

        public Builder facets(Facet ... var1);

        public Builder facets(Consumer<Facet.Builder> ... var1);

        public Builder requestedDocumentAttributes(Collection<String> var1);

        public Builder requestedDocumentAttributes(String ... var1);

        public Builder queryResultTypeFilter(String var1);

        public Builder queryResultTypeFilter(QueryResultType var1);

        public Builder pageNumber(Integer var1);

        public Builder pageSize(Integer var1);

        public Builder sortingConfiguration(SortingConfiguration var1);

        default public Builder sortingConfiguration(Consumer<SortingConfiguration.Builder> sortingConfiguration) {
            return this.sortingConfiguration((SortingConfiguration)((SortingConfiguration.Builder)SortingConfiguration.builder().applyMutation(sortingConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

