/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kendra.model.ServiceNowBuildVersionType;
import software.amazon.awssdk.services.kendra.model.ServiceNowKnowledgeArticleConfiguration;
import software.amazon.awssdk.services.kendra.model.ServiceNowServiceCatalogConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceNowConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceNowConfiguration> {
    private static final SdkField<String> HOST_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostUrl").getter(ServiceNowConfiguration.getter(ServiceNowConfiguration::hostUrl)).setter(ServiceNowConfiguration.setter(Builder::hostUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostUrl").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretArn").getter(ServiceNowConfiguration.getter(ServiceNowConfiguration::secretArn)).setter(ServiceNowConfiguration.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()}).build();
    private static final SdkField<String> SERVICE_NOW_BUILD_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceNowBuildVersion").getter(ServiceNowConfiguration.getter(ServiceNowConfiguration::serviceNowBuildVersionAsString)).setter(ServiceNowConfiguration.setter(Builder::serviceNowBuildVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNowBuildVersion").build()}).build();
    private static final SdkField<ServiceNowKnowledgeArticleConfiguration> KNOWLEDGE_ARTICLE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KnowledgeArticleConfiguration").getter(ServiceNowConfiguration.getter(ServiceNowConfiguration::knowledgeArticleConfiguration)).setter(ServiceNowConfiguration.setter(Builder::knowledgeArticleConfiguration)).constructor(ServiceNowKnowledgeArticleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KnowledgeArticleConfiguration").build()}).build();
    private static final SdkField<ServiceNowServiceCatalogConfiguration> SERVICE_CATALOG_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServiceCatalogConfiguration").getter(ServiceNowConfiguration.getter(ServiceNowConfiguration::serviceCatalogConfiguration)).setter(ServiceNowConfiguration.setter(Builder::serviceCatalogConfiguration)).constructor(ServiceNowServiceCatalogConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCatalogConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_URL_FIELD, SECRET_ARN_FIELD, SERVICE_NOW_BUILD_VERSION_FIELD, KNOWLEDGE_ARTICLE_CONFIGURATION_FIELD, SERVICE_CATALOG_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String hostUrl;
    private final String secretArn;
    private final String serviceNowBuildVersion;
    private final ServiceNowKnowledgeArticleConfiguration knowledgeArticleConfiguration;
    private final ServiceNowServiceCatalogConfiguration serviceCatalogConfiguration;

    private ServiceNowConfiguration(BuilderImpl builder) {
        this.hostUrl = builder.hostUrl;
        this.secretArn = builder.secretArn;
        this.serviceNowBuildVersion = builder.serviceNowBuildVersion;
        this.knowledgeArticleConfiguration = builder.knowledgeArticleConfiguration;
        this.serviceCatalogConfiguration = builder.serviceCatalogConfiguration;
    }

    public String hostUrl() {
        return this.hostUrl;
    }

    public String secretArn() {
        return this.secretArn;
    }

    public ServiceNowBuildVersionType serviceNowBuildVersion() {
        return ServiceNowBuildVersionType.fromValue(this.serviceNowBuildVersion);
    }

    public String serviceNowBuildVersionAsString() {
        return this.serviceNowBuildVersion;
    }

    public ServiceNowKnowledgeArticleConfiguration knowledgeArticleConfiguration() {
        return this.knowledgeArticleConfiguration;
    }

    public ServiceNowServiceCatalogConfiguration serviceCatalogConfiguration() {
        return this.serviceCatalogConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNowBuildVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeArticleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceCatalogConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceNowConfiguration)) {
            return false;
        }
        ServiceNowConfiguration other = (ServiceNowConfiguration)obj;
        return Objects.equals(this.hostUrl(), other.hostUrl()) && Objects.equals(this.secretArn(), other.secretArn()) && Objects.equals(this.serviceNowBuildVersionAsString(), other.serviceNowBuildVersionAsString()) && Objects.equals(this.knowledgeArticleConfiguration(), other.knowledgeArticleConfiguration()) && Objects.equals(this.serviceCatalogConfiguration(), other.serviceCatalogConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"ServiceNowConfiguration").add("HostUrl", (Object)this.hostUrl()).add("SecretArn", (Object)this.secretArn()).add("ServiceNowBuildVersion", (Object)this.serviceNowBuildVersionAsString()).add("KnowledgeArticleConfiguration", (Object)this.knowledgeArticleConfiguration()).add("ServiceCatalogConfiguration", (Object)this.serviceCatalogConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostUrl": {
                return Optional.ofNullable(clazz.cast(this.hostUrl()));
            }
            case "SecretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
            case "ServiceNowBuildVersion": {
                return Optional.ofNullable(clazz.cast(this.serviceNowBuildVersionAsString()));
            }
            case "KnowledgeArticleConfiguration": {
                return Optional.ofNullable(clazz.cast(this.knowledgeArticleConfiguration()));
            }
            case "ServiceCatalogConfiguration": {
                return Optional.ofNullable(clazz.cast(this.serviceCatalogConfiguration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceNowConfiguration, T> g) {
        return obj -> g.apply((ServiceNowConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String hostUrl;
        private String secretArn;
        private String serviceNowBuildVersion;
        private ServiceNowKnowledgeArticleConfiguration knowledgeArticleConfiguration;
        private ServiceNowServiceCatalogConfiguration serviceCatalogConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceNowConfiguration model) {
            this.hostUrl(model.hostUrl);
            this.secretArn(model.secretArn);
            this.serviceNowBuildVersion(model.serviceNowBuildVersion);
            this.knowledgeArticleConfiguration(model.knowledgeArticleConfiguration);
            this.serviceCatalogConfiguration(model.serviceCatalogConfiguration);
        }

        public final String getHostUrl() {
            return this.hostUrl;
        }

        @Override
        public final Builder hostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
            return this;
        }

        public final void setHostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        public final String getServiceNowBuildVersion() {
            return this.serviceNowBuildVersion;
        }

        @Override
        public final Builder serviceNowBuildVersion(String serviceNowBuildVersion) {
            this.serviceNowBuildVersion = serviceNowBuildVersion;
            return this;
        }

        @Override
        public final Builder serviceNowBuildVersion(ServiceNowBuildVersionType serviceNowBuildVersion) {
            this.serviceNowBuildVersion(serviceNowBuildVersion == null ? null : serviceNowBuildVersion.toString());
            return this;
        }

        public final void setServiceNowBuildVersion(String serviceNowBuildVersion) {
            this.serviceNowBuildVersion = serviceNowBuildVersion;
        }

        public final ServiceNowKnowledgeArticleConfiguration.Builder getKnowledgeArticleConfiguration() {
            return this.knowledgeArticleConfiguration != null ? this.knowledgeArticleConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder knowledgeArticleConfiguration(ServiceNowKnowledgeArticleConfiguration knowledgeArticleConfiguration) {
            this.knowledgeArticleConfiguration = knowledgeArticleConfiguration;
            return this;
        }

        public final void setKnowledgeArticleConfiguration(ServiceNowKnowledgeArticleConfiguration.BuilderImpl knowledgeArticleConfiguration) {
            this.knowledgeArticleConfiguration = knowledgeArticleConfiguration != null ? knowledgeArticleConfiguration.build() : null;
        }

        public final ServiceNowServiceCatalogConfiguration.Builder getServiceCatalogConfiguration() {
            return this.serviceCatalogConfiguration != null ? this.serviceCatalogConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder serviceCatalogConfiguration(ServiceNowServiceCatalogConfiguration serviceCatalogConfiguration) {
            this.serviceCatalogConfiguration = serviceCatalogConfiguration;
            return this;
        }

        public final void setServiceCatalogConfiguration(ServiceNowServiceCatalogConfiguration.BuilderImpl serviceCatalogConfiguration) {
            this.serviceCatalogConfiguration = serviceCatalogConfiguration != null ? serviceCatalogConfiguration.build() : null;
        }

        public ServiceNowConfiguration build() {
            return new ServiceNowConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceNowConfiguration> {
        public Builder hostUrl(String var1);

        public Builder secretArn(String var1);

        public Builder serviceNowBuildVersion(String var1);

        public Builder serviceNowBuildVersion(ServiceNowBuildVersionType var1);

        public Builder knowledgeArticleConfiguration(ServiceNowKnowledgeArticleConfiguration var1);

        default public Builder knowledgeArticleConfiguration(Consumer<ServiceNowKnowledgeArticleConfiguration.Builder> knowledgeArticleConfiguration) {
            return this.knowledgeArticleConfiguration((ServiceNowKnowledgeArticleConfiguration)((ServiceNowKnowledgeArticleConfiguration.Builder)ServiceNowKnowledgeArticleConfiguration.builder().applyMutation(knowledgeArticleConfiguration)).build());
        }

        public Builder serviceCatalogConfiguration(ServiceNowServiceCatalogConfiguration var1);

        default public Builder serviceCatalogConfiguration(Consumer<ServiceNowServiceCatalogConfiguration.Builder> serviceCatalogConfiguration) {
            return this.serviceCatalogConfiguration((ServiceNowServiceCatalogConfiguration)((ServiceNowServiceCatalogConfiguration.Builder)ServiceNowServiceCatalogConfiguration.builder().applyMutation(serviceCatalogConfiguration)).build());
        }
    }
}

