/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ScoreConfidence {
    VERY_HIGH("VERY_HIGH"),
    HIGH("HIGH"),
    MEDIUM("MEDIUM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ScoreConfidence(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScoreConfidence fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ScoreConfidence.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScoreConfidence> knownValues() {
        return Stream.of(ScoreConfidence.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

