/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kendra.model.DataSourceSyncJobStatus;
import software.amazon.awssdk.services.kendra.model.ErrorCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSourceSyncJob
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSourceSyncJob> {
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DataSourceSyncJob.getter(DataSourceSyncJob::executionId)).setter(DataSourceSyncJob.setter(Builder::executionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionId").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DataSourceSyncJob.getter(DataSourceSyncJob::startTime)).setter(DataSourceSyncJob.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DataSourceSyncJob.getter(DataSourceSyncJob::endTime)).setter(DataSourceSyncJob.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DataSourceSyncJob.getter(DataSourceSyncJob::statusAsString)).setter(DataSourceSyncJob.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DataSourceSyncJob.getter(DataSourceSyncJob::errorMessage)).setter(DataSourceSyncJob.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DataSourceSyncJob.getter(DataSourceSyncJob::errorCodeAsString)).setter(DataSourceSyncJob.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()}).build();
    private static final SdkField<String> DATA_SOURCE_ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DataSourceSyncJob.getter(DataSourceSyncJob::dataSourceErrorCode)).setter(DataSourceSyncJob.setter(Builder::dataSourceErrorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceErrorCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ID_FIELD, START_TIME_FIELD, END_TIME_FIELD, STATUS_FIELD, ERROR_MESSAGE_FIELD, ERROR_CODE_FIELD, DATA_SOURCE_ERROR_CODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String executionId;
    private final Instant startTime;
    private final Instant endTime;
    private final String status;
    private final String errorMessage;
    private final String errorCode;
    private final String dataSourceErrorCode;

    private DataSourceSyncJob(BuilderImpl builder) {
        this.executionId = builder.executionId;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.status = builder.status;
        this.errorMessage = builder.errorMessage;
        this.errorCode = builder.errorCode;
        this.dataSourceErrorCode = builder.dataSourceErrorCode;
    }

    public String executionId() {
        return this.executionId;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public DataSourceSyncJobStatus status() {
        return DataSourceSyncJobStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public ErrorCode errorCode() {
        return ErrorCode.fromValue(this.errorCode);
    }

    public String errorCodeAsString() {
        return this.errorCode;
    }

    public String dataSourceErrorCode() {
        return this.dataSourceErrorCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.executionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceErrorCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceSyncJob)) {
            return false;
        }
        DataSourceSyncJob other = (DataSourceSyncJob)obj;
        return Objects.equals(this.executionId(), other.executionId()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.errorCodeAsString(), other.errorCodeAsString()) && Objects.equals(this.dataSourceErrorCode(), other.dataSourceErrorCode());
    }

    public String toString() {
        return ToString.builder((String)"DataSourceSyncJob").add("ExecutionId", (Object)this.executionId()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Status", (Object)this.statusAsString()).add("ErrorMessage", (Object)this.errorMessage()).add("ErrorCode", (Object)this.errorCodeAsString()).add("DataSourceErrorCode", (Object)this.dataSourceErrorCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExecutionId": {
                return Optional.ofNullable(clazz.cast(this.executionId()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCodeAsString()));
            }
            case "DataSourceErrorCode": {
                return Optional.ofNullable(clazz.cast(this.dataSourceErrorCode()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSourceSyncJob, T> g) {
        return obj -> g.apply((DataSourceSyncJob)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String executionId;
        private Instant startTime;
        private Instant endTime;
        private String status;
        private String errorMessage;
        private String errorCode;
        private String dataSourceErrorCode;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceSyncJob model) {
            this.executionId(model.executionId);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.status(model.status);
            this.errorMessage(model.errorMessage);
            this.errorCode(model.errorCode);
            this.dataSourceErrorCode(model.dataSourceErrorCode);
        }

        public final String getExecutionId() {
            return this.executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataSourceSyncJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(ErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getDataSourceErrorCode() {
            return this.dataSourceErrorCode;
        }

        @Override
        public final Builder dataSourceErrorCode(String dataSourceErrorCode) {
            this.dataSourceErrorCode = dataSourceErrorCode;
            return this;
        }

        public final void setDataSourceErrorCode(String dataSourceErrorCode) {
            this.dataSourceErrorCode = dataSourceErrorCode;
        }

        public DataSourceSyncJob build() {
            return new DataSourceSyncJob(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSourceSyncJob> {
        public Builder executionId(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder status(String var1);

        public Builder status(DataSourceSyncJobStatus var1);

        public Builder errorMessage(String var1);

        public Builder errorCode(String var1);

        public Builder errorCode(ErrorCode var1);

        public Builder dataSourceErrorCode(String var1);
    }
}

