/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DataSourceType {
    S3("S3"),
    SHAREPOINT("SHAREPOINT"),
    DATABASE("DATABASE"),
    SALESFORCE("SALESFORCE"),
    ONEDRIVE("ONEDRIVE"),
    SERVICENOW("SERVICENOW"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DataSourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataSourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DataSourceType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataSourceType> knownValues() {
        return Stream.of(DataSourceType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

