/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DataSourceStatus {
    CREATING("CREATING"),
    DELETING("DELETING"),
    FAILED("FAILED"),
    UPDATING("UPDATING"),
    ACTIVE("ACTIVE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DataSourceStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataSourceStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DataSourceStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataSourceStatus> knownValues() {
        return Stream.of(DataSourceStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

