/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kendra.KendraClient;
import software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsRequest;
import software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsResponse;

public class ListDataSourceSyncJobsIterable
implements SdkIterable<ListDataSourceSyncJobsResponse> {
    private final KendraClient client;
    private final ListDataSourceSyncJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDataSourceSyncJobsIterable(KendraClient client, ListDataSourceSyncJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDataSourceSyncJobsResponseFetcher();
    }

    public Iterator<ListDataSourceSyncJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListDataSourceSyncJobsResponseFetcher
    implements SyncPageFetcher<ListDataSourceSyncJobsResponse> {
        private ListDataSourceSyncJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataSourceSyncJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDataSourceSyncJobsResponse nextPage(ListDataSourceSyncJobsResponse previousPage) {
            if (previousPage == null) {
                return ListDataSourceSyncJobsIterable.this.client.listDataSourceSyncJobs(ListDataSourceSyncJobsIterable.this.firstRequest);
            }
            return ListDataSourceSyncJobsIterable.this.client.listDataSourceSyncJobs((ListDataSourceSyncJobsRequest)((Object)ListDataSourceSyncJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

