/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TextDocumentStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TextDocumentStatistics> {
    private static final SdkField<Integer> INDEXED_TEXT_DOCUMENTS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(TextDocumentStatistics.getter(TextDocumentStatistics::indexedTextDocumentsCount)).setter(TextDocumentStatistics.setter(Builder::indexedTextDocumentsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexedTextDocumentsCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEXED_TEXT_DOCUMENTS_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer indexedTextDocumentsCount;

    private TextDocumentStatistics(BuilderImpl builder) {
        this.indexedTextDocumentsCount = builder.indexedTextDocumentsCount;
    }

    public Integer indexedTextDocumentsCount() {
        return this.indexedTextDocumentsCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.indexedTextDocumentsCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextDocumentStatistics)) {
            return false;
        }
        TextDocumentStatistics other = (TextDocumentStatistics)obj;
        return Objects.equals(this.indexedTextDocumentsCount(), other.indexedTextDocumentsCount());
    }

    public String toString() {
        return ToString.builder((String)"TextDocumentStatistics").add("IndexedTextDocumentsCount", (Object)this.indexedTextDocumentsCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexedTextDocumentsCount": {
                return Optional.ofNullable(clazz.cast(this.indexedTextDocumentsCount()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TextDocumentStatistics, T> g) {
        return obj -> g.apply((TextDocumentStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer indexedTextDocumentsCount;

        private BuilderImpl() {
        }

        private BuilderImpl(TextDocumentStatistics model) {
            this.indexedTextDocumentsCount(model.indexedTextDocumentsCount);
        }

        public final Integer getIndexedTextDocumentsCount() {
            return this.indexedTextDocumentsCount;
        }

        @Override
        public final Builder indexedTextDocumentsCount(Integer indexedTextDocumentsCount) {
            this.indexedTextDocumentsCount = indexedTextDocumentsCount;
            return this;
        }

        public final void setIndexedTextDocumentsCount(Integer indexedTextDocumentsCount) {
            this.indexedTextDocumentsCount = indexedTextDocumentsCount;
        }

        public TextDocumentStatistics build() {
            return new TextDocumentStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TextDocumentStatistics> {
        public Builder indexedTextDocumentsCount(Integer var1);
    }
}

