/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.DocumentMetadataConfiguration;
import software.amazon.awssdk.services.kendra.model.DocumentMetadataConfigurationListCopier;
import software.amazon.awssdk.services.kendra.model.KendraRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateIndexRequest
extends KendraRequest
implements ToCopyableBuilder<Builder, UpdateIndexRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateIndexRequest.getter(UpdateIndexRequest::id)).setter(UpdateIndexRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateIndexRequest.getter(UpdateIndexRequest::name)).setter(UpdateIndexRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateIndexRequest.getter(UpdateIndexRequest::roleArn)).setter(UpdateIndexRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateIndexRequest.getter(UpdateIndexRequest::description)).setter(UpdateIndexRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<DocumentMetadataConfiguration>> DOCUMENT_METADATA_CONFIGURATION_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateIndexRequest.getter(UpdateIndexRequest::documentMetadataConfigurationUpdates)).setter(UpdateIndexRequest.setter(Builder::documentMetadataConfigurationUpdates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentMetadataConfigurationUpdates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentMetadataConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, ROLE_ARN_FIELD, DESCRIPTION_FIELD, DOCUMENT_METADATA_CONFIGURATION_UPDATES_FIELD));
    private final String id;
    private final String name;
    private final String roleArn;
    private final String description;
    private final List<DocumentMetadataConfiguration> documentMetadataConfigurationUpdates;

    private UpdateIndexRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.roleArn = builder.roleArn;
        this.description = builder.description;
        this.documentMetadataConfigurationUpdates = builder.documentMetadataConfigurationUpdates;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String description() {
        return this.description;
    }

    public boolean hasDocumentMetadataConfigurationUpdates() {
        return this.documentMetadataConfigurationUpdates != null && !(this.documentMetadataConfigurationUpdates instanceof SdkAutoConstructList);
    }

    public List<DocumentMetadataConfiguration> documentMetadataConfigurationUpdates() {
        return this.documentMetadataConfigurationUpdates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentMetadataConfigurationUpdates());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIndexRequest)) {
            return false;
        }
        UpdateIndexRequest other = (UpdateIndexRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.documentMetadataConfigurationUpdates(), other.documentMetadataConfigurationUpdates());
    }

    public String toString() {
        return ToString.builder((String)"UpdateIndexRequest").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("RoleArn", (Object)this.roleArn()).add("Description", (Object)this.description()).add("DocumentMetadataConfigurationUpdates", this.documentMetadataConfigurationUpdates()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DocumentMetadataConfigurationUpdates": {
                return Optional.ofNullable(clazz.cast(this.documentMetadataConfigurationUpdates()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateIndexRequest, T> g) {
        return obj -> g.apply((UpdateIndexRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraRequest.BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String roleArn;
        private String description;
        private List<DocumentMetadataConfiguration> documentMetadataConfigurationUpdates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIndexRequest model) {
            super(model);
            this.id(model.id);
            this.name(model.name);
            this.roleArn(model.roleArn);
            this.description(model.description);
            this.documentMetadataConfigurationUpdates(model.documentMetadataConfigurationUpdates);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<DocumentMetadataConfiguration.Builder> getDocumentMetadataConfigurationUpdates() {
            return this.documentMetadataConfigurationUpdates != null ? (Collection)this.documentMetadataConfigurationUpdates.stream().map(DocumentMetadataConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder documentMetadataConfigurationUpdates(Collection<DocumentMetadataConfiguration> documentMetadataConfigurationUpdates) {
            this.documentMetadataConfigurationUpdates = DocumentMetadataConfigurationListCopier.copy(documentMetadataConfigurationUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentMetadataConfigurationUpdates(DocumentMetadataConfiguration ... documentMetadataConfigurationUpdates) {
            this.documentMetadataConfigurationUpdates(Arrays.asList(documentMetadataConfigurationUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentMetadataConfigurationUpdates(Consumer<DocumentMetadataConfiguration.Builder> ... documentMetadataConfigurationUpdates) {
            this.documentMetadataConfigurationUpdates(Stream.of(documentMetadataConfigurationUpdates).map(c -> (DocumentMetadataConfiguration)((DocumentMetadataConfiguration.Builder)DocumentMetadataConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDocumentMetadataConfigurationUpdates(Collection<DocumentMetadataConfiguration.BuilderImpl> documentMetadataConfigurationUpdates) {
            this.documentMetadataConfigurationUpdates = DocumentMetadataConfigurationListCopier.copyFromBuilder(documentMetadataConfigurationUpdates);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIndexRequest build() {
            return new UpdateIndexRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KendraRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateIndexRequest> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder roleArn(String var1);

        public Builder description(String var1);

        public Builder documentMetadataConfigurationUpdates(Collection<DocumentMetadataConfiguration> var1);

        public Builder documentMetadataConfigurationUpdates(DocumentMetadataConfiguration ... var1);

        public Builder documentMetadataConfigurationUpdates(Consumer<DocumentMetadataConfiguration.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

