/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.kendra.model.Order;
import software.amazon.awssdk.services.kendra.model.ValueImportanceMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Relevance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Relevance> {
    private static final SdkField<Boolean> FRESHNESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Relevance.getter(Relevance::freshness)).setter(Relevance.setter(Builder::freshness)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Freshness").build()}).build();
    private static final SdkField<Integer> IMPORTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Relevance.getter(Relevance::importance)).setter(Relevance.setter(Builder::importance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Importance").build()}).build();
    private static final SdkField<String> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Relevance.getter(Relevance::duration)).setter(Relevance.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<String> RANK_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Relevance.getter(Relevance::rankOrderAsString)).setter(Relevance.setter(Builder::rankOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RankOrder").build()}).build();
    private static final SdkField<Map<String, Integer>> VALUE_IMPORTANCE_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(Relevance.getter(Relevance::valueImportanceMap)).setter(Relevance.setter(Builder::valueImportanceMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueImportanceMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRESHNESS_FIELD, IMPORTANCE_FIELD, DURATION_FIELD, RANK_ORDER_FIELD, VALUE_IMPORTANCE_MAP_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean freshness;
    private final Integer importance;
    private final String duration;
    private final String rankOrder;
    private final Map<String, Integer> valueImportanceMap;

    private Relevance(BuilderImpl builder) {
        this.freshness = builder.freshness;
        this.importance = builder.importance;
        this.duration = builder.duration;
        this.rankOrder = builder.rankOrder;
        this.valueImportanceMap = builder.valueImportanceMap;
    }

    public Boolean freshness() {
        return this.freshness;
    }

    public Integer importance() {
        return this.importance;
    }

    public String duration() {
        return this.duration;
    }

    public Order rankOrder() {
        return Order.fromValue(this.rankOrder);
    }

    public String rankOrderAsString() {
        return this.rankOrder;
    }

    public boolean hasValueImportanceMap() {
        return this.valueImportanceMap != null && !(this.valueImportanceMap instanceof SdkAutoConstructMap);
    }

    public Map<String, Integer> valueImportanceMap() {
        return this.valueImportanceMap;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.freshness());
        hashCode = 31 * hashCode + Objects.hashCode(this.importance());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.rankOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueImportanceMap());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Relevance)) {
            return false;
        }
        Relevance other = (Relevance)obj;
        return Objects.equals(this.freshness(), other.freshness()) && Objects.equals(this.importance(), other.importance()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.rankOrderAsString(), other.rankOrderAsString()) && Objects.equals(this.valueImportanceMap(), other.valueImportanceMap());
    }

    public String toString() {
        return ToString.builder((String)"Relevance").add("Freshness", (Object)this.freshness()).add("Importance", (Object)this.importance()).add("Duration", (Object)this.duration()).add("RankOrder", (Object)this.rankOrderAsString()).add("ValueImportanceMap", this.valueImportanceMap()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Freshness": {
                return Optional.ofNullable(clazz.cast(this.freshness()));
            }
            case "Importance": {
                return Optional.ofNullable(clazz.cast(this.importance()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "RankOrder": {
                return Optional.ofNullable(clazz.cast(this.rankOrderAsString()));
            }
            case "ValueImportanceMap": {
                return Optional.ofNullable(clazz.cast(this.valueImportanceMap()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Relevance, T> g) {
        return obj -> g.apply((Relevance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean freshness;
        private Integer importance;
        private String duration;
        private String rankOrder;
        private Map<String, Integer> valueImportanceMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Relevance model) {
            this.freshness(model.freshness);
            this.importance(model.importance);
            this.duration(model.duration);
            this.rankOrder(model.rankOrder);
            this.valueImportanceMap(model.valueImportanceMap);
        }

        public final Boolean getFreshness() {
            return this.freshness;
        }

        @Override
        public final Builder freshness(Boolean freshness) {
            this.freshness = freshness;
            return this;
        }

        public final void setFreshness(Boolean freshness) {
            this.freshness = freshness;
        }

        public final Integer getImportance() {
            return this.importance;
        }

        @Override
        public final Builder importance(Integer importance) {
            this.importance = importance;
            return this;
        }

        public final void setImportance(Integer importance) {
            this.importance = importance;
        }

        public final String getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(String duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(String duration) {
            this.duration = duration;
        }

        public final String getRankOrderAsString() {
            return this.rankOrder;
        }

        @Override
        public final Builder rankOrder(String rankOrder) {
            this.rankOrder = rankOrder;
            return this;
        }

        @Override
        public final Builder rankOrder(Order rankOrder) {
            this.rankOrder(rankOrder == null ? null : rankOrder.toString());
            return this;
        }

        public final void setRankOrder(String rankOrder) {
            this.rankOrder = rankOrder;
        }

        public final Map<String, Integer> getValueImportanceMap() {
            return this.valueImportanceMap;
        }

        @Override
        public final Builder valueImportanceMap(Map<String, Integer> valueImportanceMap) {
            this.valueImportanceMap = ValueImportanceMapCopier.copy(valueImportanceMap);
            return this;
        }

        public final void setValueImportanceMap(Map<String, Integer> valueImportanceMap) {
            this.valueImportanceMap = ValueImportanceMapCopier.copy(valueImportanceMap);
        }

        public Relevance build() {
            return new Relevance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Relevance> {
        public Builder freshness(Boolean var1);

        public Builder importance(Integer var1);

        public Builder duration(String var1);

        public Builder rankOrder(String var1);

        public Builder rankOrder(Order var1);

        public Builder valueImportanceMap(Map<String, Integer> var1);
    }
}

