/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.FacetResult;
import software.amazon.awssdk.services.kendra.model.FacetResultListCopier;
import software.amazon.awssdk.services.kendra.model.KendraResponse;
import software.amazon.awssdk.services.kendra.model.QueryResultItem;
import software.amazon.awssdk.services.kendra.model.QueryResultItemListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryResponse
extends KendraResponse
implements ToCopyableBuilder<Builder, QueryResponse> {
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QueryResponse.getter(QueryResponse::queryId)).setter(QueryResponse.setter(Builder::queryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryId").build()}).build();
    private static final SdkField<List<QueryResultItem>> RESULT_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(QueryResponse.getter(QueryResponse::resultItems)).setter(QueryResponse.setter(Builder::resultItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QueryResultItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FacetResult>> FACET_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(QueryResponse.getter(QueryResponse::facetResults)).setter(QueryResponse.setter(Builder::facetResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FacetResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FacetResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> TOTAL_NUMBER_OF_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(QueryResponse.getter(QueryResponse::totalNumberOfResults)).setter(QueryResponse.setter(Builder::totalNumberOfResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalNumberOfResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_ID_FIELD, RESULT_ITEMS_FIELD, FACET_RESULTS_FIELD, TOTAL_NUMBER_OF_RESULTS_FIELD));
    private final String queryId;
    private final List<QueryResultItem> resultItems;
    private final List<FacetResult> facetResults;
    private final Integer totalNumberOfResults;

    private QueryResponse(BuilderImpl builder) {
        super(builder);
        this.queryId = builder.queryId;
        this.resultItems = builder.resultItems;
        this.facetResults = builder.facetResults;
        this.totalNumberOfResults = builder.totalNumberOfResults;
    }

    public String queryId() {
        return this.queryId;
    }

    public List<QueryResultItem> resultItems() {
        return this.resultItems;
    }

    public List<FacetResult> facetResults() {
        return this.facetResults;
    }

    public Integer totalNumberOfResults() {
        return this.totalNumberOfResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.queryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.facetResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalNumberOfResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryResponse)) {
            return false;
        }
        QueryResponse other = (QueryResponse)((Object)obj);
        return Objects.equals(this.queryId(), other.queryId()) && Objects.equals(this.resultItems(), other.resultItems()) && Objects.equals(this.facetResults(), other.facetResults()) && Objects.equals(this.totalNumberOfResults(), other.totalNumberOfResults());
    }

    public String toString() {
        return ToString.builder((String)"QueryResponse").add("QueryId", (Object)this.queryId()).add("ResultItems", this.resultItems()).add("FacetResults", this.facetResults()).add("TotalNumberOfResults", (Object)this.totalNumberOfResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryId": {
                return Optional.ofNullable(clazz.cast(this.queryId()));
            }
            case "ResultItems": {
                return Optional.ofNullable(clazz.cast(this.resultItems()));
            }
            case "FacetResults": {
                return Optional.ofNullable(clazz.cast(this.facetResults()));
            }
            case "TotalNumberOfResults": {
                return Optional.ofNullable(clazz.cast(this.totalNumberOfResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryResponse, T> g) {
        return obj -> g.apply((QueryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraResponse.BuilderImpl
    implements Builder {
        private String queryId;
        private List<QueryResultItem> resultItems = DefaultSdkAutoConstructList.getInstance();
        private List<FacetResult> facetResults = DefaultSdkAutoConstructList.getInstance();
        private Integer totalNumberOfResults;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryResponse model) {
            super(model);
            this.queryId(model.queryId);
            this.resultItems(model.resultItems);
            this.facetResults(model.facetResults);
            this.totalNumberOfResults(model.totalNumberOfResults);
        }

        public final String getQueryId() {
            return this.queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        public final Collection<QueryResultItem.Builder> getResultItems() {
            return this.resultItems != null ? (Collection)this.resultItems.stream().map(QueryResultItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resultItems(Collection<QueryResultItem> resultItems) {
            this.resultItems = QueryResultItemListCopier.copy(resultItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultItems(QueryResultItem ... resultItems) {
            this.resultItems(Arrays.asList(resultItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultItems(Consumer<QueryResultItem.Builder> ... resultItems) {
            this.resultItems(Stream.of(resultItems).map(c -> (QueryResultItem)((QueryResultItem.Builder)QueryResultItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResultItems(Collection<QueryResultItem.BuilderImpl> resultItems) {
            this.resultItems = QueryResultItemListCopier.copyFromBuilder(resultItems);
        }

        public final Collection<FacetResult.Builder> getFacetResults() {
            return this.facetResults != null ? (Collection)this.facetResults.stream().map(FacetResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder facetResults(Collection<FacetResult> facetResults) {
            this.facetResults = FacetResultListCopier.copy(facetResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder facetResults(FacetResult ... facetResults) {
            this.facetResults(Arrays.asList(facetResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder facetResults(Consumer<FacetResult.Builder> ... facetResults) {
            this.facetResults(Stream.of(facetResults).map(c -> (FacetResult)((FacetResult.Builder)FacetResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFacetResults(Collection<FacetResult.BuilderImpl> facetResults) {
            this.facetResults = FacetResultListCopier.copyFromBuilder(facetResults);
        }

        public final Integer getTotalNumberOfResults() {
            return this.totalNumberOfResults;
        }

        @Override
        public final Builder totalNumberOfResults(Integer totalNumberOfResults) {
            this.totalNumberOfResults = totalNumberOfResults;
            return this;
        }

        public final void setTotalNumberOfResults(Integer totalNumberOfResults) {
            this.totalNumberOfResults = totalNumberOfResults;
        }

        @Override
        public QueryResponse build() {
            return new QueryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KendraResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, QueryResponse> {
        public Builder queryId(String var1);

        public Builder resultItems(Collection<QueryResultItem> var1);

        public Builder resultItems(QueryResultItem ... var1);

        public Builder resultItems(Consumer<QueryResultItem.Builder> ... var1);

        public Builder facetResults(Collection<FacetResult> var1);

        public Builder facetResults(FacetResult ... var1);

        public Builder facetResults(Consumer<FacetResult.Builder> ... var1);

        public Builder totalNumberOfResults(Integer var1);
    }
}

