/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.AdditionalResultAttribute;
import software.amazon.awssdk.services.kendra.model.AdditionalResultAttributeListCopier;
import software.amazon.awssdk.services.kendra.model.DocumentAttribute;
import software.amazon.awssdk.services.kendra.model.DocumentAttributeListCopier;
import software.amazon.awssdk.services.kendra.model.QueryResultType;
import software.amazon.awssdk.services.kendra.model.TextWithHighlights;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryResultItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueryResultItem> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QueryResultItem.getter(QueryResultItem::id)).setter(QueryResultItem.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QueryResultItem.getter(QueryResultItem::typeAsString)).setter(QueryResultItem.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<List<AdditionalResultAttribute>> ADDITIONAL_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(QueryResultItem.getter(QueryResultItem::additionalAttributes)).setter(QueryResultItem.setter(Builder::additionalAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AdditionalResultAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DOCUMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QueryResultItem.getter(QueryResultItem::documentId)).setter(QueryResultItem.setter(Builder::documentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentId").build()}).build();
    private static final SdkField<TextWithHighlights> DOCUMENT_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(QueryResultItem.getter(QueryResultItem::documentTitle)).setter(QueryResultItem.setter(Builder::documentTitle)).constructor(TextWithHighlights::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentTitle").build()}).build();
    private static final SdkField<TextWithHighlights> DOCUMENT_EXCERPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(QueryResultItem.getter(QueryResultItem::documentExcerpt)).setter(QueryResultItem.setter(Builder::documentExcerpt)).constructor(TextWithHighlights::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentExcerpt").build()}).build();
    private static final SdkField<String> DOCUMENT_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QueryResultItem.getter(QueryResultItem::documentURI)).setter(QueryResultItem.setter(Builder::documentURI)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentURI").build()}).build();
    private static final SdkField<List<DocumentAttribute>> DOCUMENT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(QueryResultItem.getter(QueryResultItem::documentAttributes)).setter(QueryResultItem.setter(Builder::documentAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TYPE_FIELD, ADDITIONAL_ATTRIBUTES_FIELD, DOCUMENT_ID_FIELD, DOCUMENT_TITLE_FIELD, DOCUMENT_EXCERPT_FIELD, DOCUMENT_URI_FIELD, DOCUMENT_ATTRIBUTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String type;
    private final List<AdditionalResultAttribute> additionalAttributes;
    private final String documentId;
    private final TextWithHighlights documentTitle;
    private final TextWithHighlights documentExcerpt;
    private final String documentURI;
    private final List<DocumentAttribute> documentAttributes;

    private QueryResultItem(BuilderImpl builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.additionalAttributes = builder.additionalAttributes;
        this.documentId = builder.documentId;
        this.documentTitle = builder.documentTitle;
        this.documentExcerpt = builder.documentExcerpt;
        this.documentURI = builder.documentURI;
        this.documentAttributes = builder.documentAttributes;
    }

    public String id() {
        return this.id;
    }

    public QueryResultType type() {
        return QueryResultType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public List<AdditionalResultAttribute> additionalAttributes() {
        return this.additionalAttributes;
    }

    public String documentId() {
        return this.documentId;
    }

    public TextWithHighlights documentTitle() {
        return this.documentTitle;
    }

    public TextWithHighlights documentExcerpt() {
        return this.documentExcerpt;
    }

    public String documentURI() {
        return this.documentURI;
    }

    public List<DocumentAttribute> documentAttributes() {
        return this.documentAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentTitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentExcerpt());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentURI());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentAttributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryResultItem)) {
            return false;
        }
        QueryResultItem other = (QueryResultItem)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.additionalAttributes(), other.additionalAttributes()) && Objects.equals(this.documentId(), other.documentId()) && Objects.equals(this.documentTitle(), other.documentTitle()) && Objects.equals(this.documentExcerpt(), other.documentExcerpt()) && Objects.equals(this.documentURI(), other.documentURI()) && Objects.equals(this.documentAttributes(), other.documentAttributes());
    }

    public String toString() {
        return ToString.builder((String)"QueryResultItem").add("Id", (Object)this.id()).add("Type", (Object)this.typeAsString()).add("AdditionalAttributes", this.additionalAttributes()).add("DocumentId", (Object)this.documentId()).add("DocumentTitle", (Object)this.documentTitle()).add("DocumentExcerpt", (Object)this.documentExcerpt()).add("DocumentURI", (Object)this.documentURI()).add("DocumentAttributes", this.documentAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "AdditionalAttributes": {
                return Optional.ofNullable(clazz.cast(this.additionalAttributes()));
            }
            case "DocumentId": {
                return Optional.ofNullable(clazz.cast(this.documentId()));
            }
            case "DocumentTitle": {
                return Optional.ofNullable(clazz.cast(this.documentTitle()));
            }
            case "DocumentExcerpt": {
                return Optional.ofNullable(clazz.cast(this.documentExcerpt()));
            }
            case "DocumentURI": {
                return Optional.ofNullable(clazz.cast(this.documentURI()));
            }
            case "DocumentAttributes": {
                return Optional.ofNullable(clazz.cast(this.documentAttributes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryResultItem, T> g) {
        return obj -> g.apply((QueryResultItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String type;
        private List<AdditionalResultAttribute> additionalAttributes = DefaultSdkAutoConstructList.getInstance();
        private String documentId;
        private TextWithHighlights documentTitle;
        private TextWithHighlights documentExcerpt;
        private String documentURI;
        private List<DocumentAttribute> documentAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QueryResultItem model) {
            this.id(model.id);
            this.type(model.type);
            this.additionalAttributes(model.additionalAttributes);
            this.documentId(model.documentId);
            this.documentTitle(model.documentTitle);
            this.documentExcerpt(model.documentExcerpt);
            this.documentURI(model.documentURI);
            this.documentAttributes(model.documentAttributes);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getTypeAsString() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(QueryResultType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Collection<AdditionalResultAttribute.Builder> getAdditionalAttributes() {
            return this.additionalAttributes != null ? (Collection)this.additionalAttributes.stream().map(AdditionalResultAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder additionalAttributes(Collection<AdditionalResultAttribute> additionalAttributes) {
            this.additionalAttributes = AdditionalResultAttributeListCopier.copy(additionalAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAttributes(AdditionalResultAttribute ... additionalAttributes) {
            this.additionalAttributes(Arrays.asList(additionalAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAttributes(Consumer<AdditionalResultAttribute.Builder> ... additionalAttributes) {
            this.additionalAttributes(Stream.of(additionalAttributes).map(c -> (AdditionalResultAttribute)((AdditionalResultAttribute.Builder)AdditionalResultAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAdditionalAttributes(Collection<AdditionalResultAttribute.BuilderImpl> additionalAttributes) {
            this.additionalAttributes = AdditionalResultAttributeListCopier.copyFromBuilder(additionalAttributes);
        }

        public final String getDocumentId() {
            return this.documentId;
        }

        @Override
        public final Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public final void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        public final TextWithHighlights.Builder getDocumentTitle() {
            return this.documentTitle != null ? this.documentTitle.toBuilder() : null;
        }

        @Override
        public final Builder documentTitle(TextWithHighlights documentTitle) {
            this.documentTitle = documentTitle;
            return this;
        }

        public final void setDocumentTitle(TextWithHighlights.BuilderImpl documentTitle) {
            this.documentTitle = documentTitle != null ? documentTitle.build() : null;
        }

        public final TextWithHighlights.Builder getDocumentExcerpt() {
            return this.documentExcerpt != null ? this.documentExcerpt.toBuilder() : null;
        }

        @Override
        public final Builder documentExcerpt(TextWithHighlights documentExcerpt) {
            this.documentExcerpt = documentExcerpt;
            return this;
        }

        public final void setDocumentExcerpt(TextWithHighlights.BuilderImpl documentExcerpt) {
            this.documentExcerpt = documentExcerpt != null ? documentExcerpt.build() : null;
        }

        public final String getDocumentURI() {
            return this.documentURI;
        }

        @Override
        public final Builder documentURI(String documentURI) {
            this.documentURI = documentURI;
            return this;
        }

        public final void setDocumentURI(String documentURI) {
            this.documentURI = documentURI;
        }

        public final Collection<DocumentAttribute.Builder> getDocumentAttributes() {
            return this.documentAttributes != null ? (Collection)this.documentAttributes.stream().map(DocumentAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder documentAttributes(Collection<DocumentAttribute> documentAttributes) {
            this.documentAttributes = DocumentAttributeListCopier.copy(documentAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentAttributes(DocumentAttribute ... documentAttributes) {
            this.documentAttributes(Arrays.asList(documentAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentAttributes(Consumer<DocumentAttribute.Builder> ... documentAttributes) {
            this.documentAttributes(Stream.of(documentAttributes).map(c -> (DocumentAttribute)((DocumentAttribute.Builder)DocumentAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDocumentAttributes(Collection<DocumentAttribute.BuilderImpl> documentAttributes) {
            this.documentAttributes = DocumentAttributeListCopier.copyFromBuilder(documentAttributes);
        }

        public QueryResultItem build() {
            return new QueryResultItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueryResultItem> {
        public Builder id(String var1);

        public Builder type(String var1);

        public Builder type(QueryResultType var1);

        public Builder additionalAttributes(Collection<AdditionalResultAttribute> var1);

        public Builder additionalAttributes(AdditionalResultAttribute ... var1);

        public Builder additionalAttributes(Consumer<AdditionalResultAttribute.Builder> ... var1);

        public Builder documentId(String var1);

        public Builder documentTitle(TextWithHighlights var1);

        default public Builder documentTitle(Consumer<TextWithHighlights.Builder> documentTitle) {
            return this.documentTitle((TextWithHighlights)((TextWithHighlights.Builder)TextWithHighlights.builder().applyMutation(documentTitle)).build());
        }

        public Builder documentExcerpt(TextWithHighlights var1);

        default public Builder documentExcerpt(Consumer<TextWithHighlights.Builder> documentExcerpt) {
            return this.documentExcerpt((TextWithHighlights)((TextWithHighlights.Builder)TextWithHighlights.builder().applyMutation(documentExcerpt)).build());
        }

        public Builder documentURI(String var1);

        public Builder documentAttributes(Collection<DocumentAttribute> var1);

        public Builder documentAttributes(DocumentAttribute ... var1);

        public Builder documentAttributes(Consumer<DocumentAttribute.Builder> ... var1);
    }
}

