/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafkaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafkaconnect.model.CloudWatchLogsLogDeliveryDescription;
import software.amazon.awssdk.services.kafkaconnect.model.FirehoseLogDeliveryDescription;
import software.amazon.awssdk.services.kafkaconnect.model.S3LogDeliveryDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkerLogDeliveryDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkerLogDeliveryDescription> {
    private static final SdkField<CloudWatchLogsLogDeliveryDescription> CLOUD_WATCH_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cloudWatchLogs").getter(WorkerLogDeliveryDescription.getter(WorkerLogDeliveryDescription::cloudWatchLogs)).setter(WorkerLogDeliveryDescription.setter(Builder::cloudWatchLogs)).constructor(CloudWatchLogsLogDeliveryDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLogs").build()}).build();
    private static final SdkField<FirehoseLogDeliveryDescription> FIREHOSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("firehose").getter(WorkerLogDeliveryDescription.getter(WorkerLogDeliveryDescription::firehose)).setter(WorkerLogDeliveryDescription.setter(Builder::firehose)).constructor(FirehoseLogDeliveryDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firehose").build()}).build();
    private static final SdkField<S3LogDeliveryDescription> S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3").getter(WorkerLogDeliveryDescription.getter(WorkerLogDeliveryDescription::s3)).setter(WorkerLogDeliveryDescription.setter(Builder::s3)).constructor(S3LogDeliveryDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_LOGS_FIELD, FIREHOSE_FIELD, S3_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WorkerLogDeliveryDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CloudWatchLogsLogDeliveryDescription cloudWatchLogs;
    private final FirehoseLogDeliveryDescription firehose;
    private final S3LogDeliveryDescription s3;

    private WorkerLogDeliveryDescription(BuilderImpl builder) {
        this.cloudWatchLogs = builder.cloudWatchLogs;
        this.firehose = builder.firehose;
        this.s3 = builder.s3;
    }

    public final CloudWatchLogsLogDeliveryDescription cloudWatchLogs() {
        return this.cloudWatchLogs;
    }

    public final FirehoseLogDeliveryDescription firehose() {
        return this.firehose;
    }

    public final S3LogDeliveryDescription s3() {
        return this.s3;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.firehose());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkerLogDeliveryDescription)) {
            return false;
        }
        WorkerLogDeliveryDescription other = (WorkerLogDeliveryDescription)obj;
        return Objects.equals(this.cloudWatchLogs(), other.cloudWatchLogs()) && Objects.equals(this.firehose(), other.firehose()) && Objects.equals(this.s3(), other.s3());
    }

    public final String toString() {
        return ToString.builder((String)"WorkerLogDeliveryDescription").add("CloudWatchLogs", (Object)this.cloudWatchLogs()).add("Firehose", (Object)this.firehose()).add("S3", (Object)this.s3()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cloudWatchLogs": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogs()));
            }
            case "firehose": {
                return Optional.ofNullable(clazz.cast(this.firehose()));
            }
            case "s3": {
                return Optional.ofNullable(clazz.cast(this.s3()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cloudWatchLogs", CLOUD_WATCH_LOGS_FIELD);
        map.put("firehose", FIREHOSE_FIELD);
        map.put("s3", S3_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkerLogDeliveryDescription, T> g) {
        return obj -> g.apply((WorkerLogDeliveryDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CloudWatchLogsLogDeliveryDescription cloudWatchLogs;
        private FirehoseLogDeliveryDescription firehose;
        private S3LogDeliveryDescription s3;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkerLogDeliveryDescription model) {
            this.cloudWatchLogs(model.cloudWatchLogs);
            this.firehose(model.firehose);
            this.s3(model.s3);
        }

        public final CloudWatchLogsLogDeliveryDescription.Builder getCloudWatchLogs() {
            return this.cloudWatchLogs != null ? this.cloudWatchLogs.toBuilder() : null;
        }

        public final void setCloudWatchLogs(CloudWatchLogsLogDeliveryDescription.BuilderImpl cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs != null ? cloudWatchLogs.build() : null;
        }

        @Override
        public final Builder cloudWatchLogs(CloudWatchLogsLogDeliveryDescription cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs;
            return this;
        }

        public final FirehoseLogDeliveryDescription.Builder getFirehose() {
            return this.firehose != null ? this.firehose.toBuilder() : null;
        }

        public final void setFirehose(FirehoseLogDeliveryDescription.BuilderImpl firehose) {
            this.firehose = firehose != null ? firehose.build() : null;
        }

        @Override
        public final Builder firehose(FirehoseLogDeliveryDescription firehose) {
            this.firehose = firehose;
            return this;
        }

        public final S3LogDeliveryDescription.Builder getS3() {
            return this.s3 != null ? this.s3.toBuilder() : null;
        }

        public final void setS3(S3LogDeliveryDescription.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        @Override
        public final Builder s3(S3LogDeliveryDescription s3) {
            this.s3 = s3;
            return this;
        }

        public WorkerLogDeliveryDescription build() {
            return new WorkerLogDeliveryDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkerLogDeliveryDescription> {
        public Builder cloudWatchLogs(CloudWatchLogsLogDeliveryDescription var1);

        default public Builder cloudWatchLogs(Consumer<CloudWatchLogsLogDeliveryDescription.Builder> cloudWatchLogs) {
            return this.cloudWatchLogs((CloudWatchLogsLogDeliveryDescription)((CloudWatchLogsLogDeliveryDescription.Builder)CloudWatchLogsLogDeliveryDescription.builder().applyMutation(cloudWatchLogs)).build());
        }

        public Builder firehose(FirehoseLogDeliveryDescription var1);

        default public Builder firehose(Consumer<FirehoseLogDeliveryDescription.Builder> firehose) {
            return this.firehose((FirehoseLogDeliveryDescription)((FirehoseLogDeliveryDescription.Builder)FirehoseLogDeliveryDescription.builder().applyMutation(firehose)).build());
        }

        public Builder s3(S3LogDeliveryDescription var1);

        default public Builder s3(Consumer<S3LogDeliveryDescription.Builder> s3) {
            return this.s3((S3LogDeliveryDescription)((S3LogDeliveryDescription.Builder)S3LogDeliveryDescription.builder().applyMutation(s3)).build());
        }
    }
}

