/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafkaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafkaconnect.model.ScaleInPolicyUpdate;
import software.amazon.awssdk.services.kafkaconnect.model.ScaleOutPolicyUpdate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoScalingUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoScalingUpdate> {
    private static final SdkField<Integer> MAX_WORKER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxWorkerCount").getter(AutoScalingUpdate.getter(AutoScalingUpdate::maxWorkerCount)).setter(AutoScalingUpdate.setter(Builder::maxWorkerCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxWorkerCount").build()}).build();
    private static final SdkField<Integer> MCU_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("mcuCount").getter(AutoScalingUpdate.getter(AutoScalingUpdate::mcuCount)).setter(AutoScalingUpdate.setter(Builder::mcuCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mcuCount").build()}).build();
    private static final SdkField<Integer> MIN_WORKER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minWorkerCount").getter(AutoScalingUpdate.getter(AutoScalingUpdate::minWorkerCount)).setter(AutoScalingUpdate.setter(Builder::minWorkerCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minWorkerCount").build()}).build();
    private static final SdkField<ScaleInPolicyUpdate> SCALE_IN_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scaleInPolicy").getter(AutoScalingUpdate.getter(AutoScalingUpdate::scaleInPolicy)).setter(AutoScalingUpdate.setter(Builder::scaleInPolicy)).constructor(ScaleInPolicyUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scaleInPolicy").build()}).build();
    private static final SdkField<ScaleOutPolicyUpdate> SCALE_OUT_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scaleOutPolicy").getter(AutoScalingUpdate.getter(AutoScalingUpdate::scaleOutPolicy)).setter(AutoScalingUpdate.setter(Builder::scaleOutPolicy)).constructor(ScaleOutPolicyUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scaleOutPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_WORKER_COUNT_FIELD, MCU_COUNT_FIELD, MIN_WORKER_COUNT_FIELD, SCALE_IN_POLICY_FIELD, SCALE_OUT_POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutoScalingUpdate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer maxWorkerCount;
    private final Integer mcuCount;
    private final Integer minWorkerCount;
    private final ScaleInPolicyUpdate scaleInPolicy;
    private final ScaleOutPolicyUpdate scaleOutPolicy;

    private AutoScalingUpdate(BuilderImpl builder) {
        this.maxWorkerCount = builder.maxWorkerCount;
        this.mcuCount = builder.mcuCount;
        this.minWorkerCount = builder.minWorkerCount;
        this.scaleInPolicy = builder.scaleInPolicy;
        this.scaleOutPolicy = builder.scaleOutPolicy;
    }

    public final Integer maxWorkerCount() {
        return this.maxWorkerCount;
    }

    public final Integer mcuCount() {
        return this.mcuCount;
    }

    public final Integer minWorkerCount() {
        return this.minWorkerCount;
    }

    public final ScaleInPolicyUpdate scaleInPolicy() {
        return this.scaleInPolicy;
    }

    public final ScaleOutPolicyUpdate scaleOutPolicy() {
        return this.scaleOutPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxWorkerCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.mcuCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.minWorkerCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.scaleInPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.scaleOutPolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingUpdate)) {
            return false;
        }
        AutoScalingUpdate other = (AutoScalingUpdate)obj;
        return Objects.equals(this.maxWorkerCount(), other.maxWorkerCount()) && Objects.equals(this.mcuCount(), other.mcuCount()) && Objects.equals(this.minWorkerCount(), other.minWorkerCount()) && Objects.equals(this.scaleInPolicy(), other.scaleInPolicy()) && Objects.equals(this.scaleOutPolicy(), other.scaleOutPolicy());
    }

    public final String toString() {
        return ToString.builder((String)"AutoScalingUpdate").add("MaxWorkerCount", (Object)this.maxWorkerCount()).add("McuCount", (Object)this.mcuCount()).add("MinWorkerCount", (Object)this.minWorkerCount()).add("ScaleInPolicy", (Object)this.scaleInPolicy()).add("ScaleOutPolicy", (Object)this.scaleOutPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "maxWorkerCount": {
                return Optional.ofNullable(clazz.cast(this.maxWorkerCount()));
            }
            case "mcuCount": {
                return Optional.ofNullable(clazz.cast(this.mcuCount()));
            }
            case "minWorkerCount": {
                return Optional.ofNullable(clazz.cast(this.minWorkerCount()));
            }
            case "scaleInPolicy": {
                return Optional.ofNullable(clazz.cast(this.scaleInPolicy()));
            }
            case "scaleOutPolicy": {
                return Optional.ofNullable(clazz.cast(this.scaleOutPolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("maxWorkerCount", MAX_WORKER_COUNT_FIELD);
        map.put("mcuCount", MCU_COUNT_FIELD);
        map.put("minWorkerCount", MIN_WORKER_COUNT_FIELD);
        map.put("scaleInPolicy", SCALE_IN_POLICY_FIELD);
        map.put("scaleOutPolicy", SCALE_OUT_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingUpdate, T> g) {
        return obj -> g.apply((AutoScalingUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maxWorkerCount;
        private Integer mcuCount;
        private Integer minWorkerCount;
        private ScaleInPolicyUpdate scaleInPolicy;
        private ScaleOutPolicyUpdate scaleOutPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingUpdate model) {
            this.maxWorkerCount(model.maxWorkerCount);
            this.mcuCount(model.mcuCount);
            this.minWorkerCount(model.minWorkerCount);
            this.scaleInPolicy(model.scaleInPolicy);
            this.scaleOutPolicy(model.scaleOutPolicy);
        }

        public final Integer getMaxWorkerCount() {
            return this.maxWorkerCount;
        }

        public final void setMaxWorkerCount(Integer maxWorkerCount) {
            this.maxWorkerCount = maxWorkerCount;
        }

        @Override
        public final Builder maxWorkerCount(Integer maxWorkerCount) {
            this.maxWorkerCount = maxWorkerCount;
            return this;
        }

        public final Integer getMcuCount() {
            return this.mcuCount;
        }

        public final void setMcuCount(Integer mcuCount) {
            this.mcuCount = mcuCount;
        }

        @Override
        public final Builder mcuCount(Integer mcuCount) {
            this.mcuCount = mcuCount;
            return this;
        }

        public final Integer getMinWorkerCount() {
            return this.minWorkerCount;
        }

        public final void setMinWorkerCount(Integer minWorkerCount) {
            this.minWorkerCount = minWorkerCount;
        }

        @Override
        public final Builder minWorkerCount(Integer minWorkerCount) {
            this.minWorkerCount = minWorkerCount;
            return this;
        }

        public final ScaleInPolicyUpdate.Builder getScaleInPolicy() {
            return this.scaleInPolicy != null ? this.scaleInPolicy.toBuilder() : null;
        }

        public final void setScaleInPolicy(ScaleInPolicyUpdate.BuilderImpl scaleInPolicy) {
            this.scaleInPolicy = scaleInPolicy != null ? scaleInPolicy.build() : null;
        }

        @Override
        public final Builder scaleInPolicy(ScaleInPolicyUpdate scaleInPolicy) {
            this.scaleInPolicy = scaleInPolicy;
            return this;
        }

        public final ScaleOutPolicyUpdate.Builder getScaleOutPolicy() {
            return this.scaleOutPolicy != null ? this.scaleOutPolicy.toBuilder() : null;
        }

        public final void setScaleOutPolicy(ScaleOutPolicyUpdate.BuilderImpl scaleOutPolicy) {
            this.scaleOutPolicy = scaleOutPolicy != null ? scaleOutPolicy.build() : null;
        }

        @Override
        public final Builder scaleOutPolicy(ScaleOutPolicyUpdate scaleOutPolicy) {
            this.scaleOutPolicy = scaleOutPolicy;
            return this;
        }

        public AutoScalingUpdate build() {
            return new AutoScalingUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoScalingUpdate> {
        public Builder maxWorkerCount(Integer var1);

        public Builder mcuCount(Integer var1);

        public Builder minWorkerCount(Integer var1);

        public Builder scaleInPolicy(ScaleInPolicyUpdate var1);

        default public Builder scaleInPolicy(Consumer<ScaleInPolicyUpdate.Builder> scaleInPolicy) {
            return this.scaleInPolicy((ScaleInPolicyUpdate)((ScaleInPolicyUpdate.Builder)ScaleInPolicyUpdate.builder().applyMutation(scaleInPolicy)).build());
        }

        public Builder scaleOutPolicy(ScaleOutPolicyUpdate var1);

        default public Builder scaleOutPolicy(Consumer<ScaleOutPolicyUpdate.Builder> scaleOutPolicy) {
            return this.scaleOutPolicy((ScaleOutPolicyUpdate)((ScaleOutPolicyUpdate.Builder)ScaleOutPolicyUpdate.builder().applyMutation(scaleOutPolicy)).build());
        }
    }
}

