/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafkaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkerConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkerConfiguration> {
    private static final SdkField<Long> REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("revision").getter(WorkerConfiguration.getter(WorkerConfiguration::revision)).setter(WorkerConfiguration.setter(Builder::revision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()}).build();
    private static final SdkField<String> WORKER_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workerConfigurationArn").getter(WorkerConfiguration.getter(WorkerConfiguration::workerConfigurationArn)).setter(WorkerConfiguration.setter(Builder::workerConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerConfigurationArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REVISION_FIELD, WORKER_CONFIGURATION_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WorkerConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long revision;
    private final String workerConfigurationArn;

    private WorkerConfiguration(BuilderImpl builder) {
        this.revision = builder.revision;
        this.workerConfigurationArn = builder.workerConfigurationArn;
    }

    public final Long revision() {
        return this.revision;
    }

    public final String workerConfigurationArn() {
        return this.workerConfigurationArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        hashCode = 31 * hashCode + Objects.hashCode(this.workerConfigurationArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkerConfiguration)) {
            return false;
        }
        WorkerConfiguration other = (WorkerConfiguration)obj;
        return Objects.equals(this.revision(), other.revision()) && Objects.equals(this.workerConfigurationArn(), other.workerConfigurationArn());
    }

    public final String toString() {
        return ToString.builder((String)"WorkerConfiguration").add("Revision", (Object)this.revision()).add("WorkerConfigurationArn", (Object)this.workerConfigurationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "revision": {
                return Optional.ofNullable(clazz.cast(this.revision()));
            }
            case "workerConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.workerConfigurationArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("revision", REVISION_FIELD);
        map.put("workerConfigurationArn", WORKER_CONFIGURATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkerConfiguration, T> g) {
        return obj -> g.apply((WorkerConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long revision;
        private String workerConfigurationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkerConfiguration model) {
            this.revision(model.revision);
            this.workerConfigurationArn(model.workerConfigurationArn);
        }

        public final Long getRevision() {
            return this.revision;
        }

        public final void setRevision(Long revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(Long revision) {
            this.revision = revision;
            return this;
        }

        public final String getWorkerConfigurationArn() {
            return this.workerConfigurationArn;
        }

        public final void setWorkerConfigurationArn(String workerConfigurationArn) {
            this.workerConfigurationArn = workerConfigurationArn;
        }

        @Override
        public final Builder workerConfigurationArn(String workerConfigurationArn) {
            this.workerConfigurationArn = workerConfigurationArn;
            return this;
        }

        public WorkerConfiguration build() {
            return new WorkerConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkerConfiguration> {
        public Builder revision(Long var1);

        public Builder workerConfigurationArn(String var1);
    }
}

