/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafkaconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kafkaconnect.KafkaConnectAsyncClient;
import software.amazon.awssdk.services.kafkaconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.kafkaconnect.model.ListWorkerConfigurationsRequest;
import software.amazon.awssdk.services.kafkaconnect.model.ListWorkerConfigurationsResponse;
import software.amazon.awssdk.services.kafkaconnect.model.WorkerConfigurationSummary;

public class ListWorkerConfigurationsPublisher
implements SdkPublisher<ListWorkerConfigurationsResponse> {
    private final KafkaConnectAsyncClient client;
    private final ListWorkerConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWorkerConfigurationsPublisher(KafkaConnectAsyncClient client, ListWorkerConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWorkerConfigurationsPublisher(KafkaConnectAsyncClient client, ListWorkerConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWorkerConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWorkerConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<WorkerConfigurationSummary> workerConfigurations() {
        Function<ListWorkerConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.workerConfigurations() != null) {
                return response.workerConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWorkerConfigurationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWorkerConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListWorkerConfigurationsResponse> {
        private ListWorkerConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkerConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWorkerConfigurationsResponse> nextPage(ListWorkerConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkerConfigurationsPublisher.this.client.listWorkerConfigurations(ListWorkerConfigurationsPublisher.this.firstRequest);
            }
            return ListWorkerConfigurationsPublisher.this.client.listWorkerConfigurations((ListWorkerConfigurationsRequest)((Object)ListWorkerConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

