/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafkaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafkaconnect.model.CloudWatchLogsLogDelivery;
import software.amazon.awssdk.services.kafkaconnect.model.FirehoseLogDelivery;
import software.amazon.awssdk.services.kafkaconnect.model.S3LogDelivery;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkerLogDelivery
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkerLogDelivery> {
    private static final SdkField<CloudWatchLogsLogDelivery> CLOUD_WATCH_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cloudWatchLogs").getter(WorkerLogDelivery.getter(WorkerLogDelivery::cloudWatchLogs)).setter(WorkerLogDelivery.setter(Builder::cloudWatchLogs)).constructor(CloudWatchLogsLogDelivery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLogs").build()}).build();
    private static final SdkField<FirehoseLogDelivery> FIREHOSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("firehose").getter(WorkerLogDelivery.getter(WorkerLogDelivery::firehose)).setter(WorkerLogDelivery.setter(Builder::firehose)).constructor(FirehoseLogDelivery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firehose").build()}).build();
    private static final SdkField<S3LogDelivery> S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3").getter(WorkerLogDelivery.getter(WorkerLogDelivery::s3)).setter(WorkerLogDelivery.setter(Builder::s3)).constructor(S3LogDelivery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_LOGS_FIELD, FIREHOSE_FIELD, S3_FIELD));
    private static final long serialVersionUID = 1L;
    private final CloudWatchLogsLogDelivery cloudWatchLogs;
    private final FirehoseLogDelivery firehose;
    private final S3LogDelivery s3;

    private WorkerLogDelivery(BuilderImpl builder) {
        this.cloudWatchLogs = builder.cloudWatchLogs;
        this.firehose = builder.firehose;
        this.s3 = builder.s3;
    }

    public final CloudWatchLogsLogDelivery cloudWatchLogs() {
        return this.cloudWatchLogs;
    }

    public final FirehoseLogDelivery firehose() {
        return this.firehose;
    }

    public final S3LogDelivery s3() {
        return this.s3;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.firehose());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkerLogDelivery)) {
            return false;
        }
        WorkerLogDelivery other = (WorkerLogDelivery)obj;
        return Objects.equals(this.cloudWatchLogs(), other.cloudWatchLogs()) && Objects.equals(this.firehose(), other.firehose()) && Objects.equals(this.s3(), other.s3());
    }

    public final String toString() {
        return ToString.builder((String)"WorkerLogDelivery").add("CloudWatchLogs", (Object)this.cloudWatchLogs()).add("Firehose", (Object)this.firehose()).add("S3", (Object)this.s3()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cloudWatchLogs": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogs()));
            }
            case "firehose": {
                return Optional.ofNullable(clazz.cast(this.firehose()));
            }
            case "s3": {
                return Optional.ofNullable(clazz.cast(this.s3()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkerLogDelivery, T> g) {
        return obj -> g.apply((WorkerLogDelivery)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CloudWatchLogsLogDelivery cloudWatchLogs;
        private FirehoseLogDelivery firehose;
        private S3LogDelivery s3;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkerLogDelivery model) {
            this.cloudWatchLogs(model.cloudWatchLogs);
            this.firehose(model.firehose);
            this.s3(model.s3);
        }

        public final CloudWatchLogsLogDelivery.Builder getCloudWatchLogs() {
            return this.cloudWatchLogs != null ? this.cloudWatchLogs.toBuilder() : null;
        }

        public final void setCloudWatchLogs(CloudWatchLogsLogDelivery.BuilderImpl cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs != null ? cloudWatchLogs.build() : null;
        }

        @Override
        public final Builder cloudWatchLogs(CloudWatchLogsLogDelivery cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs;
            return this;
        }

        public final FirehoseLogDelivery.Builder getFirehose() {
            return this.firehose != null ? this.firehose.toBuilder() : null;
        }

        public final void setFirehose(FirehoseLogDelivery.BuilderImpl firehose) {
            this.firehose = firehose != null ? firehose.build() : null;
        }

        @Override
        public final Builder firehose(FirehoseLogDelivery firehose) {
            this.firehose = firehose;
            return this;
        }

        public final S3LogDelivery.Builder getS3() {
            return this.s3 != null ? this.s3.toBuilder() : null;
        }

        public final void setS3(S3LogDelivery.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        @Override
        public final Builder s3(S3LogDelivery s3) {
            this.s3 = s3;
            return this;
        }

        public WorkerLogDelivery build() {
            return new WorkerLogDelivery(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkerLogDelivery> {
        public Builder cloudWatchLogs(CloudWatchLogsLogDelivery var1);

        default public Builder cloudWatchLogs(Consumer<CloudWatchLogsLogDelivery.Builder> cloudWatchLogs) {
            return this.cloudWatchLogs((CloudWatchLogsLogDelivery)((CloudWatchLogsLogDelivery.Builder)CloudWatchLogsLogDelivery.builder().applyMutation(cloudWatchLogs)).build());
        }

        public Builder firehose(FirehoseLogDelivery var1);

        default public Builder firehose(Consumer<FirehoseLogDelivery.Builder> firehose) {
            return this.firehose((FirehoseLogDelivery)((FirehoseLogDelivery.Builder)FirehoseLogDelivery.builder().applyMutation(firehose)).build());
        }

        public Builder s3(S3LogDelivery var1);

        default public Builder s3(Consumer<S3LogDelivery.Builder> s3) {
            return this.s3((S3LogDelivery)((S3LogDelivery.Builder)S3LogDelivery.builder().applyMutation(s3)).build());
        }
    }
}

