/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafkaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3LocationDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3LocationDescription> {
    private static final SdkField<String> BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucketArn").getter(S3LocationDescription.getter(S3LocationDescription::bucketArn)).setter(S3LocationDescription.setter(Builder::bucketArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketArn").build()}).build();
    private static final SdkField<String> FILE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileKey").getter(S3LocationDescription.getter(S3LocationDescription::fileKey)).setter(S3LocationDescription.setter(Builder::fileKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileKey").build()}).build();
    private static final SdkField<String> OBJECT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("objectVersion").getter(S3LocationDescription.getter(S3LocationDescription::objectVersion)).setter(S3LocationDescription.setter(Builder::objectVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_ARN_FIELD, FILE_KEY_FIELD, OBJECT_VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String bucketArn;
    private final String fileKey;
    private final String objectVersion;

    private S3LocationDescription(BuilderImpl builder) {
        this.bucketArn = builder.bucketArn;
        this.fileKey = builder.fileKey;
        this.objectVersion = builder.objectVersion;
    }

    public final String bucketArn() {
        return this.bucketArn;
    }

    public final String fileKey() {
        return this.fileKey;
    }

    public final String objectVersion() {
        return this.objectVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3LocationDescription)) {
            return false;
        }
        S3LocationDescription other = (S3LocationDescription)obj;
        return Objects.equals(this.bucketArn(), other.bucketArn()) && Objects.equals(this.fileKey(), other.fileKey()) && Objects.equals(this.objectVersion(), other.objectVersion());
    }

    public final String toString() {
        return ToString.builder((String)"S3LocationDescription").add("BucketArn", (Object)this.bucketArn()).add("FileKey", (Object)this.fileKey()).add("ObjectVersion", (Object)this.objectVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bucketArn": {
                return Optional.ofNullable(clazz.cast(this.bucketArn()));
            }
            case "fileKey": {
                return Optional.ofNullable(clazz.cast(this.fileKey()));
            }
            case "objectVersion": {
                return Optional.ofNullable(clazz.cast(this.objectVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3LocationDescription, T> g) {
        return obj -> g.apply((S3LocationDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucketArn;
        private String fileKey;
        private String objectVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(S3LocationDescription model) {
            this.bucketArn(model.bucketArn);
            this.fileKey(model.fileKey);
            this.objectVersion(model.objectVersion);
        }

        public final String getBucketArn() {
            return this.bucketArn;
        }

        public final void setBucketArn(String bucketArn) {
            this.bucketArn = bucketArn;
        }

        @Override
        public final Builder bucketArn(String bucketArn) {
            this.bucketArn = bucketArn;
            return this;
        }

        public final String getFileKey() {
            return this.fileKey;
        }

        public final void setFileKey(String fileKey) {
            this.fileKey = fileKey;
        }

        @Override
        public final Builder fileKey(String fileKey) {
            this.fileKey = fileKey;
            return this;
        }

        public final String getObjectVersion() {
            return this.objectVersion;
        }

        public final void setObjectVersion(String objectVersion) {
            this.objectVersion = objectVersion;
        }

        @Override
        public final Builder objectVersion(String objectVersion) {
            this.objectVersion = objectVersion;
            return this;
        }

        public S3LocationDescription build() {
            return new S3LocationDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3LocationDescription> {
        public Builder bucketArn(String var1);

        public Builder fileKey(String var1);

        public Builder objectVersion(String var1);
    }
}

