/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafkaconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kafkaconnect.KafkaConnectAsyncClient;
import software.amazon.awssdk.services.kafkaconnect.model.CustomPluginSummary;
import software.amazon.awssdk.services.kafkaconnect.model.ListCustomPluginsRequest;
import software.amazon.awssdk.services.kafkaconnect.model.ListCustomPluginsResponse;

public class ListCustomPluginsPublisher
implements SdkPublisher<ListCustomPluginsResponse> {
    private final KafkaConnectAsyncClient client;
    private final ListCustomPluginsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCustomPluginsPublisher(KafkaConnectAsyncClient client, ListCustomPluginsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCustomPluginsPublisher(KafkaConnectAsyncClient client, ListCustomPluginsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCustomPluginsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCustomPluginsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CustomPluginSummary> customPlugins() {
        Function<ListCustomPluginsResponse, Iterator> getIterator = response -> {
            if (response != null && response.customPlugins() != null) {
                return response.customPlugins().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCustomPluginsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCustomPluginsResponseFetcher
    implements AsyncPageFetcher<ListCustomPluginsResponse> {
        private ListCustomPluginsResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomPluginsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCustomPluginsResponse> nextPage(ListCustomPluginsResponse previousPage) {
            if (previousPage == null) {
                return ListCustomPluginsPublisher.this.client.listCustomPlugins(ListCustomPluginsPublisher.this.firstRequest);
            }
            return ListCustomPluginsPublisher.this.client.listCustomPlugins((ListCustomPluginsRequest)((Object)ListCustomPluginsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

